<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Avicampo')); ?></title>
    <link rel="icon" href="<?php echo e(asset('imagenes/favicon.svg')); ?>" sizes="32x32" />
    <link rel="icon" href="<?php echo e(asset('imagenes/favicon.svg')); ?>" sizes="192x192" />
    <link rel="apple-touch-icon" href="<?php echo e(asset('imagenes/favicon.svg')); ?>" />

    <!-- Fonts -->
    <link rel="stylesheet" href="<?php echo e(asset('vendor/fontawesome/css/all.min.css')); ?>">

    <!-- Styles -->
    <link rel="stylesheet" href="<?php echo e(asset('vendor/materialize/css/materialize.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('vendor/material.io/material-components-web.min.css')); ?>">
    <?php echo $__env->yieldContent('styles'); ?>
    <link href="<?php echo e(asset('css/styles.css')); ?>?1.0.0" rel="stylesheet">
</head>
<body>
    <aside class="mdc-drawer mdc-drawer--dense mdc-drawer--dismissible mdc-drawer--modal" id="menu">
        <div class="mdc-drawer__header">
            <div class="avicampo-avatar center">
                <img src="<?php echo e(asset('imagenes/logos/avicampo-logo.png')); ?>" alt="">
            </div>
            <p class="subtitle subtitle-3 capitalize center my-0 nowrap"><?php echo e(mb_strtolower(Auth::user()->nombre)); ?></p>
            <label class="margin-auto nowrap capitalize"><?php echo e((Auth::user()->cargo ? mb_strtolower(Auth::user()->cargo->descripcion) . ' - ' : '') . (Auth::user()->regional ? Auth::user()->regional->nombre : 'Común')); ?></label>
            <hr class="mb-0 mt-2">
        </div>
        <div class="mdc-drawer__content">
            <div class="mdc-list">
                <a id="dashboard" class="mdc-list-item" href="<?php echo e(route('dashboard')); ?>">
                    <span class="mdc-list-item__ripple"></span>
                    <i class="mdc-list-item__graphic mr-2" aria-hidden="true"><i class="fas fa-file-alt"></i></i>
                    <span class="mdc-list-item__text">Inicio</span>
                </a>
                <?php if(Auth::user()->rol_id < 4): ?>
                    <a id="documentos-index" class="mdc-list-item" href="<?php echo e(route('documentos.index')); ?>">
                        <span class="mdc-list-item__ripple"></span>
                        <i class="mdc-list-item__graphic mr-2" aria-hidden="true"><i class="fas fa-list"></i></i>
                        <span class="mdc-list-item__text">Todos los Documentos</span>
                    </a>
                    <a id="documentos-create" class="mdc-list-item" href="<?php echo e(route('documentos.create')); ?>">
                        <span class="mdc-list-item__ripple"></span>
                        <i class="mdc-list-item__graphic mr-2" aria-hidden="true"><i class="fas fa-upload"></i></i>
                        <span class="mdc-list-item__text">Cargar Documento</span>
                    </a>
                <?php endif; ?>
                <?php if(Auth::user()->rol_id < 3): ?>
                    <a id="usuarios" class="mdc-list-item" href="<?php echo e(route('usuarios')); ?>">
                        <span class="mdc-list-item__ripple"></span>
                        <i class="mdc-list-item__graphic mr-2" aria-hidden="true"><i class="fas fa-users-cog"></i></i>
                        <span class="mdc-list-item__text">Usuarios</span>
                    </a>
                    <a id="nuevo-usuario" class="mdc-list-item" href="<?php echo e(route('usuarios.crear')); ?>">
                        <span class="mdc-list-item__ripple"></span>
                        <i class="mdc-list-item__graphic mr-2" aria-hidden="true"><i class="fas fa-user-plus"></i></i>
                        <span class="mdc-list-item__text">Nuevo Usuario</span>
                    </a>
                <?php endif; ?>
                <a id="mis-datos" class="mdc-list-item" href="<?php echo e(route('mis-datos')); ?>">
                    <span class="mdc-list-item__ripple"></span>
                    <i class="mdc-list-item__graphic mr-2" aria-hidden="true"><i class="fas fa-user"></i></i>
                    <span class="mdc-list-item__text">Mis Datos</span>
                </a>
                <a id="logout" class="mdc-list-item" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                    <span class="mdc-list-item__ripple"></span>
                    <i class="mdc-list-item__graphic mr-2" aria-hidden="true"><i class="fas fa-sign-out-alt"></i></i>
                    <span class="mdc-list-item__text">Cerrar sesión</span>
                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="hide">
                        <?php echo csrf_field(); ?>
                    </form>
                </a>
            </div>
        </div>
    </aside>
    <div class="mdc-drawer-scrim"></div>
    <main class="main-content container-full" id="main-content">
        <section class="div-main">
            <?php echo $__env->yieldContent('content'); ?>
            <button class="btn btn-floating btn-large waves-effect waves-light" type="button" id="botonMenu"><i class="fas fa-bars"></i></button>
        </section>
        <footer>
            <div class="row mb-0">
                <div class="col s12 m6">
                    <Label>Copyright © <?php echo e(date('Y')); ?> | <a class="link" style="color: var(--mdc-theme-primary);" href="https://avicolaelmadrono.com/" target="_blank">Avicola El Madroño S.A.</a></Label>
                </div>
                <div class="col s12 m6 right-align">
                    <Label>Sistema de Documentos Internos | V 1.2.1</Label>
                </div>
            </div>
        </footer>
    </main>
    <script src="<?php echo e(asset('vendor/jquery/jquery-3.5.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/ip.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/materialize/js/materialize.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/material.io/material-components-web.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/sweetalert2/sweetalert2@10.js')); ?>"></script>
    <script>
        const ip = '<?php echo e(Session::has('ip') ? Session::get('ip') : ''); ?>';
        
        let urlIp = '<?php echo e(route('ajax.ip')); ?>';
        
        validarIp(ip);

        // Instantiate MDC Drawer
        const drawerEl = document.querySelector('.mdc-drawer');
        const drawer = new mdc.drawer.MDCDrawer.attachTo(drawerEl);
        if ($( window ).width() > 1200) {
            drawer.open = true;
        } else {
            drawer.open = false;
        }

        document.querySelector('.mdc-drawer-scrim').addEventListener('click', () => {
            drawer.open = !drawer.open;
        });

        document.querySelector('#botonMenu').addEventListener('click', () => {
            drawer.open = !drawer.open;
        });

        const audioError = new Audio('<?php echo e(asset('sonidos/error.mp3')); ?>');
        const audioErrorGrave = new Audio('<?php echo e(asset('sonidos/error-grave.mp3')); ?>');

        $(window).resize(function() {
            if ($( window ).width() > 1200) {
                drawer.open = true;
            } else {
                drawer.open = false;
            }
        });

        async function validarIp(ip) {
            if (!ip) {
                ip = await getIp();
                console.log(ip);
                console.log(urlIp);
                try {
                    dataIp = await $.ajax({
                        method: 'POST',
                        url: urlIp,
                        context: document.body,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {
                            ip: ip
                        }
                    }).done(function(response) {
                        return response;
                    }).fail(function(error) {
                        console.error(error);
                        return null;
                    });

                    ip = dataIp.ip;
                    if (ip) {
                        M.toast({html: '<span class="mr-3">Se ha establecido la IP ' + ip + '.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'green darken-2 white-text'});
                    }
                } catch(e) {
                    console.error(e);
                    return false;
                }
            }
        }

        // Muestra los errores generales de post
        <?php if(Session::has('error_general') && \Carbon\Carbon::now()->diffInSeconds(Session::get('error_general')['fecha']) < 10): ?>
            Swal.fire({
                title: '<?php echo e(Session::get('error_general')['titulo']); ?>',
                text: '<?php echo e(Session::get('error_general')['mensaje']); ?>',
                icon: 'error'
            });
            <?php
                Session::forget('error_general');
            ?>
        <?php endif; ?>
    </script>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
<?php /**PATH /var/www/documentos/resources/views/layouts/app.blade.php ENDPATH**/ ?>