<?php $__env->startSection('content'); ?>
    <form action="<?php echo e(route('documentos.index')); ?>" type="GET" id="mainForm">
        <input type="hidden" class="hide" name="perPage" id="perPage" value="<?php echo e(Session::get('pagination')); ?>">
        <div class="container-full">
            <div class="row">
                <div class="col s12">
                    <h1 class="title uppercase font-gilroy">Administrar Documentos</h1>
                    <div class="breadcrumbs full-width">
                        <a class="breadcrumb">Dashboard</a>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col s12">
                    <div class="card highlighted">
                        <div class="card-content">
                            <span class="card-title mb-2">Filtros</span>
                            <div class="row mb-0">
                                <div class="col s6 m3 mb-2-s">
                                    <div class="mdc-select mdc-select--outlined mdc-select--superdense full-width <?php echo e($orden ? 'mdc-select--filled' : ''); ?>" id="mdc-select-orden">
                                        <div class="mdc-select__anchor" aria-labelledby="orden-select-label">
                                            <input type="hidden" name="orden" id="orden" class="mdc-select__input-value" value="<?php echo e($orden ? $orden .'|'. $sort : ''); ?>">
                                            <span id="orden__selected-text" class="mdc-select__selected-text capitalize"></span>
                                            <span class="mdc-select__dropdown-icon">
                                                <svg class="mdc-select__dropdown-icon-graphic" viewBox="7 10 10 5">
                                                    <polygon class="mdc-select__dropdown-icon-inactive" stroke="none" fill-rule="evenodd" points="7 10 12 15 17 10"></polygon>
                                                    <polygon class="mdc-select__dropdown-icon-active" stroke="none" fill-rule="evenodd" points="7 15 12 10 17 15"></polygon>
                                                </svg>
                                            </span>
                                            <span class="mdc-notched-outline">
                                                <span class="mdc-notched-outline__leading"></span>
                                                <span class="mdc-notched-outline__notch">
                                                    <span id="orden-select-label" class="mdc-floating-label <?php echo e($orden ? 'mdc-floating-label--float-above' : ''); ?>">Ordenar Por</span>
                                                </span>
                                                <span class="mdc-notched-outline__trailing"></span>
                                            </span>
                                        </div>
                                        <!-- Other elements from the select remain. -->
                                        <div class="mdc-select__menu mdc-menu mdc-menu-surface mdc-menu--dense" role="listbox">
                                            <ul class="mdc-list">
                                                <li class="mdc-list-item capitalize <?php echo e($orden .'|'. $sort == 'doc.codigo|asc' ? 'mdc-list-item--selected' : ''); ?>" <?php echo e($orden .'|'. $sort == 'doc.codigo|asc' ? 'aria-selected="true"' : ''); ?> data-value="doc.codigo|asc" role="option">
                                                    <span class="mdc-list-item__ripple"></span>
                                                    <span class="mdc-list-item__text capitallize">Código</span>
                                                </li>
                                                <li class="mdc-list-item capitalize <?php echo e($orden .'|'. $sort == 'doc.descripcion|asc' ? 'mdc-list-item--selected' : ''); ?>" <?php echo e($orden .'|'. $sort == 'doc.descripcion|asc' ? 'aria-selected="true"' : ''); ?> data-value="doc.descripcion|asc" role="option">
                                                    <span class="mdc-list-item__ripple"></span>
                                                    <span class="mdc-list-item__text capitallize">Descripción</span>
                                                </li>
                                                <li class="mdc-list-item capitalize <?php echo e($orden .'|'. $sort == 'doc.created_at|asc' ? 'mdc-list-item--selected' : ''); ?>" <?php echo e($orden .'|'. $sort == 'doc.created_at|asc' ? 'aria-selected="true"' : ''); ?> data-value="doc.created_at|asc" role="option">
                                                    <span class="mdc-list-item__ripple"></span>
                                                    <span class="mdc-list-item__text capitallize">Más Antiguos Primero</span>
                                                </li>
                                                <li class="mdc-list-item capitalize <?php echo e($orden .'|'. $sort == 'doc.created_at|desc' ? 'mdc-list-item--selected' : ''); ?>" <?php echo e($orden .'|'. $sort == 'doc.created_at|desc' ? 'aria-selected="true"' : ''); ?> data-value="doc.created_at|desc" role="option">
                                                    <span class="mdc-list-item__ripple"></span>
                                                    <span class="mdc-list-item__text capitallize">Más Recientes Primero</span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col s6 m3 mb-2-s">
                                    <div class="mdc-select mdc-select--outlined mdc-select--superdense full-width <?php echo e($tipo ? 'mdc-select--filled' : ''); ?>" id="mdc-select-tipo">
                                        <div class="mdc-select__anchor" aria-labelledby="tipo-select-label">
                                            <input type="hidden" name="tipo" id="tipo" class="mdc-select__input-value" value="<?php echo e($tipo ? $tipo : ''); ?>">
                                            <span id="tipo__selected-text" class="mdc-select__selected-text capitalize"><?php echo e($tipo ? $tipo : ''); ?></span>
                                            <span class="mdc-select__dropdown-icon">
                                                <svg class="mdc-select__dropdown-icon-graphic" viewBox="7 10 10 5">
                                                    <polygon class="mdc-select__dropdown-icon-inactive" stroke="none" fill-rule="evenodd" points="7 10 12 15 17 10"></polygon>
                                                    <polygon class="mdc-select__dropdown-icon-active" stroke="none" fill-rule="evenodd" points="7 15 12 10 17 15"></polygon>
                                                </svg>
                                            </span>
                                            <span class="mdc-notched-outline">
                                                <span class="mdc-notched-outline__leading"></span>
                                                <span class="mdc-notched-outline__notch">
                                                    <span id="tipo-select-label" class="mdc-floating-label <?php echo e($tipo ? 'mdc-floating-label--float-above' : ''); ?>">Categoría</span>
                                                </span>
                                                <span class="mdc-notched-outline__trailing"></span>
                                            </span>
                                        </div>
                                        <!-- Other elements from the select remain. -->
                                        <div class="mdc-select__menu mdc-menu mdc-menu-surface mdc-menu--dense" role="listbox">
                                            <ul class="mdc-list">
                                                <li class="mdc-list-item <?php echo e($tipo ? '' : 'mdc-list-item--selected'); ?>" <?php echo e($tipo ? '' : 'aria-selected="true"'); ?> data-value="" role="option">
                                                    <span class="mdc-list-item__ripple"></span>
                                                    <span class="mdc-list-item__text"></span>
                                                </li>
                                                <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="mdc-list-item capitalize <?php echo e($tipo == $cat->id ? 'mdc-list-item--selected' : ''); ?>" <?php echo e($tipo == $cat->id ? 'aria-selected="true"' : ''); ?> data-value="<?php echo e($cat->id); ?>" role="option">
                                                        <span class="mdc-list-item__ripple"></span>
                                                        <span class="mdc-list-item__text capitallize"><?php echo e(mb_strtolower($cat->descripcion)); ?></span>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col s6 m3 mb-2-s">
                                    <label class="mdc-text-field mdc-text-field--outlined mdc-text-field--superdense" id="mdc-nombre">
                                        <input type="text" class="mdc-text-field__input" aria-labelledby="lbl_nombre" name="nombre" id="nombre" value="<?php echo e($nombre); ?>">
                                        <span class="mdc-notched-outline">
                                            <span class="mdc-notched-outline__leading"></span>
                                            <span class="mdc-notched-outline__notch">
                                                <span class="mdc-floating-label" id="lbl_nombre">Código o Descripción</span>
                                            </span>
                                            <span class="mdc-notched-outline__trailing"></span>
                                        </span>
                                    </label>
                                </div>
                                <div class="col s6 m3">
                                    <a class="mdc-button mdc-button--raised mdc-button--dense full-width" href="<?php echo e(route('dashboard')); ?>">
                                        <span class="mdc-button__label">Reiniciar Filtros</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col s12">
                    <div class="mdc-data-table mdc-data-table--dense card full-width">
                        <div class="mdc-data-table__table-container">
                            <table class="mdc-data-table__table" aria-label="Listado de bodegas">
                                <thead>
                                    <tr class="mdc-data-table__header-row">
                                        <th class="mdc-data-table__header-cell pr-0" role="columnheader" scope="col"></th>
                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Código</th>
                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Descripción</th>
                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Categoría</th>
                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Creación</th>
                                        <th class="mdc-data-table__header-cell mdc-data-table__header-cell--numeric" role="columnheader" scope="col">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody class="mdc-data-table__content">
                                    <?php $__empty_1 = true; $__currentLoopData = $documentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $documento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr class="mdc-data-table__row">
                                            <td class="mdc-data-table__cell pr-0 center">
                                                <i class="fz-18 <?php echo e($documento->tipo ? 'far fa-file-'.$documento->tipo : 'fas fa-exclamation'); ?> icon-<?php echo e($documento->tipo ? $documento->tipo : 'alt'); ?>"></i>
                                            </td>
                                            <td class="mdc-data-table__cell noselect">
                                                <a class="link link-<?php echo e($documento->tipo ? $documento->tipo : 'alt'); ?>" href="<?php echo e(route('documentos.show', ['codigo' => $documento->codigo])); ?>"><?php echo e(mb_strtoupper($documento->codigo) . ($documento->version ? ' V'. $documento->version : '')); ?></a>
                                            </td>
                                            <td class="mdc-data-table__cell noselect"><?php echo e(ucfirst(mb_strtolower($documento->descripcion))); ?></td>
                                            <td class="mdc-data-table__cell noselect"><?php echo e(ucfirst(mb_strtolower($documento->categoria))); ?></td>
                                            <td class="mdc-data-table__cell noselect"><?php echo e(date('d/m/Y', strtotime($documento->created_at))); ?></td>
                                            <td class="mdc-data-table__cell noselect mdc-data-table__header-cell--numeric">
                                                <a class="link link-primary mr-2" href="<?php echo e(route('documentos.edit', ['codigo' => $documento->codigo])); ?>">
                                                    Editar<i style="margin-left: 5px" class="fz-16 fas fa-pen"></i>
                                                </a>
                                                <a class="link link-primary" href="<?php echo e(route('documentos.version', ['codigo' => $documento->codigo])); ?>">
                                                    Versión<i style="margin-left: 5px" class="fz-16 fas fa-file-upload"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr class="mdc-data-table__row">
                                            <th class="mdc-data-table__cell center" scope="row" colspan="6">No hay documentos.</th>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <?php if($documentos->count() > 0): ?>
                            <div class="mdc-data-table__pagination">
                                <div class="mdc-data-table__pagination-trailing full-width row no-margin">
                                    <div class="mdc-data-table__pagination-rows-per-page col s12 m6 mr-0">
                                        <div class="mdc-data-table__pagination-rows-per-page-label">Filas por página</div>
                                        <div>
                                            <div class="mdc-select mdc-select--outlined mdc-select--no-label mdc-data-table__pagination-rows-per-page-select" id="select-datatable">
                                                <div class="mdc-select__anchor" role="button" aria-haspopup="listbox" aria-labelledby="demo-pagination-select" tabindex="0">
                                                    <span class="mdc-notched-outline mdc-notched-outline--notched">
                                                        <span class="mdc-notched-outline__leading"></span>
                                                        <span class="mdc-notched-outline__trailing"></span>
                                                    </span>
                                                    <span class="mdc-select__selected-text-container">
                                                        <span id="demo-pagination-select" class="mdc-select__selected-text"><?php echo e(Session::get('pagination')); ?></span>
                                                    </span>
                                                    <span class="mdc-select__dropdown-icon">
                                                        <svg class="mdc-select__dropdown-icon-graphic" viewBox="7 10 10 5">
                                                            <polygon class="mdc-select__dropdown-icon-inactive" stroke="none" fill-rule="evenodd" points="7 10 12 15 17 10"></polygon>
                                                            <polygon class="mdc-select__dropdown-icon-active" stroke="none" fill-rule="evenodd" points="7 15 12 10 17 15"></polygon>
                                                        </svg>
                                                    </span>
                                                </div>
                                                <div class="mdc-select__menu mdc-menu mdc-menu-surface mdc-menu-surface--fullwidth" role="listbox">
                                                    <ul class="mdc-list">
                                                        <li class="mdc-list-item <?php echo e(Session::get('pagination') == 10 ? 'mdc-list-item--selected' : ''); ?>" aria-selected="true" role="option" data-value="10">
                                                            <span class="mdc-list-item__text">10</span>
                                                        </li>
                                                        <li class="mdc-list-item <?php echo e(Session::get('pagination') == 25 ? 'mdc-list-item--selected' : ''); ?>" role="option" data-value="25">
                                                            <span class="mdc-list-item__text">25</span>
                                                        </li>
                                                        <li class="mdc-list-item <?php echo e(Session::get('pagination') == 50 ? 'mdc-list-item--selected' : ''); ?>" role="option" data-value="50">
                                                            <span class="mdc-list-item__text">50</span>
                                                        </li>
                                                        <li class="mdc-list-item <?php echo e(Session::get('pagination') == 100 ? 'mdc-list-item--selected' : ''); ?>" role="option" data-value="100">
                                                            <span class="mdc-list-item__text">100</span>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mdc-data-table__pagination-total"><?php echo e($documentos->firstItem()); ?> ‑ <?php echo e($documentos->lastItem() . ' de ' . $documentos->total()); ?></div>
                                    </div>
                                    <div class="mdc-data-table__pagination-navigation col s12 m6 mb-1-s">
                                        <?php if($documentos->hasPages()): ?>
                                            <a class="mdc-icon-button mdc-data-table__pagination-button  <?php echo e($documentos->onFirstPage() ? 'disabled' : ''); ?>" href="<?php echo e($documentos->withQueryString()->url(1)); ?>" data-first-page="true">
                                                <div class="mdc-button__icon"><i class="fas fa-step-backward"></i></div>
                                            </a>
                                            <a class="mdc-icon-button mdc-data-table__pagination-button <?php echo e($documentos->onFirstPage() ? 'disabled' : ''); ?>" href="<?php echo e($documentos->withQueryString()->previousPageUrl()); ?>" data-prev-page="true">
                                                <div class="mdc-button__icon"><i class="fas fa-chevron-left"></i></div>
                                            </a>
                                            <?php for($i = $documentos->currentPage() - 2; $i <= $documentos->currentPage() + 2; $i++): ?>
                                                <?php if($i > 0 && $i <= $documentos->lastPage()): ?>
                                                    <a class="mdc-icon-button mdc-data-table__pagination-button <?php echo e($i == $documentos->currentPage() ? 'disabled current' : ''); ?>" href="<?php echo e($documentos->withQueryString()->url($i)); ?>">
                                                        <div class="mdc-button__icon"><?php echo e($i); ?></div>
                                                    </a>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                            <a class="mdc-icon-button mdc-data-table__pagination-button <?php echo e($documentos->hasMorePages() ? '' : 'disabled'); ?>" href="<?php echo e($documentos->withQueryString()->nextPageUrl()); ?>" data-next-page="true">
                                                <div class="mdc-button__icon"><i class="fas fa-chevron-right"></i></div>
                                            </a>
                                            <a class="mdc-icon-button mdc-data-table__pagination-button <?php echo e($documentos->hasMorePages() ? '' : 'disabled'); ?>" href="<?php echo e($documentos->withQueryString()->url($documentos->lastPage())); ?>" data-last-page="true">
                                                <div class="mdc-button__icon"><i class="fas fa-step-forward"></i></div>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $('#documentos-index').addClass('mdc-list-item--active');

        let urlDesargar = '<?php echo e(route('ajax.descargar')); ?>';

        const dataTable = new mdc.dataTable.MDCDataTable(document.querySelector('.mdc-data-table'));
        const selectOrden = new mdc.select.MDCSelect(document.querySelector('#mdc-select-orden'));
        const selectTipo = new mdc.select.MDCSelect(document.querySelector('#mdc-select-tipo'));
        const nombre = new mdc.textField.MDCTextField(document.querySelector('#mdc-nombre'));
        <?php if($documentos->count() > 0): ?>
            const selectDatable = new mdc.select.MDCSelect(document.querySelector('#select-datatable'));
        <?php endif; ?>

        /* Filtros */
        $('#nombre').on('change', function() {
            $('#mainForm').submit();
        });

        selectOrden.listen('MDCSelect:change', (el) => {
            $('#orden').val(selectOrden.value);
            $('#mainForm').submit();
        });

        selectTipo.listen('MDCSelect:change', (el) => {
            $('#tipo').val(selectTipo.value);
            $('#mainForm').submit();
        });

        <?php if($documentos->count() > 0): ?>
            selectDatable.listen('MDCSelect:change', (el) => {
                $('#perPage').val(selectDatable.value);
                $('#mainForm').submit();
            });
        <?php endif; ?>

        $('.link-download').click(function() {
            let id = $(this).data('id');
            $.ajax({
                method: 'POST',
                url: urlDesargar,
                context: document.body,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    id: id
                }
            }).done(function(response){
                console.log(response);
                M.toast({html: '<span class="mr-3">Descargando "' + response.documento.descripcion + '".</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'green darken-2 white-text'});
            }).fail(function(error){
                console.error(error);
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/documentos/resources/views/documentos/index.blade.php ENDPATH**/ ?>