<?php $__env->startSection('content'); ?>
    <form action="<?php echo e(route('usuarios.eliminar', ['documento' => $usuario->documento])); ?>" method="post" accept-charset="UTF-8">
        <?php echo csrf_field(); ?>
        <div class="container-full">
            <div class="row">
                <div class="col s12 m8">
                    <h1 class="title uppercase font-gilroy"><?php echo e($usuario->nombre); ?></h1>
                    <div class="breadcrumbs full-width">
                        <a href="<?php echo e(route('dashboard')); ?>" class="breadcrumb">Dashboard</a>
                        <a href="<?php echo e(route('usuarios')); ?>" class="breadcrumb">Usuarios</a>
                        <a href="<?php echo e(route('usuarios.ver', ['documento' => $usuario->documento])); ?>" class="breadcrumb"><?php echo e($usuario->documento); ?></a>
                        <a class="breadcrumb">Eliminar</a>
                    </div>
                </div>
                <div class="col m4 right-align mt-2-s hide-on-small-only">
                    <button class="mdc-button mdc-button--raised mdc-button--large" id="" type="submit">
                        <span class="mdc-button__label mr-1">Eliminar</span>
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </div>
            <div class="row mb-0 mt-3" id="listado_cargues" class="display responsive" width="100%" style="width:100%">
                <div class="col s12">
                    <div class="card highlighted mb-0">
                        <div class="card-content">
                            <h2 class="title subtitle uppercase center font-gilroy mb-3">Eliminar a <?php echo e($usuario->nombre); ?></h2>
                            <p class="justify">
                                Esta acción desactivará al usuario <b><?php echo e(mb_strtoupper($usuario->nombre)); ?></b> con documento <b><?php echo e($usuario->documento); ?></b> y quien tiene rol de <b><?php echo e(mb_strtoupper($usuario->rol->descripcion)); ?></b> en el sistema.
                                La ejecución de esta acción será registrada y solo se podrá revertir por un desarrollador. Esta acción no borrará las acciones registradas por el usuario mientras este estuvo activo.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mb-0 mt-2">
                <div class="col s12">
                    <a class="mdc-button mdc-button--outlined mdc-button--large" href="<?php echo e(route('usuarios')); ?>">
                        <span class="mdc-button__label mr-1">Volver</span>
                        <i class="fas fa-reply"></i>
                    </a>
                    <button class="mdc-button mdc-button--raised mdc-button--large" id="" type="submit">
                        <span class="mdc-button__label mr-1">Eliminar</span>
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $('#<?php echo e($usuario->id == Auth::id() ? 'mis-datos' : 'usuarios'); ?>').addClass('mdc-list-item--active');

        let urlDesargar = '<?php echo e(route('ajax.descargar')); ?>';
        
        <?php if(Auth::user()->rol_id < 3): ?>
            const menu = new mdc.menu.MDCMenu(document.querySelector('.mdc-menu'));
            menu.setAnchorCorner(mdc.menu.Corner.BOTTOM_LEFT);
            document.querySelector('#menu-button').addEventListener('click', () => menu.open = !menu.open);
        <?php endif; ?>

        $('.link-download').click(function() {
            let id = $(this).data('id');
            $.ajax({
                method: 'POST',
                url: urlDesargar,
                context: document.body,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    id: id
                }
            }).done(function(response){
                console.log(response);
                M.toast({html: '<span class="mr-3">Descargando "' + response.documento.descripcion + '".</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'green darken-2 white-text'});
            }).fail(function(error){
                console.error(error);
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/documentos/resources/views/usuarios/eliminar.blade.php ENDPATH**/ ?>