<?php
    setlocale(LC_ALL, 'es_ES');
    \Carbon\Carbon::setLocale('es');
?>

<?php $__env->startSection('content'); ?>
    <form action="<?php echo e(route('usuarios.traceability', ['documento' => $usuario->documento])); ?>" type="GET" id="mainForm">
        <input type="hidden" class="hide" name="perPage" id="perPage" value="<?php echo e(Session::get('pagination')); ?>">
        <div class="container-full">
            <div class="row">
                <div class="col s12 m8">
                    <h1 class="title uppercase font-gilroy"><?php echo e($usuario->nombre); ?></h1>
                    <div class="breadcrumbs full-width">
                        <a href="<?php echo e(route('dashboard')); ?>" class="breadcrumb">Dashboard</a>
                        <?php if($usuario->id == Auth::id()): ?>
                            <a href="<?php echo e(route('mis-datos')); ?>" class="breadcrumb">Mis Datos</a>
                        <?php else: ?>
                            <a href="<?php echo e(route('usuarios')); ?>" class="breadcrumb">Usuarios</a>
                            <a href="<?php echo e(route('usuarios.ver', ['documento' => $usuario->documento])); ?>" class="breadcrumb"><?php echo e($usuario->documento); ?></a>
                        <?php endif; ?>
                        <a class="breadcrumb">Movimientos</a>
                    </div>
                </div>
                <div class="col s12 m4 right-align mt-2-s">
                    <a class="mdc-button mdc-button--raised mdc-button--large" href="<?php echo e(route('usuarios.crear')); ?>">
                        <span class="mdc-button__label mr-1">Nuevo Usuario</span>
                        <i class="fas fa-user-plus"></i>
                    </a>
                </div>
            </div>
            <div class="row">
                <div class="col s12">
                    <div class="card highlighted">
                        <div class="card-content">
                            <span class="card-title mb-2">Filtros</span>
                            <div class="row mb-0">
                                <div class="col s6 m3 mb-2-s">
                                    <label class="mdc-text-field mdc-text-field--outlined mdc-text-field--superdense mdc-text-field--label-floating" id="mdc-fecha_inicial">
                                        <input type="date" class="mdc-text-field__input" aria-labelledby="lbl_fecha_inicial" id="fecha_inicial" name="fecha_inicial" max="<?php echo e($hoy->toDateString()); ?>" value="<?php echo e($fecha_inicial); ?>">
                                        <span class="mdc-notched-outline">
                                            <span class="mdc-notched-outline__leading"></span>
                                            <span class="mdc-notched-outline__notch">
                                                <span class="mdc-floating-label mdc-floating-label--float-above" id="lbl_fecha_inicial">Fecha Inicial</span>
                                            </span>
                                            <span class="mdc-notched-outline__trailing"></span>
                                        </span>
                                    </label>
                                </div>
                                <div class="col s6 m3 mb-2-s">
                                    <label class="mdc-text-field mdc-text-field--outlined mdc-text-field--superdense mdc-text-field--label-floating" id="mdc-fecha_final">
                                        <input type="date" class="mdc-text-field__input" aria-labelledby="lbl_fecha_final" id="fecha_final" name="fecha_final" max="<?php echo e($hoy->toDateString()); ?>" value="<?php echo e($fecha_final); ?>">
                                        <span class="mdc-notched-outline">
                                            <span class="mdc-notched-outline__leading"></span>
                                            <span class="mdc-notched-outline__notch">
                                                <span class="mdc-floating-label mdc-floating-label--float-above" id="lbl_fecha_final">Fecha Final</span>
                                            </span>
                                            <span class="mdc-notched-outline__trailing"></span>
                                        </span>
                                    </label>
                                </div>
                                <div class="col s6 m3 no-line-height">
                                    <div class="mdc-select mdc-select--outlined mdc-select--superdense full-width <?php echo e($accion ? 'mdc-select--filled' : ''); ?>" id="mdc-select-accion">
                                        <div class="mdc-select__anchor" aria-labelledby="accion-select-label">
                                            <input type="hidden" name="accion" id="accion" class="mdc-select__input-value" value="<?php echo e($accion ? $accion : ''); ?>">
                                            <span id="accion__selected-text" class="mdc-select__selected-text capitalize"><?php echo e($accion ? $accion : ''); ?></span>
                                            <span class="mdc-select__dropdown-icon">
                                                <svg class="mdc-select__dropdown-icon-graphic" viewBox="7 10 10 5">
                                                    <polygon class="mdc-select__dropdown-icon-inactive" stroke="none" fill-rule="evenodd" points="7 10 12 15 17 10"></polygon>
                                                    <polygon class="mdc-select__dropdown-icon-active" stroke="none" fill-rule="evenodd" points="7 15 12 10 17 15"></polygon>
                                                </svg>
                                            </span>
                                            <span class="mdc-notched-outline">
                                                <span class="mdc-notched-outline__leading"></span>
                                                <span class="mdc-notched-outline__notch">
                                                    <span id="accion-select-label" class="mdc-floating-label <?php echo e($accion ? 'mdc-floating-label--float-above' : ''); ?>">Acción</span>
                                                </span>
                                                <span class="mdc-notched-outline__trailing"></span>
                                            </span>
                                        </div>
                                        <!-- Other elements from the select remain. -->
                                        <div class="mdc-select__menu mdc-menu mdc-menu-surface mdc-menu--dense" role="listbox">
                                            <ul class="mdc-list">
                                                <li class="mdc-list-item <?php echo e($accion ? '' : 'mdc-list-item--selected'); ?>" <?php echo e($accion ? '' : 'aria-selected="true"'); ?> data-value="" role="option">
                                                    <span class="mdc-list-item__ripple"></span>
                                                    <span class="mdc-list-item__text"></span>
                                                </li>
                                                <?php $__currentLoopData = $acciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $AuxAccion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="mdc-list-item capitalize <?php echo e($accion == $AuxAccion->id ? 'mdc-list-item--selected' : ''); ?>" <?php echo e($accion == $AuxAccion->id ? 'aria-selected="true"' : ''); ?> data-value="<?php echo e($AuxAccion->id); ?>" role="option">
                                                        <span class="mdc-list-item__ripple"></span>
                                                        <span class="mdc-list-item__text capitallize"><?php echo e(mb_strtolower($AuxAccion->descripcion)); ?></span>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col s6 m3">
                                    <a class="mdc-button mdc-button--raised mdc-button--dense full-width" href="<?php echo e(route('usuarios.traceability', ['documento' => $usuario->documento])); ?>">
                                        <span class="mdc-button__label">Reiniciar Filtros</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col s12">
                    <div class="mdc-data-table mdc-data-table--dense card full-width">
                        <div class="mdc-data-table__table-container">
                            <table class="mdc-data-table__table" aria-label="Listado de bodegas">
                                <thead>
                                    <tr class="mdc-data-table__header-row">
                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Fecha</th>
                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Acción</th>
                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Módulo</th>
                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Descripción</th>
                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Ip</th>
                                    </tr>
                                </thead>
                                <tbody class="mdc-data-table__content">
                                    <?php $__empty_1 = true; $__currentLoopData = $auditorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $auditoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr class="mdc-data-table__row" data-id="<?php echo e($auditoria->id); ?>">
                                            <td class="mdc-data-table__cell">
                                                <?php switch(\Carbon\Carbon::parse($auditoria->created_at)->startOfDay()->diffInDays($hoy->startOfDay(), false)):
                                                    case (0): ?>
                                                        Hoy
                                                        <?php break; ?>
                                                    <?php case (1): ?>
                                                        Ayer
                                                        <?php break; ?>
                                                    <?php default: ?>
                                                        <?php echo e(mb_substr(ucfirst(\Carbon\Carbon::parse($auditoria->created_at)->dayName), 0, 3) .', '. \Carbon\Carbon::parse($auditoria->created_at)->day . ' de '. ucfirst(\Carbon\Carbon::parse($auditoria->created_at)->monthName)); ?>

                                                <?php endswitch; ?>
                                                <br/>
                                                <span class="nowrap"><?php echo e(date('h:i a', strtotime($auditoria->created_at))); ?></span>
                                            </td>
                                            <td class="mdc-data-table__cell noselect"><?php echo e($auditoria->accion->descripcion); ?></td>
                                            <td class="mdc-data-table__cell noselect"><?php echo e($auditoria->modulo); ?></td>
                                            <td class="mdc-data-table__cell noselect">
                                                <?php if($auditoria->observacion): ?>
                                                    <?php echo e($auditoria->observacion); ?>

                                                <?php else: ?>
                                                    <?php echo e($auditoria->accion->descripcion); ?> del <?php echo e(mb_strtolower(substr($auditoria->modulo, 0, -1))); ?> 
                                                    <?php if($auditoria->usuario2): ?>
                                                        <?php echo e($auditoria->usuario2->nombre); ?> con documento <?php echo e($auditoria->usuario2->documento); ?>

                                                    <?php elseif($auditoria->documento): ?>
                                                        <?php echo e($auditoria->documento->codigo .' -> '. $auditoria->documento->descripcion); ?>

                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                            <td class="mdc-data-table__cell noselect"><?php echo e($auditoria->ip); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr class="mdc-data-table__row">
                                            <th class="mdc-data-table__cell center" scope="row" colspan="5">No hay movimientos.</th>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <?php if($auditorias->count() > 0): ?>
                            <div class="mdc-data-table__pagination">
                                <div class="mdc-data-table__pagination-trailing full-width row no-margin">
                                    <div class="mdc-data-table__pagination-rows-per-page col s12 m6 mr-0">
                                        <div class="mdc-data-table__pagination-rows-per-page-label">Filas por página</div>
                                        <div>
                                            <div class="mdc-select mdc-select--outlined mdc-select--no-label mdc-data-table__pagination-rows-per-page-select" id="select-datatable">
                                                <div class="mdc-select__anchor" role="button" aria-haspopup="listbox" aria-labelledby="demo-pagination-select" tabindex="0">
                                                    <span class="mdc-notched-outline mdc-notched-outline--notched">
                                                        <span class="mdc-notched-outline__leading"></span>
                                                        <span class="mdc-notched-outline__trailing"></span>
                                                    </span>
                                                    <span class="mdc-select__selected-text-container">
                                                        <span id="demo-pagination-select" class="mdc-select__selected-text"><?php echo e(Session::get('pagination')); ?></span>
                                                    </span>
                                                    <span class="mdc-select__dropdown-icon">
                                                        <svg class="mdc-select__dropdown-icon-graphic" viewBox="7 10 10 5">
                                                            <polygon class="mdc-select__dropdown-icon-inactive" stroke="none" fill-rule="evenodd" points="7 10 12 15 17 10"></polygon>
                                                            <polygon class="mdc-select__dropdown-icon-active" stroke="none" fill-rule="evenodd" points="7 15 12 10 17 15"></polygon>
                                                        </svg>
                                                    </span>
                                                </div>
                                                <div class="mdc-select__menu mdc-menu mdc-menu-surface mdc-menu-surface--fullwidth" role="listbox">
                                                    <ul class="mdc-list">
                                                        <li class="mdc-list-item <?php echo e(Session::get('pagination') == 10 ? 'mdc-list-item--selected' : ''); ?>" aria-selected="true" role="option" data-value="10">
                                                            <span class="mdc-list-item__text">10</span>
                                                        </li>
                                                        <li class="mdc-list-item <?php echo e(Session::get('pagination') == 25 ? 'mdc-list-item--selected' : ''); ?>" role="option" data-value="25">
                                                            <span class="mdc-list-item__text">25</span>
                                                        </li>
                                                        <li class="mdc-list-item <?php echo e(Session::get('pagination') == 50 ? 'mdc-list-item--selected' : ''); ?>" role="option" data-value="50">
                                                            <span class="mdc-list-item__text">50</span>
                                                        </li>
                                                        <li class="mdc-list-item <?php echo e(Session::get('pagination') == 100 ? 'mdc-list-item--selected' : ''); ?>" role="option" data-value="100">
                                                            <span class="mdc-list-item__text">100</span>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mdc-data-table__pagination-total"><?php echo e($auditorias->firstItem()); ?> ‑ <?php echo e($auditorias->lastItem() . ' de ' . $auditorias->total()); ?></div>
                                    </div>
                                    <div class="mdc-data-table__pagination-navigation col s12 m6 mb-1-s">
                                        <?php if($auditorias->hasPages()): ?>
                                            <a class="mdc-icon-button mdc-data-table__pagination-button  <?php echo e($auditorias->onFirstPage() ? 'disabled' : ''); ?>" href="<?php echo e($auditorias->withQueryString()->url(1)); ?>" data-first-page="true">
                                                <div class="mdc-button__icon"><i class="fas fa-step-backward"></i></div>
                                            </a>
                                            <a class="mdc-icon-button mdc-data-table__pagination-button <?php echo e($auditorias->onFirstPage() ? 'disabled' : ''); ?>" href="<?php echo e($auditorias->withQueryString()->previousPageUrl()); ?>" data-prev-page="true">
                                                <div class="mdc-button__icon"><i class="fas fa-chevron-left"></i></div>
                                            </a>
                                            <?php for($i = $auditorias->currentPage() - 2; $i <= $auditorias->currentPage() + 2; $i++): ?>
                                                <?php if($i > 0 && $i <= $auditorias->lastPage()): ?>
                                                    <a class="mdc-icon-button mdc-data-table__pagination-button <?php echo e($i == $auditorias->currentPage() ? 'disabled current' : ''); ?>" href="<?php echo e($auditorias->withQueryString()->url($i)); ?>">
                                                        <div class="mdc-button__icon"><?php echo e($i); ?></div>
                                                    </a>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                            <a class="mdc-icon-button mdc-data-table__pagination-button <?php echo e($auditorias->hasMorePages() ? '' : 'disabled'); ?>" href="<?php echo e($auditorias->withQueryString()->nextPageUrl()); ?>" data-next-page="true">
                                                <div class="mdc-button__icon"><i class="fas fa-chevron-right"></i></div>
                                            </a>
                                            <a class="mdc-icon-button mdc-data-table__pagination-button <?php echo e($auditorias->hasMorePages() ? '' : 'disabled'); ?>" href="<?php echo e($auditorias->withQueryString()->url($auditorias->lastPage())); ?>" data-last-page="true">
                                                <div class="mdc-button__icon"><i class="fas fa-step-forward"></i></div>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        <?php if($usuario->id == Auth::id()): ?>
            $('#mis-datos').addClass('mdc-list-item--active');
        <?php else: ?>
            $('#usuarios').addClass('mdc-list-item--active');
        <?php endif; ?>

        const dataTable = new mdc.dataTable.MDCDataTable(document.querySelector('.mdc-data-table'));
        const selectAccion = new mdc.select.MDCSelect(document.querySelector('#mdc-select-accion'));
        const fecha_inicial = new mdc.textField.MDCTextField(document.querySelector('#mdc-fecha_inicial'));
        const fecha_final = new mdc.textField.MDCTextField(document.querySelector('#mdc-fecha_final'));
        <?php if($auditorias->count() > 0): ?>
            const selectDatable = new mdc.select.MDCSelect(document.querySelector('#select-datatable'));
        <?php endif; ?>

        /* Filtros */
        $('#fecha_inicial').on('change', function() {
            $('#mainForm').submit();
        });

        $('#fecha_final').on('change', function() {
            $('#mainForm').submit();
        });

        selectAccion.listen('MDCSelect:change', (el) => {
            $('#accion').val(selectAccion.value);
            $('#mainForm').submit();
        });

        <?php if($auditorias->count() > 0): ?>
            selectDatable.listen('MDCSelect:change', (el) => {
                $('#perPage').val(selectDatable.value);
                $('#mainForm').submit();
            });
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/documentos/resources/views/usuarios/traceability.blade.php ENDPATH**/ ?>