<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" style="display: flex;">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Avicampo')); ?></title>
    <link rel="icon" href="<?php echo e(asset('imagenes/favicon.svg')); ?>" sizes="32x32" />
    <link rel="icon" href="<?php echo e(asset('imagenes/favicon.svg')); ?>" sizes="192x192" />
    <link rel="apple-touch-icon" href="<?php echo e(asset('imagenes/favicon.svg')); ?>" />

    <!-- Fonts -->
    <link rel="stylesheet" href="<?php echo e(asset('vendor/fontawesome/css/all.min.css')); ?>">

    <!-- Styles -->
    <link rel="stylesheet" href="<?php echo e(asset('vendor/materialize/css/materialize.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('vendor/material.io/material-components-web.min.css')); ?>">
    <link href="<?php echo e(asset('css/styles.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/login.css')); ?>" rel="stylesheet">
</head>
<body style="display: flex;">
    <div id="login" class="container-full">
        <div class="row full-height mb-0">
            <div id="background-login" class="col s12 l8 xl9 full-height px-0 hide-on-med-and-down" style="background-color: black">
                <div id="slider-login" class="full-height">
                    <img src="<?php echo e(asset('imagenes/login/login.jpg')); ?>" alt="Pollo Asado">
                </div>
            </div>
            <div class="col s12 l4 xl3 full-height valign-wrapper">
                <form method="POST" action="<?php echo e(route('login')); ?>" class="full-width px-4" id="login-form">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="ip" id="ip" class="hide" value="<?php echo e(Session::get('ip')); ?>">
                    <div class="row my-2">
                        <div class="col s12 mb-2 center">
                            <img src="<?php echo e(asset('imagenes/logos/avicampo-logo.png')); ?>" alt="Avicampo Logo" class="card-logo">
                            <h3 class="subtitle mb-2" style="font-family: 'Gilroy';">Sistema de Documentos Internos</h3>
                        </div>
                        <div class="col s12 mb-1">
                            <label class="mdc-text-field mdc-text-field--outlined <?php $__errorArgs = ['documento'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> mdc-text-field--invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <input type="text" class="mdc-text-field__input" aria-labelledby="lbl_documento" name="documento" id="documento" required <?php if(isset($inputs['documento'])): ?> value="<?php echo e($inputs['documento']); ?>" <?php endif; ?>>
                                <span class="mdc-notched-outline">
                                    <span class="mdc-notched-outline__leading"></span>
                                    <span class="mdc-notched-outline__notch">
                                        <span class="mdc-floating-label" id="lbl_documento">Usuario</span>
                                    </span>
                                    <span class="mdc-notched-outline__trailing"></span>
                                </span>
                            </label>
                            <div class="mdc-text-field-helper-line">
                                <div class="mdc-text-field-helper-text mdc-text-field-helper-text--validation-msg" id="my-helper-id" aria-hidden="true">
                                    <?php $__errorArgs = ['documento'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        El usuario no se encuentra registrado
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col s12 mb-1">
                            <label class="mdc-text-field mdc-text-field--outlined <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> mdc-text-field--invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <input type="password" class="mdc-text-field__input" aria-labelledby="lbl_password" name="password" id="password" required>
                                <span class="mdc-notched-outline">
                                    <span class="mdc-notched-outline__leading"></span>
                                    <span class="mdc-notched-outline__notch">
                                        <span class="mdc-floating-label" id="lbl_password">Contraseña</span>
                                    </span>
                                    <span class="mdc-notched-outline__trailing"></span>
                                </span>
                            </label>
                            <div class="mdc-text-field-helper-line">
                                <div class="mdc-text-field-helper-text mdc-text-field-helper-text--validation-msg" id="my-helper-id" aria-hidden="true">
                                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        La contraseña es errónea
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col s12 mb-2">
                            <div class="mdc-touch-target-wrapper">
                                <div class="mdc-checkbox mdc-checkbox--touch">
                                    <input type="checkbox" class="mdc-checkbox__native-control" id="remember" name="remember"/>
                                    <div class="mdc-checkbox__background">
                                        <svg class="mdc-checkbox__checkmark" viewBox="0 0 24 24">
                                            <path class="mdc-checkbox__checkmark-path" fill="none" d="M1.73,12.91 8.1,19.28 22.79,4.59"/>
                                        </svg>
                                        <div class="mdc-checkbox__mixedmark"></div>
                                    </div>
                                    <div class="mdc-checkbox__ripple"></div>
                                </div>
                                <label for="remember" class="noselect nowrap">Mantener la sesión iniciada</label>
                            </div>
                        </div>
                        <div class="col s12 center-align">
                            <button class="mdc-button mdc-button--raised mdc-button--large" id="submit">
                                <span class="mdc-button__label mr-1">Iniciar Sesión</span>
                                <i class="fas fa-sign-in-alt send"></i>
                                <i class="fas fa-spinner sending" style="display: none"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
          </div>
        </div>
    </div>
    <!-- Scripts -->
    <script src="<?php echo e(asset('vendor/jquery/jquery-3.5.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/ip.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/materialize/js/materialize.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/material.io/material-components-web.min.js')); ?>"></script>
    <script type="text/javascript">
        const textFields = [].map.call(document.querySelectorAll('.mdc-text-field'), function(el) {
            return new mdc.textField.MDCTextField(el);
        });
    </script>
    <script type="text/javascript">
        $(document).ready(async function() {
            var imagenSlider = $('#slider-login img');
            if (imagenSlider.width() < $('#slider-login').width()) {
                imagenSlider.attr('width', '100%');
                imagenSlider.attr('height', 'auto');
            }

            $('#login-form').submit(function(){
                $('#submit').attr('disabled', 'disabled');
                $('#submit .send').hide();
                $('#submit .sending').show();
            });

            // Consulta la ip en cloudfare
            <?php if(!Session::has('ip')): ?>
                let ipCliente = await getIp();
                $('#ip').val(ipCliente);
            <?php endif; ?>
        });
    </script>
</body>
</html><?php /**PATH /var/www/documentos/resources/views/auth/login.blade.php ENDPATH**/ ?>