<?php $__env->startSection('content'); ?>
    <div class="container-full">
        <div class="row">
            <div class="col s12">
                <h1 class="title uppercase font-gilroy">LISTADO DE PROCESOS</h1>
                <div class="breadcrumbs full-width">
                    <a class="breadcrumb">Sistema de Documentos Internos</a>
                </div>
            </div>
        </div>
        <div class="row">
            <?php $__currentLoopData = $procesos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $proceso): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($proceso->documentos): ?>
                    <div class="col s12 m6 l4 xl3" class="card-proceso" data-proceso="<?php echo e($proceso->nombre); ?>">
                        <a href="<?php echo e(route('dashboard.proceso', ['proceso' => $proceso->slug])); ?>">
                            <div class="card cursor-pointer full-width" style="display: inline-flex; align-items: center; height: 95px;">
                                <div class="center bg-primary" style="width: 95px; height: 100%; align-items: center; display: flex; justify-content: center;">
                                    <div style="display: grid">
                                        <span class="white-text" style="font-size: 34px; font-weight: 700; line-height: 34px; margin-bottom: 5px;"><?php echo e($proceso->codigo); ?></span>
                                        <i class="fas fa-folder-open white-text" style="font-size: 16px"></i>
                                    </div>
                                </div>
                                <div class="card-content" style="width: calc(100% - 95px);">
                                    <span class="card-title nowrap primary" style="color: initial"><?php echo e($proceso->nombre); ?></span>
                                    <label class="cursor-pointer" style="color: #717171">
                                        <?php switch($proceso->documentos):
                                            case (0): ?>
                                                Sin documentos
                                                <?php break; ?>
                                            <?php case (1): ?>
                                                1 documento
                                                <?php break; ?>
                                            <?php default: ?>
                                                <?php echo e($proceso->documentos); ?> documentos
                                        <?php endswitch; ?>
                                    </label>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <div class="col s12 m6 l4 xl3" class="card-proceso" data-proceso="todos los documentos">
                <a href="<?php echo e(route('dashboard.proceso', ['proceso' => 'todos'])); ?>">
                    <div class="card cursor-pointer full-width" style="display: inline-flex; align-items: center; height: 95px;">
                        <div class="center bg-primary" style="width: 95px; height: 100%; align-items: center; display: flex; justify-content: center;">
                            <div style="display: grid">
                                <span class="white-text" style="font-size: 34px; font-weight: 700; line-height: 34px; margin-bottom: 5px;">ALL</span>
                                <i class="fas fa-folder-open white-text" style="font-size: 16px"></i>
                            </div>
                        </div>
                        <div class="card-content" style="width: calc(100% - 95px);">
                            <span class="card-title nowrap primary" style="color: initial">Todos los Documentos</span>
                            <label class="cursor-pointer" style="color: #717171">
                                <?php switch($total_documentos):
                                    case (0): ?>
                                        Sin documentos
                                        <?php break; ?>
                                    <?php case (1): ?>
                                        1 documento
                                        <?php break; ?>
                                    <?php default: ?>
                                        <?php echo e($total_documentos); ?> documentos
                                <?php endswitch; ?>
                            </label>
                        </div>
                    </div>
                </a>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $('#dashboard').addClass('mdc-list-item--active');
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/documentos/resources/views/dashboard/user.blade.php ENDPATH**/ ?>