<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('vendor/dropify/css/dropify.min.css')); ?>" rel="stylesheet">
    <style>
        .dropify-wrapper {
            height: 164px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <form action="<?php echo e(route('documentos.version', ['codigo' => $documento->codigo])); ?>" method="post" id="version-form" accept-charset="UTF-8" enctype="multipart/form-data" files="true">
        <?php echo csrf_field(); ?>
        <div class="container-full">
            <div class="row">
                <div class="col s12">
                    <h1 class="title uppercase font-gilroy"><?php echo e($documento->descripcion); ?></h1>
                    <div class="breadcrumbs full-width">
                        <a href="<?php echo e(route('dashboard')); ?>" class="breadcrumb">Dashboard</a>
                        <a href="<?php echo e(route('documentos.show', ['codigo' => $documento->codigo])); ?>" class="breadcrumb"><?php echo e($documento->codigo); ?></a>
                        <a href="<?php echo e(route('documentos.edit', ['codigo' => $documento->codigo])); ?>" class="breadcrumb">Editar</a>
                        <a class="breadcrumb">Versión</a>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col s12">
                    <div class="card highlighted">
                        <div class="card-content">
                            <div class="row mb-0">
                                <div class="col s12 mb-1">
                                    <blockquote class="my-0" style="line-height: 25px; height: 25px;">
                                        <h2 class="title subtitle-1 font-gilroy uppercase mb-0">
                                            <b>SUBIR NUEVA VERSIÓN</b>
                                        </h2>
                                    </blockquote>
                                </div>
                            </div>
                            <div class="row mb-0">
                                <div class="col s12 mt-2">
                                    <div class="row mb-0">
                                        <div class="col s8 mb-1">
                                            <label class="mdc-text-field mdc-text-field--outlined mdc-text-field--dense focusable" id="mdc-codigo">
                                                <span class="mdc-notched-outline">
                                                    <span class="mdc-notched-outline__leading"></span>
                                                    <span class="mdc-notched-outline__notch">
                                                        <span class="mdc-floating-label" id="lbl_codigo">Código del Documento</span>
                                                    </span>
                                                    <span class="mdc-notched-outline__trailing"></span>
                                                </span>
                                                <input type="text" class="mdc-text-field__input" aria-labelledby="lbl_codigo" id="codigo" value="<?php echo e(isset($documento) && $documento->codigo ? $documento->codigo : ''); ?>" readonly>
                                            </label>
                                        </div>
                                        <div class="col s4 mb-1">
                                            <label class="mdc-text-field mdc-text-field--outlined mdc-text-field--dense focusable" id="mdc-version">
                                                <span class="mdc-notched-outline">
                                                    <span class="mdc-notched-outline__leading"></span>
                                                    <span class="mdc-notched-outline__notch">
                                                        <span class="mdc-floating-label" id="lbl_version">Versión</span>
                                                    </span>
                                                    <span class="mdc-notched-outline__trailing"></span>
                                                </span>
                                                <input type="text" class="mdc-text-field__input" aria-labelledby="lbl_version" id="version" name="version" value="<?php echo e(old('version') ? old('version') : ''); ?>" required>
                                            </label>
                                            <div class="mdc-text-field-helper-line">
                                                <div class="mdc-text-field-helper-text mdc-text-field-helper-text--validation-msg nowrap" id="mdc-helper-version" aria-hidden="true"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col s12 mt-1 col-dropify">
                                    <label class="dropify-label">Archivo</label>
                                    <input type="file" class="dropify" id="archivo" name="archivo" accept=".pdf,.doc,.docx,.xls,.xlsx,.ppt,.pptx" data-allowed-file-extensions="pdf doc docx xls xlsx ppt pptx" data-default-file="<?php echo e(isset($documento) && $documento->url && Storage::disk('private')->exists($documento->url) ? Storage::disk('private')->url($documento->url) : ''); ?>"/>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mb-0 mt-2">
                <div class="col s12">
                    <a class="mdc-button mdc-button--outlined mdc-button--large" href="<?php echo e(route('dashboard')); ?>">
                        <span class="mdc-button__label mr-1">Volver</span>
                        <i class="fas fa-reply"></i>
                    </a>
                    <button class="mdc-button mdc-button--raised mdc-button--large btn-guardar" id="" type="submit">
                        <span class="mdc-button__label mr-1">Guardar</span>
                        <i class="fas fa-save"></i>
                    </button>
                </div>
            </div>
        </div>
    </form>
    <div class="cargando noselect px-5 center" id="guardando" style="display: none">
        <div id="html-spinner"></div>
        <span class="title mt-1">Guardando Versión</span>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('vendor/dropify/js/dropify.min.js')); ?>"></script>
    <script>
        $('#cargar').addClass('mdc-list-item--active');

        let versiones = <?php echo e($documento->versiones->pluck('version')); ?>;

        const codigo = new mdc.textField.MDCTextField(document.querySelector('#mdc-codigo'));
        const version = new mdc.textField.MDCTextField(document.querySelector('#mdc-version'));

        $('.dropify').dropify({
            messages: {
                'default': 'Arrastra y suelta un archivo aquí o haz click',
                'replace': 'Arrastra y suelta un archivo o haz clic para reemplazar',
                'remove':  'Quitar Archivo',
                'error':   'Ooops, hubo un error inesperado.',
            },
            error: {
                'fileSize': 'El tamaño del archivo es demasiado grande.',
                'fileExtension': 'La extensión del archivo no es válida.',
            }
        });

        $('.dropify').on('change', function () {
            if ($('.dropify').val().split('.').pop().toLowerCase() == 'pdf') {
                $('#descargar').removeAttr('disabled');
            } else {
                $('#descargar').prop('checked', true);
                $('#descargar').attr('disabled', 'disabled');
            }
        });

        // Valida el formulario antes de enviarlo
        const validar = async function() {
            if (!version.valid || version.value == null || version.value == '') {
                version.valid = false;
                version.helperTextContent = 'Ingrese la versión del documentos.';
                M.toast({html: '<span class="mr-3">Error en la versión del documentos.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                return false;
            }
            let validacionVersion = versiones.find(element => element == version.value);
            console.log(validacionVersion);
            if (validacionVersion) {
                version.valid = false;
                version.helperTextContent = 'La versión ya existe.';
                M.toast({html: '<span class="mr-3">La versión ingresada ya existe.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                return false;
            }
            if ($('#archivo').val() == null || $('#archivo').val() == '') {
                $('.dropify-wrapper').addClass('has-error');
                $('.dropify-error').text('Debes adjuntar un archivo.');
                M.toast({html: '<span class="mr-3">Error en el archivo adjunto.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                return false;
            }

            return true;
        }

        // Ejecuta la función de validación antes de enviar el formulario
        $('.btn-guardar').on('click', async function(e) {
            $('#guardando').show();
            $('body').css('overflow', 'hidden');
            $(this).attr('disabled', 'disabled');
            e.preventDefault();
            let validacion = await validar();
            if (validacion) {
                $('#version-form').submit();
            } else {
                $('#guardando').hide();
                $('body').css('overflow', '');
                $(this).removeAttr('disabled');
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/documentos/resources/views/documentos/version.blade.php ENDPATH**/ ?>