<?php $__env->startSection('styles'); ?>
    <style>
        .col-firma .wrapper {
            position: relative;
            max-width: 400px;
            width: 100%;
            height: 200px;
            -moz-user-select: none;
            -webkit-user-select: none;
            -ms-user-select: none;
            user-select: none;
        }
        
        .col-firma img {
            position: absolute;
            left: 0;
            top: 0;
            width: 100%;
        }
        
        .col-firma .signature-pad {
            position: absolute;
            left: 0;
            top: 0;
            max-width: 400px;
            width: 100%;
            height: 200px;
            border: solid 1px rgba(0,0,0,.38);
            border-radius: 4px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-full">
        <div class="row">
            <div class="col s12 m8 mb-2-m">
                <h1 class="title uppercase font-gilroy"><?php echo e(mb_strtolower($documento->descripcion)); ?></h1>
                <div class="breadcrumbs full-width">
                    <a href="<?php echo e(route('dashboard')); ?>" class="breadcrumb">Dashboard</a>
                    <a class="breadcrumb"><?php echo e(mb_strtoupper($documento->codigo) .' V'. $documento->version->version); ?></a>
                </div>
            </div>
            <?php if(Auth::user()->rol_id < 4): ?>
                <div class="col m4 right-align mt-2-s">
                    <div style="display: inline-block;">
                        <div id="demo-menu" class="mdc-menu-surface--anchor">
                            <button id="menu-button" type="button" class="mdc-button mdc-button--raised mdc-button--large">
                                <span class="mdc-button__label mr-1">Opciones</span>
                                <i class="fas fa-cog"></i>
                            </button>
                            <div class="mdc-menu mdc-menu-surface" id="menu-options">
                                <ul class="mdc-list py-0" role="menu" aria-hidden="true" aria-orientation="vertical" tabindex="-1">
                                    <li class="mdc-list-item nowrap px-2" role="menuitem">
                                        <span class="mdc-list-item__ripple"></span>
                                        <a class="link-primary d-flex full-width full-height px-2 btn-download" data-id="<?php echo e($documento->id); ?>" href="<?php echo e(asset('private-storage/' . $documento->version->url)); ?>" download>
                                            <div class="valign-wrapper full-width">
                                                <span>Descargar</span>
                                                <div class="right-align full-width no-line-height">
                                                    <i class="ml-1 fas fa-download"></i>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
                                    <li class="mdc-list-item nowrap px-2" role="menuitem">
                                        <span class="mdc-list-item__ripple"></span>
                                        <a class="link-primary d-flex full-width full-height px-2" href="<?php echo e(route('documento.editar', ['codigo' => $documento->codigo])); ?>">
                                            <div class="valign-wrapper full-width">
                                                <span>Editar</span>
                                                <div class="right-align full-width no-line-height">
                                                    <i class="ml-1 fas fa-pen"></i>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
                                    <li class="mdc-list-item nowrap px-2" role="menuitem">
                                        <span class="mdc-list-item__ripple"></span>
                                        <a class="link-primary d-flex full-width full-height px-2" href="<?php echo e(route('documento.eliminar', ['codigo' => $documento->codigo])); ?>">
                                            <div class="valign-wrapper full-width">
                                                <span>Eliminar</span>
                                                <div class="right-align full-width no-line-height">
                                                    <i class="ml-1 fas fa-trash"></i>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            <?php elseif($documento->descargar): ?>
                <div class="col s12 m4 right-align hide-on-small-only">
                    <a class="mdc-button mdc-button--raised mdc-button--large btn-download" data-id="<?php echo e($documento->id); ?>" href="<?php echo e(asset('private-storage/' . $documento->version->url)); ?>" download>
                        <span class="mdc-button__label mr-1">Descargar</span>
                        <i class="fas fa-download"></i>
                    </a>
                </div>
                <div class="col s12 hide-on-med-and-up">
                    <a class="mdc-button mdc-button--raised mdc-button--large btn-download" data-id="<?php echo e($documento->id); ?>" href="<?php echo e(asset('private-storage/' . $documento->version->url)); ?>" download>
                        <span class="mdc-button__label mr-1">Descargar</span>
                        <i class="fas fa-download"></i>
                    </a>
                </div>
            <?php endif; ?>
        </div>
        <?php if($documento->version->tipo == 'pdf'): ?>
            <div class="row mb-0">
                <div class="col s12">
                    <embed src="<?php echo e(asset('private-storage/' . $documento->version->url)); ?>#toolbar=0" frameborder="0" width="100%" height="400px" class="card">
                </div>
            </div>
        <?php endif; ?>
        <?php if($documento->firmar && $validacionCargo && $validacionRegional): ?>
            <div class="row mb-0">
                <div class="col s12">
                    <div class="card highlighted">
                        <div class="card-content">
                            <?php if(!$firma): ?>
                                <form action="<?php echo e(route('documento.firmar', ['codigo' => $documento->codigo])); ?>" method="POST" id="form">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" class="hide" name="firma" id="firma">
                                    <div class="row mb-0">
                                        <div class="col s12 mb-1">
                                            <blockquote class="my-0" style="line-height: 25px; height: 25px;">
                                                <h2 class="title subtitle-1 font-gilroy uppercase mb-0"><b>FIRMAR DOCUMENTO</b></h2>
                                            </blockquote>
                                        </div>
                                        <div class="col s12 pl-0">
                                            <div class="mdc-touch-target-wrapper">
                                                <div class="mdc-checkbox mdc-checkbox--touch pl-0">
                                                    <input type="checkbox" class="mdc-checkbox__native-control" id="acepto"/>
                                                    <div class="mdc-checkbox__background">
                                                        <svg class="mdc-checkbox__checkmark" viewBox="0 0 24 24">
                                                            <path class="mdc-checkbox__checkmark-path" fill="none" d="M1.73,12.91 8.1,19.28 22.79,4.59"/>
                                                        </svg>
                                                        <div class="mdc-checkbox__mixedmark"></div>
                                                    </div>
                                                    <div class="mdc-checkbox__ripple"></div>
                                                </div>
                                                <label for="acepto" class="ml-1 noselect nowrap">Comprendo, acepto y me comprometo a su aplicación.</label>
                                            </div>
                                        </div>
                                        <div class="col s12 m8 xl6 mt-2 col-firma">
                                            <div class="wrapper">
                                                <img src="<?php echo e(asset('imagenes/backgrounds/firma.png')); ?>" width="100%" height=200 style="background-color:white;" />
                                                <canvas id="signature-pad" class="signature-pad" height=200></canvas>
                                            </div>
                                            <div>
                                                <button id="clear">Borrar Firma</button>
                                            </div>
                                        </div>
                                        <div class="col s12 mt-2">
                                            <button class="mdc-button mdc-button--raised mdc-button--large btn-firmar" id="" type="submit">
                                                <span class="mdc-button__label mr-1">Firmar</span>
                                                <i class="fas fa-signature"></i>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            <?php else: ?>
                                <div class="row mb-0">
                                    <div class="col s12 mb-2">
                                        <blockquote class="my-0" style="line-height: 25px; height: 25px;">
                                            <h2 class="title subtitle-1 font-gilroy uppercase mb-0"><b>DATOS DE LA FIRMA</b></h2>
                                        </blockquote>
                                    </div>
                                    <div class="col s12 m6 mb-2-s">
                                        <img src="<?php echo e(asset('private-storage/' . $firma->imagen)); ?>" alt="" style="background-image: url(<?php echo e(asset('imagenes/backgrounds/firma.png')); ?>)">
                                    </div>
                                    <div class="col s12 m6">
                                        <div class="row mb-0">
                                            <div class="col s12 mb-2">
                                                <label>Fecha</label>
                                                <span class="card-subtitle subtitle-3 highlighted capitalize"><?php echo $firma->created_at; ?></span>
                                            </div>
                                            <div class="col s12">
                                                <label>Ip</label>
                                                <span class="card-subtitle subtitle-3 highlighted capitalize"><?php echo $firma->ip; ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php if(Auth::user()->rol_id < 4): ?>
            <div class="row mb-0">
                <div class="col s12">
                    <div class="card highlighted">
                        <div class="card-content">
                            <div class="row mb-0">
                                <div class="col s12 mb-1">
                                    <blockquote class="my-0" style="line-height: 25px; min-height: 25px;">
                                        <h2 class="title subtitle-1 font-gilroy uppercase mb-0">
                                            <b>FIRMAS</b>
                                        </h2>
                                    </blockquote>
                                </div>
                                <div class="col s12 mt-2">
                                    <div class="mdc-data-table mdc-data-table--dense full-width">
                                        <div class="mdc-data-table__table-container">
                                            <table class="mdc-data-table__table" aria-label="Listado de bodegas">
                                                <thead>
                                                    <tr class="mdc-data-table__header-row">
                                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Versión</th>
                                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Fecha</th>
                                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Documento</th>
                                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Nombre</th>
                                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Cargo</th>
                                                    </tr>
                                                </thead>
                                                <tbody class="mdc-data-table__content">
                                                    <?php $__empty_1 = true; $__currentLoopData = $documento->firmas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $firma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <tr class="mdc-data-table__row">
                                                            <td class="mdc-data-table__cell"><?php echo e($firma->version->version); ?></td>
                                                            <td class="mdc-data-table__cell"><?php echo e(date('d/m/Y', strtotime($firma->created_at))); ?></td>
                                                            <td class="mdc-data-table__cell"><?php echo e($firma->usuario->documento); ?></td>
                                                            <td class="mdc-data-table__cell capitalize"><?php echo e(mb_strtolower($firma->usuario->nombre)); ?></td>
                                                            <td class="mdc-data-table__cell capitalize"><?php echo e(mb_strtolower($firma->usuario->cargo->descripcion)); ?></td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <tr class="mdc-data-table__row">
                                                            <th class="mdc-data-table__cell center" scope="row" colspan="4">Este documento no ha sido firmado por nadie.</th>
                                                        </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
    <div class="cargando noselect px-5 center" id="guardando" style="display: none">
        <div id="html-spinner"></div>
        <span class="title mt-1">Firmando Documento</span>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('vendor/signature_pad/signature_pad.min.js')); ?>"></script>
    <script>
        $('#dashboard').addClass('mdc-list-item--active');
        
        <?php if(Auth::user()->rol_id < 4): ?>
            const menu = new mdc.menu.MDCMenu(document.querySelector('.mdc-menu'));
            menu.setAnchorCorner(mdc.menu.Corner.BOTTOM_LEFT);
            document.querySelector('#menu-button').addEventListener('click', () => menu.open = !menu.open);
        <?php endif; ?>

        let urlDesargar = '<?php echo e(route('ajax.descargar')); ?>';
        
        $('.btn-download').click(function() {
            let id = $(this).data('id');
            $.ajax({
                method: 'POST',
                url: urlDesargar,
                context: document.body,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    id: id
                }
            }).done(function(response){
                console.log(response);
                M.toast({html: '<span class="mr-3">Descargando "' + response.documento.descripcion + '".</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'green darken-2 white-text'});
            }).fail(function(error){
                console.error(error);
            });
        });

        /**
            Acciones para Input de firma
            04/05/2021
        **/
        {
            var signaturePad = new SignaturePad(document.getElementById('signature-pad'), {
                backgroundColor: 'rgba(255, 255, 255, 0)',
                penColor: 'rgb(0, 0, 0)'
            });

            var cancelButton = document.getElementById('clear');
            cancelButton.addEventListener('click', function(e) {
                e.preventDefault();
                signaturePad.clear();
            });

            function resizeCanvas() {
                $('#signature-pad').attr('width', $('.col-firma .wrapper').width());
                signaturePad.clear(); // otherwise isEmpty() might return incorrect value
            }

            window.addEventListener("resize", resizeCanvas);
            resizeCanvas();
        }

        // Valida el formulario antes de enviarlo
        const validar = async function() {
            if (!$('#acepto').is(':checked')) {
                M.toast({html: '<span class="mr-3">Por favor indique que entendió el documento.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                $('#acepto').focus();
                return false;
            }
            if (signaturePad.isEmpty()) {
                M.toast({html: '<span class="mr-3">Por favor firme la solicitud.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                return false;
            } else {
                $('#firma').val(signaturePad.toDataURL());
            }
            
            return true;
        }

        // Ejecuta la función de validación antes de enviar el formulario
        $('.btn-firmar').on('click', async function(e) {
            $('#guardando').show();
            $('body').css('overflow', 'hidden');
            $(this).attr('disabled', 'disabled');
            e.preventDefault();
            let validacion = await validar();
            if (validacion) {
                $('#form').submit();
            } else {
                $('#guardando').hide();
                $('body').css('overflow', '');
                $(this).removeAttr('disabled');
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/documentos/resources/views/documento.blade.php ENDPATH**/ ?>