<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/private-storage/{ruta}', 'ArchivosController')->where(['ruta' => '.*']);

Route::get('/', function () {
    return redirect(route('dashboard'));
});

Auth::routes([
    'register' => false,
    'reset' => false,
    'verify' => false,
]);

Route::prefix('dashboard')->middleware(['auth', 'password.check'])->group(function () {
    Route::get('/', 'DashboardController@index')->name('dashboard');
    Route::get('/{proceso}', 'DashboardController@proceso')->name('dashboard.proceso');
});

Route::prefix('documentos')->middleware(['auth', 'password.check'])->group(function () {
    Route::get('/', 'DocumentosController@index')->name('documentos.index');
    Route::get('/cargar', 'DocumentosController@create')->name('documentos.create');
    Route::post('/cargar', 'DocumentosController@store');
    Route::get('/{codigo}', 'DocumentosController@show')->name('documentos.show');
    Route::get('/{codigo}/editar', 'DocumentosController@edit')->name('documentos.edit');
    Route::post('/{codigo}/editar', 'DocumentosController@update');
    Route::get('/{codigo}/editar/version', 'DocumentosController@version')->name('documentos.version');
    Route::post('/{codigo}/editar/version', 'DocumentosController@save');
    Route::get('/{codigo}/eliminar', 'DocumentosController@delete')->name('documentos.delete');
    Route::post('/{codigo}/eliminar', 'DocumentosController@destroy');

    // Rutas solo disponibles en post
    Route::post('/{codigo}/firmar', 'DocumentosController@sign')->name('documentos.sign');
});

Route::prefix('usuarios')->middleware(['auth', 'password.check'])->group(function () {
    Route::get('/', 'UsuariosController@index')->name('usuarios');
    Route::get('/nuevo', 'UsuariosController@create')->name('usuarios.crear');
    Route::post('/nuevo', 'UsuariosController@store');
    Route::get('/{documento}', 'UsuariosController@show')->name('usuarios.ver');
    Route::get('/{documento}/trazabilidad', 'UsuariosController@traceability')->name('usuarios.traceability');
    Route::get('/{documento}/editar', 'UsuariosController@edit')->name('usuarios.editar');
    Route::post('/{documento}/editar', 'UsuariosController@update');
    Route::get('/{documento}/eliminar', 'UsuariosController@delete')->name('usuarios.eliminar');
    Route::post('/{documento}/eliminar', 'UsuariosController@destroy');
    //Route::get('/claves', 'UsuariosController@claves')->name('claves');
});

Route::prefix('cargos')->middleware(['auth', 'password.check'])->group(function () {
    Route::get('/', 'CargosController@index')->name('cargos');
    Route::get('/nuevo', 'CargosController@create')->name('cargos.crear');
    Route::post('/nuevo', 'CargosController@store');
    Route::get('/{cargo}', 'CargosController@show')->name('cargos.ver');
    Route::get('/{cargo}/editar', 'CargosController@edit')->name('cargos.editar');
    Route::post('/{cargo}/editar', 'CargosController@update');
    Route::get('/{cargo}/eliminar', 'CargosController@delete')->name('cargos.eliminar');
    Route::post('/{cargo}/eliminar', 'CargosController@destroy');
});


Route::get('/mis-datos', 'UsuariosController@profile')->name('mis-datos');
Route::get('/mis-datos/contraseña', 'ContrasenaController@password')->name('mis-datos.contrasena');
Route::post('/mis-datos/contraseña', 'ContrasenaController@save');
Route::post('/reiniciar-contrasena', 'ContrasenaController@restart')->name('contrasena.reiniciar');

Route::post('/ajax/ip', 'DashboardController@ip')->name('ajax.ip');
Route::post('/ajax/descargar', 'DocumentosController@download')->name('ajax.descargar');
Route::post('/ajax/documentos/eliminar/{codigo}/{version}', 'DocumentosController@destroyVersion')->name('ajax.documentos.version.eliminar');
Route::get('/ajax/documentos/validar/{codigo}/{version}', 'DocumentosController@validation')->name('ajax.documentos.validar');
Route::get('/ajax/usuario/validar/{documento}', 'UsuariosController@validation')->name('ajax.usuario.validar');
