@extends('layouts.app')

@section('content')
    <input type="hidden" class="hide" id="documento" value="{{ $usuario->documento }}">
    <div class="container-full">
        <div class="row">
            <div class="col s12 m8">
                <h1 class="title uppercase font-gilroy">{{ $usuario->nombre }}</h1>
                <div class="breadcrumbs full-width">
                    <a href="{{ route('dashboard') }}" class="breadcrumb">Dashboard</a>
                    @if ($usuario->id == Auth::id())
                        <a class="breadcrumb">Mis Datos</a>
                    @else
                        <a href="{{ route('usuarios') }}" class="breadcrumb">Usuarios</a>
                        <a class="breadcrumb">{{ $usuario->documento }}</a>
                    @endif
                </div>
            </div>
            @if (Auth::user()->rol_id < 3)
                <div class="col m4 right-align mt-2-s">
                    <div style="display: inline-block;">
                        <div id="demo-menu" class="mdc-menu-surface--anchor">
                            <button id="menu-button" type="button" class="mdc-button mdc-button--raised mdc-button--large">
                                <span class="mdc-button__label mr-1">Opciones</span>
                                <i class="fas fa-cog"></i>
                            </button>
                            <div class="mdc-menu mdc-menu-surface" id="menu-options">
                                <ul class="mdc-list py-0" role="menu" aria-hidden="true" aria-orientation="vertical" tabindex="-1">
                                    @if (Auth::id() == $usuario->id)
                                        @if (Auth::user()->rol_id < 3)
                                            <li class="mdc-list-item nowrap px-2" role="menuitem">
                                                <span class="mdc-list-item__ripple"></span>
                                                <a class="link-primary d-flex full-width full-height px-2" href="{{ route('usuarios.traceability', ['documento' => $usuario->documento]) }}" class="mdc-list-item__text">
                                                    <div class="valign-wrapper full-width">
                                                        <span>Movimientos</span>
                                                        <div class="right-align full-width no-line-height">
                                                            <i class="ml-1 fas fa-calendar-day"></i>
                                                        </div>
                                                    </div>
                                                </a>
                                            </li>
                                        @endif
                                        <li class="mdc-list-item nowrap px-2" role="menuitem">
                                            <span class="mdc-list-item__ripple"></span>
                                            <a class="link-primary d-flex full-width full-height px-2" href="{{ route('mis-datos.contrasena') }}" class="mdc-list-item__text">
                                                <div class="valign-wrapper full-width">
                                                    <span>Contraseña</span>
                                                    <div class="right-align full-width no-line-height">
                                                        <i class="ml-1 fas fa-key"></i>
                                                    </div>
                                                </div>
                                            </a>
                                        </li>
                                    @elseif (Auth::user()->rol_id < 3 && Auth::user()->rol_id <= $usuario->rol_id)
                                        <li class="mdc-list-item nowrap px-2" role="menuitem">
                                            <span class="mdc-list-item__ripple"></span>
                                            <a class="link-primary d-flex full-width full-height px-2" href="{{ route('usuarios.traceability', ['documento' => $usuario->documento]) }}" class="mdc-list-item__text">
                                                <div class="valign-wrapper full-width">
                                                    <span>Movimientos</span>
                                                    <div class="right-align full-width no-line-height">
                                                        <i class="ml-1 fas fa-calendar-day"></i>
                                                    </div>
                                                </div>
                                            </a>
                                        </li>
                                        <li class="mdc-list-item nowrap px-2" role="menuitem">
                                            <span class="mdc-list-item__ripple"></span>
                                            <button class="link link-primary d-flex full-width full-height cursor-pointer px-2" class="mdc-list-item__text" id="reiniciar-clave">
                                                <div class="valign-wrapper full-width full-height">
                                                    <span>Reiniciar Clave</span>
                                                    <div class="right-align full-width no-line-height">
                                                        <i class="ml-1 fas fa-key"></i>
                                                    </div>
                                                </div>
                                            </button>
                                        </li>
                                    @endif
                                    <li class="mdc-list-item nowrap px-2" role="menuitem">
                                        <span class="mdc-list-item__ripple"></span>
                                        <a class="link-primary d-flex full-width full-height px-2" href="{{ route('usuarios.editar', ['documento' => $usuario->documento]) }}" class="mdc-list-item__text">
                                            <div class="valign-wrapper full-width">
                                                <span>Editar</span>
                                                <div class="right-align full-width no-line-height">
                                                    <i class="ml-1 fas fa-pen"></i>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
                                    <li class="mdc-list-item nowrap px-2" role="menuitem">
                                        <span class="mdc-list-item__ripple"></span>
                                        <a class="link-primary d-flex full-width full-height px-2" href="{{ route('usuarios.eliminar', ['documento' => $usuario->documento]) }}" class="mdc-list-item__text">
                                            <div class="valign-wrapper full-width">
                                                <span>Eliminar</span>
                                                <div class="right-align full-width no-line-height">
                                                    <i class="ml-1 fas fa-trash"></i>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            @else
                <div class="col s12 m4 right-align mt-2-s">
                    <a class="mdc-button mdc-button--raised mdc-button--large" href="{{ route('mis-datos.contrasena') }}">
                        <span class="mdc-button__label mr-1">Cambiar Contraseña</span>
                        <i class="fas fa-key"></i>
                    </a>
                </div>
            @endif
        </div>
        <div class="row mb-0">
            <div class="col s12">
                <div class="card highlighted">
                    <div class="card-content">
                        <div class="row mb-2">
                            <div class="col s12 mb-1">
                                <blockquote class="my-0" style="line-height: 25px; height: 25px;">
                                    <h2 class="title subtitle-1 font-gilroy uppercase mb-0"><b>DATOS DEL {{ mb_strtoupper($usuario->rol->descripcion) }}</b></h2>
                                </blockquote>
                            </div>
                        </div>
                        <div class="row mb-0">
                            <div class="col s12 m6 mb-2">
                                <label>Nombre Completo</label>
                                <span class="card-subtitle subtitle-3 highlighted capitalize">{{ mb_strtolower($usuario->nombre) }}</span>
                            </div>
                            <div class="col s12 m6 mb-2">
                                <label>Documento</label>
                                <span class="card-subtitle subtitle-3 highlighted capitalize">{{ $usuario->documento }}</span>
                            </div>
                            <div class="col s12 m6 mb-2">
                                <label>Correo Electrónico</label>
                                <span class="card-subtitle subtitle-3 highlighted">{!! $usuario->correo ?  mb_strtolower($usuario->correo) : '&nbsp;' !!}</span>
                            </div>
                            <div class="col s12 m6 mb-2">
                                <label>Teléfono</label>
                                <span class="card-subtitle subtitle-3 highlighted capitalize">{!! $usuario->telefono ? $usuario->telefono : '&nbsp;' !!}</span>
                            </div>
                            <div class="col s12 m6 mb-2">
                                <label>Departameto</label>
                                <span class="card-subtitle subtitle-3 highlighted capitalize">{!! $usuario->cargo ? mb_strtolower($usuario->cargo->area->departamento->descripcion) : '&nbsp;' !!}</span>
                            </div>
                            <div class="col s12 m6 mb-2">
                                <label>Área</label>
                                <span class="card-subtitle subtitle-3 highlighted capitalize">{!! $usuario->cargo ? mb_strtolower($usuario->cargo->area->descripcion) : '&nbsp;' !!}</span>
                            </div>
                            <div class="col s12 m6 mb-2-s">
                                <label>Cargo</label>
                                <span class="card-subtitle subtitle-3 highlighted capitalize">{!! $usuario->cargo ? mb_strtolower($usuario->cargo->descripcion) : '&nbsp;' !!}</span>
                            </div>
                            <div class="col s12 m6">
                                <label>Regional</label>
                                <span class="card-subtitle subtitle-3 highlighted capitalize">{{ $usuario->regional ? mb_strtolower($usuario->regional->nombre) : 'Común' }}</span>  
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mb-0">
            <div class="col s12">
                <div class="card highlighted">
                    <div class="card-content">
                        <div class="row mb-0">
                            <div class="col s12 mb-1">
                                <blockquote class="my-0" style="line-height: 25px; min-height: 25px;">
                                    <h2 class="title subtitle-1 font-gilroy uppercase mb-0">
                                        <b>DOCUMENTOS FIRMADOS</b>
                                    </h2>
                                </blockquote>
                            </div>
                            <div class="col s12 mt-2">
                                <div class="mdc-data-table mdc-data-table--dense full-width">
                                    <div class="mdc-data-table__table-container">
                                        <table class="mdc-data-table__table" aria-label="Listado de bodegas">
                                            <thead>
                                                <tr class="mdc-data-table__header-row">
                                                    <th class="mdc-data-table__header-cell pr-0 hide-on-small-only" role="columnheader" scope="col"></th>
                                                    <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Código</th>
                                                    <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Nombre</th>
                                                    <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Fecha</th>
                                                </tr>
                                            </thead>
                                            <tbody class="mdc-data-table__content">
                                                @forelse ($usuario->firmas as $index => $firma)
                                                    <tr class="mdc-data-table__row">
                                                        <td class="mdc-data-table__cell pr-0 hide-on-small-only">
                                                            <i class="fz-18 far fa-file-{{ $firma->version->tipo }} icon-{{ $firma->version->tipo }}"></i>
                                                        </td>
                                                        <td class="mdc-data-table__cell noselect">
                                                            <a class="link link-{{ $firma->version->tipo }}" href="{{ route('documentos.show', ['codigo' => $firma->version->documento->codigo]) }}">{{ mb_strtoupper($firma->version->documento->codigo) .' V'. $firma->version->version }}</a>
                                                        </td>
                                                        <td class="mdc-data-table__cell">{{ mb_strtoupper($firma->version->documento->descripcion) }}</td>
                                                        <td class="mdc-data-table__cell">{{ date('d/m/Y', strtotime($firma->created_at)) }}</td>
                                                    </tr>
                                                @empty
                                                    <tr class="mdc-data-table__row">
                                                        <th class="mdc-data-table__cell center" scope="row" colspan="4">No hay documentos firmados.</th>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mb-0 mt-2">
            <div class="col s12">
                <a class="mdc-button mdc-button--outlined mdc-button--large" href="{{ $usuario->id == Auth::id() ? route('dashboard') : route('usuarios') }}">
                    <span class="mdc-button__label mr-1">Volver</span>
                    <i class="fas fa-reply"></i>
                </a>
            </div>
        </div>
    </div>
    <div class="cargando noselect px-5 center" id="reiniciando" style="display: none">
        <div id="html-spinner"></div>
        <span class="title mt-1">Reiniciando Contraseña</span>
    </div>
@endsection

@section('scripts')
    <script>
        $('#{{ $usuario->id == Auth::id() ? 'mis-datos' : 'usuarios' }}').addClass('mdc-list-item--active');

        let urlDesargar = '{{ route('ajax.descargar') }}';
        let urlReiniciarContrasena = '{{ route('contrasena.reiniciar') }}';
        
        @if (Auth::user()->rol_id < 3)
            const menu = new mdc.menu.MDCMenu(document.querySelector('.mdc-menu'));
            menu.setAnchorCorner(mdc.menu.Corner.BOTTOM_LEFT);
            document.querySelector('#menu-button').addEventListener('click', () => menu.open = !menu.open);
        @endif

        $('.link-download').click(function() {
            let id = $(this).data('id');
            $.ajax({
                method: 'POST',
                url: urlDesargar,
                context: document.body,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    id: id
                }
            }).done(function(response){
                console.log(response);
                M.toast({html: '<span class="mr-3">Descargando "' + response.documento.descripcion + '".</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'green darken-2 white-text'});
            }).fail(function(error){
                console.error(error);
            });
        });

        $('#reiniciar-clave').on('click', function(e) {
            Swal.fire({
                title: '¿Reiniciar Clave?',
                text: 'Esta acción reiniciará la contraseña del usuario {{ $usuario->nombre }}.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#ff0000',
                confirmButtonText: 'Si, reiniciar!',
                cancelButtonText: 'Cancelar',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    $('#reiniciando').show();
                    $('body').css('overflow', 'hidden');
                    $(this).attr('disabled', 'disabled');
                    console.log($('#documento').val());
                    $.ajax({
                        method: 'POST',
                        url: urlReiniciarContrasena,
                        context: document.body,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {
                            'documento': $('#documento').val()
                        }
                    }).done(function(response) {
                        window.location.reload();
                    }).fail(function(error) {
                        console.error(error);
                        $('#reiniciando').hide();
                        $('body').css('overflow', '');
                        $(this).removeAttr('disabled');
                        Swal.fire({
                            title: 'Ooops!',
                            text: 'Hubo un error inesperado. Intente más tarde nuevamente.',
                            icon: 'error'
                        });
                    });
                }
            });
        });
    </script>
@endsection