@extends('layouts.app')

@section('content')
    <form action="{{ route('usuarios') }}" type="GET" id="mainForm">
        <input type="hidden" class="hide" name="perPage" id="perPage" value="{{ Session::get('pagination') }}">
        <div class="container-full">
            <div class="row">
                <div class="col s12 m8">
                    <h1 class="title uppercase font-gilroy">Listado de Usuarios</h1>
                    <div class="breadcrumbs full-width">
                        <a href="{{ route('dashboard') }}" class="breadcrumb">Dashboard</a>
                        <a class="breadcrumb">Usuarios</a>
                    </div>
                </div>
                <div class="col s12 m4 right-align mt-2-s">
                    <a class="mdc-button mdc-button--raised mdc-button--large" href="{{ route('usuarios.crear') }}">
                        <span class="mdc-button__label mr-1">Nuevo Usuario</span>
                        <i class="fas fa-user-plus"></i>
                    </a>
                </div>
            </div>
            <div class="row">
                <div class="col s12">
                    <div class="card highlighted">
                        <div class="card-content">
                            <span class="card-title mb-2">Filtros</span>
                            <div class="row mb-0">
                                <div class="col s6 m3 mb-2-s">
                                    <div class="mdc-select mdc-select--outlined mdc-select--superdense full-width {{ $orden ? 'mdc-select--filled' : '' }}" id="mdc-select-orden">
                                        <div class="mdc-select__anchor" aria-labelledby="orden-select-label">
                                            <input type="hidden" name="orden" id="orden" class="mdc-select__input-value" value="{{ $orden ? $orden .'|'. $sort : '' }}">
                                            <span id="orden__selected-text" class="mdc-select__selected-text capitalize"></span>
                                            <span class="mdc-select__dropdown-icon">
                                                <svg class="mdc-select__dropdown-icon-graphic" viewBox="7 10 10 5">
                                                    <polygon class="mdc-select__dropdown-icon-inactive" stroke="none" fill-rule="evenodd" points="7 10 12 15 17 10"></polygon>
                                                    <polygon class="mdc-select__dropdown-icon-active" stroke="none" fill-rule="evenodd" points="7 15 12 10 17 15"></polygon>
                                                </svg>
                                            </span>
                                            <span class="mdc-notched-outline">
                                                <span class="mdc-notched-outline__leading"></span>
                                                <span class="mdc-notched-outline__notch">
                                                    <span id="orden-select-label" class="mdc-floating-label {{ $orden ? 'mdc-floating-label--float-above' : '' }}">Ordenar Por</span>
                                                </span>
                                                <span class="mdc-notched-outline__trailing"></span>
                                            </span>
                                        </div>
                                        <!-- Other elements from the select remain. -->
                                        <div class="mdc-select__menu mdc-menu mdc-menu-surface mdc-menu--dense" role="listbox">
                                            <ul class="mdc-list">
                                                <li class="mdc-list-item capitalize {{ $orden .'|'. $sort == 'users.documento|asc' ? 'mdc-list-item--selected' : '' }}" {{ $orden .'|'. $sort == 'users.documento|asc' ? 'aria-selected="true"' : '' }} data-value="users.documento|asc" role="option">
                                                    <span class="mdc-list-item__ripple"></span>
                                                    <span class="mdc-list-item__text capitallize">Documento</span>
                                                </li>
                                                <li class="mdc-list-item capitalize {{ $orden .'|'. $sort == 'users.nombre|asc' ? 'mdc-list-item--selected' : '' }}" {{ $orden .'|'. $sort == 'users.nombre|asc' ? 'aria-selected="true"' : '' }} data-value="users.nombre|asc" role="option">
                                                    <span class="mdc-list-item__ripple"></span>
                                                    <span class="mdc-list-item__text capitallize">Nombre</span>
                                                </li>
                                                <li class="mdc-list-item capitalize {{ $orden .'|'. $sort == 'car.descripcion|asc' ? 'mdc-list-item--selected' : '' }}" {{ $orden .'|'. $sort == 'car.descripcion|asc' ? 'aria-selected="true"' : '' }} data-value="car.descripcion|asc" role="option">
                                                    <span class="mdc-list-item__ripple"></span>
                                                    <span class="mdc-list-item__text capitallize">Cargo</span>
                                                </li>
                                                <li class="mdc-list-item capitalize {{ $orden .'|'. $sort == 'users.created_at|asc' ? 'mdc-list-item--selected' : '' }}" {{ $orden .'|'. $sort == 'users.created_at|asc' ? 'aria-selected="true"' : '' }} data-value="users.created_at|asc" role="option">
                                                    <span class="mdc-list-item__ripple"></span>
                                                    <span class="mdc-list-item__text capitallize">Más Antiguos Primero</span>
                                                </li>
                                                <li class="mdc-list-item capitalize {{ $orden .'|'. $sort == 'users.created_at|desc' ? 'mdc-list-item--selected' : '' }}" {{ $orden .'|'. $sort == 'users.created_at|desc' ? 'aria-selected="true"' : '' }} data-value="users.created_at|desc" role="option">
                                                    <span class="mdc-list-item__ripple"></span>
                                                    <span class="mdc-list-item__text capitallize">Más Recientes Primero</span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col s6 m3 mb-2-s">
                                    <div class="mdc-select mdc-select--outlined mdc-select--superdense full-width {{ $departamento ? 'mdc-select--filled' : '' }}" id="mdc-select-departamento">
                                        <div class="mdc-select__anchor" aria-labelledby="departamento-select-label">
                                            <input type="hidden" name="departamento" id="departamento" class="mdc-select__input-value" value="{{ $departamento ? $departamento : '' }}">
                                            <span id="departamento__selected-text" class="mdc-select__selected-text capitalize">{{ $departamento ? $departamento : '' }}</span>
                                            <span class="mdc-select__dropdown-icon">
                                                <svg class="mdc-select__dropdown-icon-graphic" viewBox="7 10 10 5">
                                                    <polygon class="mdc-select__dropdown-icon-inactive" stroke="none" fill-rule="evenodd" points="7 10 12 15 17 10"></polygon>
                                                    <polygon class="mdc-select__dropdown-icon-active" stroke="none" fill-rule="evenodd" points="7 15 12 10 17 15"></polygon>
                                                </svg>
                                            </span>
                                            <span class="mdc-notched-outline">
                                                <span class="mdc-notched-outline__leading"></span>
                                                <span class="mdc-notched-outline__notch">
                                                    <span id="departamento-select-label" class="mdc-floating-label {{ $departamento ? 'mdc-floating-label--float-above' : '' }}">Departamento</span>
                                                </span>
                                                <span class="mdc-notched-outline__trailing"></span>
                                            </span>
                                        </div>
                                        <!-- Other elements from the select remain. -->
                                        <div class="mdc-select__menu mdc-menu mdc-menu-surface mdc-menu--dense" role="listbox">
                                            <ul class="mdc-list">
                                                <li class="mdc-list-item {{ $departamento ? '' : 'mdc-list-item--selected' }}" {{ $departamento ? '' : 'aria-selected="true"' }} data-value="" role="option">
                                                    <span class="mdc-list-item__ripple"></span>
                                                    <span class="mdc-list-item__text"></span>
                                                </li>
                                                @foreach ($departamentos as $dep)
                                                    <li class="mdc-list-item capitalize {{ $departamento == $dep->id ? 'mdc-list-item--selected' : '' }}" {{ $departamento == $dep->id ? 'aria-selected="true"' : '' }} data-value="{{ $dep->id }}" role="option">
                                                        <span class="mdc-list-item__ripple"></span>
                                                        <span class="mdc-list-item__text capitallize">{{ mb_strtolower($dep->descripcion) }}</span>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col s6 m3 mb-2-s">
                                    <label class="mdc-text-field mdc-text-field--outlined mdc-text-field--superdense" id="mdc-nombre">
                                        <input type="text" class="mdc-text-field__input" aria-labelledby="lbl_nombre" name="nombre" id="nombre" value="{{ $nombre }}">
                                        <span class="mdc-notched-outline">
                                            <span class="mdc-notched-outline__leading"></span>
                                            <span class="mdc-notched-outline__notch">
                                                <span class="mdc-floating-label" id="lbl_nombre">Código o Descripción</span>
                                            </span>
                                            <span class="mdc-notched-outline__trailing"></span>
                                        </span>
                                    </label>
                                </div>
                                <div class="col s6 m3">
                                    <a class="mdc-button mdc-button--raised mdc-button--dense full-width" href="{{ route('usuarios') }}">
                                        <span class="mdc-button__label">Reiniciar Filtros</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col s12">
                    <div class="mdc-data-table mdc-data-table--dense card full-width">
                        <div class="mdc-data-table__table-container">
                            <table class="mdc-data-table__table" aria-label="Listado de bodegas">
                                <thead>
                                    <tr class="mdc-data-table__header-row">
                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Documento</th>
                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Nombre</th>
                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Cargo</th>
                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Regional</th>
                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Creación</th>
                                        @if(Auth::user()->rol_id < 3)
                                            <th class="mdc-data-table__header-cell mdc-data-table__header-cell--numeric" role="columnheader" scope="col">Acciones</th>
                                        @endif
                                    </tr>
                                </thead>
                                <tbody class="mdc-data-table__content">
                                    @forelse ($usuarios as $index => $usuario)
                                        <tr class="mdc-data-table__row">
                                            <td class="mdc-data-table__cell">
                                                <a class="link link-primary underline" href="{{ route('usuarios.ver', ['documento' => $usuario->documento]) }}">{{ $usuario->documento }}</a>
                                            </td>
                                            <td class="mdc-data-table__cell capitalize">{{ mb_strtolower($usuario->nombre) }}</td>
                                            <td class="mdc-data-table__cell noselect">{{ $usuario->cargo ? ucfirst(mb_strtolower($usuario->cargo->descripcion)) : '' }}</td>
                                            <td class="mdc-data-table__cell noselect">{{ $usuario->regional ? ucfirst(mb_strtolower($usuario->regional->nombre)) : 'Común' }}</td>
                                            <td class="mdc-data-table__cell noselect">{{ date('d/m/Y', strtotime($usuario->created_at)) }}</td>
                                            @if(Auth::user()->rol_id < 3)
                                                <td class="mdc-data-table__cell noselect mdc-data-table__header-cell--numeric">
                                                    <a class="link link-primary" href="{{ route('usuarios.editar', ['documento' => $usuario->documento]) }}">
                                                        Editar<i class="fas fa-pen" style="margin-left: 5px;"></i>
                                                    </a>
                                                    <a class="link link-primary ml-2" href="{{ route('usuarios.eliminar', ['documento' => $usuario->documento]) }}">
                                                        Eliminar<i class="fas fa-trash" style="margin-left: 5px;"></i>
                                                    </a>
                                                </td>
                                            @endif
                                        </tr>
                                    @empty
                                        <tr class="mdc-data-table__row">
                                            <th class="mdc-data-table__cell center" scope="row" colspan="6">No hay usuarios.</th>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        @if($usuarios->count() > 0)
                            <div class="mdc-data-table__pagination">
                                <div class="mdc-data-table__pagination-trailing full-width row no-margin">
                                    <div class="mdc-data-table__pagination-rows-per-page col s12 m6 mr-0">
                                        <div class="mdc-data-table__pagination-rows-per-page-label">Filas por página</div>
                                        <div>
                                            <div class="mdc-select mdc-select--outlined mdc-select--no-label mdc-data-table__pagination-rows-per-page-select" id="select-datatable">
                                                <div class="mdc-select__anchor" role="button" aria-haspopup="listbox" aria-labelledby="demo-pagination-select" tabindex="0">
                                                    <span class="mdc-notched-outline mdc-notched-outline--notched">
                                                        <span class="mdc-notched-outline__leading"></span>
                                                        <span class="mdc-notched-outline__trailing"></span>
                                                    </span>
                                                    <span class="mdc-select__selected-text-container">
                                                        <span id="demo-pagination-select" class="mdc-select__selected-text">{{ Session::get('pagination') }}</span>
                                                    </span>
                                                    <span class="mdc-select__dropdown-icon">
                                                        <svg class="mdc-select__dropdown-icon-graphic" viewBox="7 10 10 5">
                                                            <polygon class="mdc-select__dropdown-icon-inactive" stroke="none" fill-rule="evenodd" points="7 10 12 15 17 10"></polygon>
                                                            <polygon class="mdc-select__dropdown-icon-active" stroke="none" fill-rule="evenodd" points="7 15 12 10 17 15"></polygon>
                                                        </svg>
                                                    </span>
                                                </div>
                                                <div class="mdc-select__menu mdc-menu mdc-menu-surface mdc-menu-surface--fullwidth" role="listbox">
                                                    <ul class="mdc-list">
                                                        <li class="mdc-list-item {{ Session::get('pagination') == 10 ? 'mdc-list-item--selected' : '' }}" aria-selected="true" role="option" data-value="10">
                                                            <span class="mdc-list-item__text">10</span>
                                                        </li>
                                                        <li class="mdc-list-item {{ Session::get('pagination') == 25 ? 'mdc-list-item--selected' : '' }}" role="option" data-value="25">
                                                            <span class="mdc-list-item__text">25</span>
                                                        </li>
                                                        <li class="mdc-list-item {{ Session::get('pagination') == 50 ? 'mdc-list-item--selected' : '' }}" role="option" data-value="50">
                                                            <span class="mdc-list-item__text">50</span>
                                                        </li>
                                                        <li class="mdc-list-item {{ Session::get('pagination') == 100 ? 'mdc-list-item--selected' : '' }}" role="option" data-value="100">
                                                            <span class="mdc-list-item__text">100</span>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mdc-data-table__pagination-total">{{ $usuarios->firstItem() }} ‑ {{ $usuarios->lastItem() . ' de ' . $usuarios->total() }}</div>
                                    </div>
                                    <div class="mdc-data-table__pagination-navigation col s12 m6 mb-1-s">
                                        @if($usuarios->hasPages())
                                            <a class="mdc-icon-button mdc-data-table__pagination-button  {{ $usuarios->onFirstPage() ? 'disabled' : '' }}" href="{{ $usuarios->withQueryString()->url(1) }}" data-first-page="true">
                                                <div class="mdc-button__icon"><i class="fas fa-step-backward"></i></div>
                                            </a>
                                            <a class="mdc-icon-button mdc-data-table__pagination-button {{ $usuarios->onFirstPage() ? 'disabled' : '' }}" href="{{ $usuarios->withQueryString()->previousPageUrl() }}" data-prev-page="true">
                                                <div class="mdc-button__icon"><i class="fas fa-chevron-left"></i></div>
                                            </a>
                                            @for ($i = $usuarios->currentPage() - 2; $i <= $usuarios->currentPage() + 2; $i++)
                                                @if ($i > 0 && $i <= $usuarios->lastPage())
                                                    <a class="mdc-icon-button mdc-data-table__pagination-button {{ $i == $usuarios->currentPage() ? 'disabled current' : '' }}" href="{{ $usuarios->withQueryString()->url($i) }}">
                                                        <div class="mdc-button__icon">{{ $i }}</div>
                                                    </a>
                                                @endif
                                            @endfor
                                            <a class="mdc-icon-button mdc-data-table__pagination-button {{ $usuarios->hasMorePages() ? '' : 'disabled' }}" href="{{ $usuarios->withQueryString()->nextPageUrl() }}" data-next-page="true">
                                                <div class="mdc-button__icon"><i class="fas fa-chevron-right"></i></div>
                                            </a>
                                            <a class="mdc-icon-button mdc-data-table__pagination-button {{ $usuarios->hasMorePages() ? '' : 'disabled' }}" href="{{ $usuarios->withQueryString()->url($usuarios->lastPage()) }}" data-last-page="true">
                                                <div class="mdc-button__icon"><i class="fas fa-step-forward"></i></div>
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection

@section('scripts')
    <script>
        $('#usuarios').addClass('mdc-list-item--active');

        const dataTable = new mdc.dataTable.MDCDataTable(document.querySelector('.mdc-data-table'));
        const selectOrden = new mdc.select.MDCSelect(document.querySelector('#mdc-select-orden'));
        const selectDepartamento = new mdc.select.MDCSelect(document.querySelector('#mdc-select-departamento'));
        const nombre = new mdc.textField.MDCTextField(document.querySelector('#mdc-nombre'));
        @if($usuarios->count() > 0)
            const selectDatable = new mdc.select.MDCSelect(document.querySelector('#select-datatable'));
        @endif

        /* Filtros */
        $('#nombre').on('change', function() {
            $('#mainForm').submit();
        });

        selectOrden.listen('MDCSelect:change', (el) => {
            $('#orden').val(selectOrden.value);
            $('#mainForm').submit();
        });

        selectDepartamento.listen('MDCSelect:change', (el) => {
            $('#departamento').val(selectDepartamento.value);
            $('#mainForm').submit();
        });

        @if($usuarios->count() > 0)
            selectDatable.listen('MDCSelect:change', (el) => {
                $('#perPage').val(selectDatable.value);
                $('#mainForm').submit();
            });
        @endif
    </script>
@endsection