@extends('layouts.app')

@section('content')
    <form action="{{ isset($usuario) ? route('usuarios.editar', ['documento' => $usuario->documento]) : route('usuarios.crear') }}" method="post" id="cargar-form" accept-charset="UTF-8" enctype="multipart/form-data" files="true">
        @csrf
        <div class="container-full">
            <div class="row">
                <div class="col s12 m8">
                    <h1 class="title uppercase font-gilroy">{{ isset($usuario) ? $usuario->nombre : 'NUEVO USUARIO' }}</h1>
                    <div class="breadcrumbs full-width">
                        <a href="{{ route('dashboard') }}" class="breadcrumb">Dashboard</a>
                        <a href="{{ route('usuarios') }}" class="breadcrumb">Usuarios</a>
                        @isset($usuario)
                            <a href="{{ route('usuarios.ver', ['documento' => $usuario->documento]) }}" class="breadcrumb">{{ $usuario->documento }}</a>
                        @endisset
                        <a class="breadcrumb">{{ isset($usuario) ? 'Editar' : 'Nuevo' }}</a>
                    </div>
                </div>
                <div class="col m4 right-align mt-2-s hide-on-small-only">
                    <button class="mdc-button mdc-button--raised mdc-button--large btn-guardar" id="" type="submit">
                        <span class="mdc-button__label mr-1">Guardar</span>
                        <i class="fas fa-save"></i>
                    </button>
                </div>
            </div>
            <div class="row mb-0">
                <div class="col s12">
                    <div class="card highlighted">
                        <div class="card-content">
                            <div class="row mb-2">
                                <div class="col s12 mb-1">
                                    <blockquote class="my-0" style="line-height: 25px; height: 25px;">
                                        <h2 class="title subtitle-1 font-gilroy uppercase mb-0"><b>DATOS DEL USUARIO</b></h2>
                                    </blockquote>
                                </div>
                            </div>
                            <div class="row mb-0">
                                <div class="col s12 m6 mb-2">
                                    <label class="mdc-text-field mdc-text-field--outlined mdc-text-field--dense focusable" id="mdc-documento">
                                        <span class="mdc-notched-outline">
                                            <span class="mdc-notched-outline__leading"></span>
                                            <span class="mdc-notched-outline__notch">
                                                <span class="mdc-floating-label" id="lbl_documento">Número de Documento</span>
                                            </span>
                                            <span class="mdc-notched-outline__trailing"></span>
                                        </span>
                                        <input type="text" class="mdc-text-field__input" aria-labelledby="lbl_documento" id="documento" name="documento" value="{{ isset($usuario) ? $usuario->documento : '' }}" maxlength="10" minlength="6" required>
                                    </label>
                                    <div class="mdc-text-field-helper-line">
                                        <div class="mdc-text-field-helper-text mdc-text-field-helper-text--validation-msg nowrap" id="mdc-helper-documento" aria-hidden="true"></div>
                                        <div class="mdc-text-field-character-counter">0 / 10</div>
                                    </div>
                                </div>
                                <div class="col s12 m6 mb-2">
                                    <label class="mdc-text-field mdc-text-field--outlined mdc-text-field--dense focusable" id="mdc-nombre">
                                        <span class="mdc-notched-outline">
                                            <span class="mdc-notched-outline__leading"></span>
                                            <span class="mdc-notched-outline__notch">
                                                <span class="mdc-floating-label" id="lbl_nombre">Nombre completo</span>
                                            </span>
                                            <span class="mdc-notched-outline__trailing"></span>
                                        </span>
                                        <input type="text" class="mdc-text-field__input" aria-labelledby="lbl_nombre" id="nombre" name="nombre" value="{{ isset($usuario) ? $usuario->nombre : '' }}" maxlength="60" minlength="6" required>
                                    </label>
                                    <div class="mdc-text-field-helper-line">
                                        <div class="mdc-text-field-helper-text mdc-text-field-helper-text--validation-msg nowrap" id="mdc-helper-nombre" aria-hidden="true"></div>
                                        <div class="mdc-text-field-character-counter">0 / 60</div>
                                    </div>
                                </div>
                                <div class="col s12 m6 mb-2">
                                    <label class="mdc-text-field mdc-text-field--outlined mdc-text-field--dense focusable" id="mdc-telefono">
                                        <span class="mdc-notched-outline">
                                            <span class="mdc-notched-outline__leading"></span>
                                            <span class="mdc-notched-outline__notch">
                                                <span class="mdc-floating-label" id="lbl_telefono">Número de Teléfono</span>
                                            </span>
                                            <span class="mdc-notched-outline__trailing"></span>
                                        </span>
                                        <input type="number" class="mdc-text-field__input" aria-labelledby="lbl_telefono" id="telefono" name="telefono" value="{{ isset($usuario) ? $usuario->telefono : '' }}" maxlength="10" minlength="7" required>
                                    </label>
                                    <div class="mdc-text-field-helper-line">
                                        <div class="mdc-text-field-helper-text mdc-text-field-helper-text--validation-msg nowrap" id="mdc-helper-telefono" aria-hidden="true"></div>
                                        <div class="mdc-text-field-character-counter">0 / 10</div>
                                    </div>
                                </div>
                                <div class="col s12 m6 mb-2">
                                    <label class="mdc-text-field mdc-text-field--outlined mdc-text-field--dense focusable" id="mdc-correo">
                                        <span class="mdc-notched-outline">
                                            <span class="mdc-notched-outline__leading"></span>
                                            <span class="mdc-notched-outline__notch">
                                                <span class="mdc-floating-label" id="lbl_correo">Correo Electrónico</span>
                                            </span>
                                            <span class="mdc-notched-outline__trailing"></span>
                                        </span>
                                        <input type="email" class="mdc-text-field__input" aria-labelledby="lbl_correo" id="correo" name="correo" value="{{ isset($usuario) ? $usuario->correo : '' }}" maxlength="60" required>
                                    </label>
                                    <div class="mdc-text-field-helper-line">
                                        <div class="mdc-text-field-helper-text mdc-text-field-helper-text--validation-msg nowrap" id="mdc-helper-correo" aria-hidden="true"></div>
                                        <div class="mdc-text-field-character-counter">0 / 60</div>
                                    </div>
                                </div>
                                <div class="col s12 m6 mb-2">
                                    <div class="mdc-select mdc-select--outlined mdc-select--dense mdc-select--required" id="mdc-regional_id">
                                        <div class="mdc-select__anchor" aria-required="true" aria-labelledby="outlined-select-label">
                                            <input type="text" name="regional_id" id="regional_id" class="mdc-select__input-value" value="{{ isset($usuario) ? $usuario->regional_id : '' }}">
                                            <span id="regional_id__selected-text" class="mdc-select__selected-text"></span>
                                            <span class="mdc-select__dropdown-icon">
                                                <svg class="mdc-select__dropdown-icon-graphic" viewBox="7 10 10 5">
                                                    <polygon class="mdc-select__dropdown-icon-inactive" stroke="none" fill-rule="evenodd" points="7 10 12 15 17 10"></polygon>
                                                    <polygon class="mdc-select__dropdown-icon-active" stroke="none" fill-rule="evenodd" points="7 15 12 10 17 15"></polygon>
                                                </svg>
                                            </span>
                                            <span class="mdc-notched-outline">
                                                <span class="mdc-notched-outline__leading"></span>
                                                <span class="mdc-notched-outline__notch">
                                                    <span id="outlined-select-label" class="mdc-floating-label">Regional</span>
                                                </span>
                                                <span class="mdc-notched-outline__trailing"></span>
                                            </span>
                                        </div>
                                        <!-- Other elements from the select remain. -->
                                        <div class="mdc-select__menu mdc-menu mdc-menu-surface" role="listbox">
                                            <ul class="mdc-list">
                                                <li class="mdc-list-item {{ isset($usuario) ? (!$usuario->regional_id ? 'mdc-list-item--selected' : '') : '' }}" data-value="null" role="option" {{ isset($usuario) ? (!$usuario->regional_id ? 'aria-selected="true"' : '') : '' }}>
                                                    <span class="mdc-list-item__text">Regional Común</span>
                                                </li>
                                                @foreach ($regionales as $regional)
                                                    <li class="mdc-list-item {{ isset($usuario) && $regional->id == $usuario->regional_id ? 'mdc-list-item--selected' : '' }}" data-value="{{ $regional->id }}" role="option" {{ isset($usuario) && $regional->id == $usuario->regional_id ? 'aria-selected="true"' : '' }}>
                                                        <span class="mdc-list-item__text">Regional {{ ucfirst(strtolower($regional->nombre)) }}</span>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="mdc-select-helper-text mdc-select-helper-text--validation-msg nowrap" id="mdc-helper-regional_id" style="height: 15px;"></div>
                                </div>
                                @if (isset($usuario) && $usuario->rol_id <= Auth::user()->rol_id)
                                    <div class="col s12 m6 mb-2">
                                        <label class="mdc-text-field mdc-text-field--outlined mdc-text-field--dense focusable" id="mdc-rol">
                                            <span class="mdc-notched-outline">
                                                <span class="mdc-notched-outline__leading"></span>
                                                <span class="mdc-notched-outline__notch">
                                                    <span class="mdc-floating-label" id="lbl_rol">Rol del Usuario</span>
                                                </span>
                                                <span class="mdc-notched-outline__trailing"></span>
                                            </span>
                                            <input type="text" class="mdc-text-field__input" aria-labelledby="lbl_rol" id="rol" value="{{ $usuario->rol->descripcion }}" maxlength="60" readonly>
                                        </label>
                                        <div class="mdc-text-field-helper-line">
                                            <div class="mdc-text-field-helper-text mdc-text-field-helper-text--validation-msg nowrap" id="mdc-helper-rol" aria-hidden="true"></div>
                                        </div>
                                    </div>
                                @else
                                    <div class="col s12 m6 mb-2">
                                        <div class="mdc-select mdc-select--outlined mdc-select--dense mdc-select--required" id="mdc-rol_id">
                                            <div class="mdc-select__anchor" aria-required="true" aria-labelledby="outlined-select-label">
                                                <input type="text" name="rol_id" id="rol_id" class="mdc-select__input-value" value="{{ isset($usuario) ? $usuario->rol_id : '' }}">
                                                <span id="rol_id__selected-text" class="mdc-select__selected-text"></span>
                                                <span class="mdc-select__dropdown-icon">
                                                    <svg class="mdc-select__dropdown-icon-graphic" viewBox="7 10 10 5">
                                                        <polygon class="mdc-select__dropdown-icon-inactive" stroke="none" fill-rule="evenodd" points="7 10 12 15 17 10"></polygon>
                                                        <polygon class="mdc-select__dropdown-icon-active" stroke="none" fill-rule="evenodd" points="7 15 12 10 17 15"></polygon>
                                                    </svg>
                                                </span>
                                                <span class="mdc-notched-outline">
                                                    <span class="mdc-notched-outline__leading"></span>
                                                    <span class="mdc-notched-outline__notch">
                                                        <span id="outlined-select-label" class="mdc-floating-label">Rol del Usuario</span>
                                                    </span>
                                                    <span class="mdc-notched-outline__trailing"></span>
                                                </span>
                                            </div>
                                            <!-- Other elements from the select remain. -->
                                            <div class="mdc-select__menu mdc-menu mdc-menu-surface" role="listbox">
                                                <ul class="mdc-list">
                                                    @foreach ($roles as $rol)
                                                        @if ($rol->id > Auth::user()->rol_id)
                                                            <li class="mdc-list-item {{ isset($usuario) && $rol->id == $usuario->rol_id ? 'mdc-list-item--selected' : '' }}" data-value="{{ $rol->id }}" role="option" {{ isset($usuario) && $rol->id == $usuario->rol_id ? 'aria-selected="true"' : '' }}>
                                                                <span class="mdc-list-item__text">{{ ucfirst(strtolower($rol->descripcion)) }}</span>
                                                            </li>
                                                        @endif
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="mdc-select-helper-text mdc-select-helper-text--validation-msg nowrap" id="mdc-helper-rol_id" style="height: 15px;"></div>
                                    </div>
                                @endif
                                <div class="col s12 m4 mb-2-s">
                                    <div class="mdc-select mdc-select--outlined mdc-select--dense mdc-select--required" id="mdc-departamento_id">
                                        <div class="mdc-select__anchor" aria-required="true" aria-labelledby="outlined-select-label">
                                            <input type="text" name="departamento_id" id="departamento_id" class="mdc-select__input-value" value="{{ isset($usuario) ? $usuario->cargo->area->departamento_id : '' }}">
                                            <span id="departamento_id__selected-text" class="mdc-select__selected-text capitalize"></span>
                                            <span class="mdc-select__dropdown-icon">
                                                <svg class="mdc-select__dropdown-icon-graphic" viewBox="7 10 10 5">
                                                    <polygon class="mdc-select__dropdown-icon-inactive" stroke="none" fill-rule="evenodd" points="7 10 12 15 17 10"></polygon>
                                                    <polygon class="mdc-select__dropdown-icon-active" stroke="none" fill-rule="evenodd" points="7 15 12 10 17 15"></polygon>
                                                </svg>
                                            </span>
                                            <span class="mdc-notched-outline">
                                                <span class="mdc-notched-outline__leading"></span>
                                                <span class="mdc-notched-outline__notch">
                                                    <span id="outlined-select-label" class="mdc-floating-label">Departamento</span>
                                                </span>
                                                <span class="mdc-notched-outline__trailing"></span>
                                            </span>
                                        </div>
                                        <!-- Other elements from the select remain. -->
                                        <div class="mdc-select__menu mdc-menu mdc-menu-surface" role="listbox">
                                            <ul class="mdc-list">
                                                @foreach ($departamentos as $departamento)
                                                    <li class="mdc-list-item {{ isset($usuario) && $departamento->id == $usuario->cargo->area->departamento_id ? 'mdc-list-item--selected' : '' }}" data-value="{{ $departamento->id }}" role="option" {{ isset($usuario) && $departamento->id == $usuario->cargo->area->departamento_id ? 'aria-selected="true"' : '' }}>
                                                        <span class="mdc-list-item__text capitalize">{{ strtolower($departamento->descripcion) }}</span>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="mdc-select-helper-text mdc-select-helper-text--validation-msg nowrap" id="mdc-helper-departamento_id" style="height: 15px;"></div>
                                </div>
                                <div class="col s12 m4 mb-2-s">
                                    <div class="mdc-select mdc-select--outlined mdc-select--dense mdc-select--required" id="mdc-area_id">
                                        <div class="mdc-select__anchor" aria-required="true" aria-labelledby="outlined-select-label">
                                            <input type="text" name="area_id" id="area_id" class="mdc-select__input-value" value="{{ isset($usuario) ? $usuario->cargo->area_id : '' }}">
                                            <span id="area_id__selected-text" class="mdc-select__selected-text capitalize"></span>
                                            <span class="mdc-select__dropdown-icon">
                                                <svg class="mdc-select__dropdown-icon-graphic" viewBox="7 10 10 5">
                                                    <polygon class="mdc-select__dropdown-icon-inactive" stroke="none" fill-rule="evenodd" points="7 10 12 15 17 10"></polygon>
                                                    <polygon class="mdc-select__dropdown-icon-active" stroke="none" fill-rule="evenodd" points="7 15 12 10 17 15"></polygon>
                                                </svg>
                                            </span>
                                            <span class="mdc-notched-outline">
                                                <span class="mdc-notched-outline__leading"></span>
                                                <span class="mdc-notched-outline__notch">
                                                    <span id="outlined-select-label" class="mdc-floating-label">Área</span>
                                                </span>
                                                <span class="mdc-notched-outline__trailing"></span>
                                            </span>
                                        </div>
                                        <!-- Other elements from the select remain. -->
                                        <div class="mdc-select__menu mdc-menu mdc-menu-surface" role="listbox">
                                            <ul class="mdc-list">
                                                @if (isset($usuario))
                                                    @foreach ($usuario->cargo->area->departamento->areas->sortBy('descripcion') as $area)
                                                        <li class="mdc-list-item {{ isset($usuario) && $area->id == $usuario->cargo->area_id ? 'mdc-list-item--selected' : '' }}" data-value="{{ $area->id }}" role="option" {{ isset($usuario) && $area->id == $usuario->cargo->area->area_id ? 'aria-selected="true"' : '' }}>
                                                            <span class="mdc-list-item__text capitalize">{{ strtolower($area->descripcion) }}</span>
                                                        </li>
                                                    @endforeach
                                                @endif
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="mdc-select-helper-text mdc-select-helper-text--validation-msg nowrap" id="mdc-helper-area_id" style="height: 15px;"></div>
                                </div>
                                <div class="col s12 m4">
                                    <div class="mdc-select mdc-select--outlined mdc-select--dense mdc-select--required" id="mdc-cargo_id">
                                        <div class="mdc-select__anchor" aria-required="true" aria-labelledby="outlined-select-label">
                                            <input type="text" name="cargo_id" id="cargo_id" class="mdc-select__input-value" value="{{ isset($usuario) ? $usuario->cargo_id : '' }}">
                                            <span id="cargo_id__selected-text" class="mdc-select__selected-text capitalize"></span>
                                            <span class="mdc-select__dropdown-icon">
                                                <svg class="mdc-select__dropdown-icon-graphic" viewBox="7 10 10 5">
                                                    <polygon class="mdc-select__dropdown-icon-inactive" stroke="none" fill-rule="evenodd" points="7 10 12 15 17 10"></polygon>
                                                    <polygon class="mdc-select__dropdown-icon-active" stroke="none" fill-rule="evenodd" points="7 15 12 10 17 15"></polygon>
                                                </svg>
                                            </span>
                                            <span class="mdc-notched-outline">
                                                <span class="mdc-notched-outline__leading"></span>
                                                <span class="mdc-notched-outline__notch">
                                                    <span id="outlined-select-label" class="mdc-floating-label">Cargo</span>
                                                </span>
                                                <span class="mdc-notched-outline__trailing"></span>
                                            </span>
                                        </div>
                                        <!-- Other elements from the select remain. -->
                                        <div class="mdc-select__menu mdc-menu mdc-menu-surface" role="listbox">
                                            <ul class="mdc-list">
                                                @if (isset($usuario))
                                                    @foreach ($usuario->cargo->area->cargos->sortBy('descripcion') as $cargo)
                                                        <li class="mdc-list-item {{ isset($usuario) && $cargo->id == $usuario->cargo_id ? 'mdc-list-item--selected' : '' }}" data-value="{{ $cargo->id }}" role="option" {{ isset($usuario) && $cargo->id == $usuario->cargo_id ? 'aria-selected="true"' : '' }}>
                                                            <span class="mdc-list-item__text capitalize">{{ strtolower($cargo->descripcion) }}</span>
                                                        </li>
                                                    @endforeach
                                                @endif
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="mdc-select-helper-text mdc-select-helper-text--validation-msg nowrap" id="mdc-helper-cargo_id" style="height: 15px;"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mb-0 mt-2">
                <div class="col s12">
                    <a class="mdc-button mdc-button--outlined mdc-button--large" href="{{ route('usuarios') }}">
                        <span class="mdc-button__label mr-1">Volver</span>
                        <i class="fas fa-reply"></i>
                    </a>
                    <button class="mdc-button mdc-button--raised mdc-button--large btn-guardar" id="" type="submit">
                        <span class="mdc-button__label mr-1">Guardar</span>
                        <i class="fas fa-save"></i>
                    </button>
                </div>
            </div>
        </div>
    </form>
    <div class="cargando noselect px-5 center" id="guardando" style="display: none">
        <div id="html-spinner"></div>
        <span class="title mt-1">Creando Usuario</span>
    </div>
@endsection

@section('scripts')
    <script>
        $('#{{ isset($usuario) ? 'usuarios' : 'nuevo-usuario' }}').addClass('mdc-list-item--active');

        const urlValidarUsuario = '{{ route('ajax.usuario.validar', ['documento' => 'documento']) }}';

        const areas = @json($areas);
        const cargos = @json($cargos);

        const documento = new mdc.textField.MDCTextField(document.querySelector('#mdc-documento'));
        const nombre = new mdc.textField.MDCTextField(document.querySelector('#mdc-nombre'));
        const telefono = new mdc.textField.MDCTextField(document.querySelector('#mdc-telefono'));
        const correo = new mdc.textField.MDCTextField(document.querySelector('#mdc-correo'));
        const regional_id = new mdc.select.MDCSelect(document.querySelector('#mdc-regional_id'));
        const regional_idHelper = new mdc.select.MDCSelectHelperText(document.querySelector('#mdc-helper-regional_id'));
        @if (isset($usuario) && $usuario->rol_id <= Auth::user()->rol_id)
            const rol = new mdc.textField.MDCTextField(document.querySelector('#mdc-rol'));
        @else
            const rol_id = new mdc.select.MDCSelect(document.querySelector('#mdc-rol_id'));
            const rol_idHelper = new mdc.select.MDCSelectHelperText(document.querySelector('#mdc-helper-rol_id'));
        @endif
        const departamento_id = new mdc.select.MDCSelect(document.querySelector('#mdc-departamento_id'));
        const departamento_idHelper = new mdc.select.MDCSelectHelperText(document.querySelector('#mdc-helper-departamento_id'));
        const area_id = new mdc.select.MDCSelect(document.querySelector('#mdc-area_id'));
        const area_idHelper = new mdc.select.MDCSelectHelperText(document.querySelector('#mdc-helper-area_id'));
        const cargo_id = new mdc.select.MDCSelect(document.querySelector('#mdc-cargo_id'));
        const cargo_idHelper = new mdc.select.MDCSelectHelperText(document.querySelector('#mdc-helper-cargo_id'));

        regional_id.listen('MDCSelect:change', (el) => {
            $('#regional_id').val(regional_id.value);
        });

        @if (!isset($usuario) || $usuario->rol_id > Auth::user()->rol_id)
            rol_id.listen('MDCSelect:change', (el) => {
                $('#rol_id').val(rol_id.value);
            });
        @endif

        departamento_id.listen('MDCSelect:change', (el) => {
            $('#departamento_id').val(departamento_id.value);
            
            // Se reinician los campos de área y cargo
            if (area_id.value)
                area_id.value = null;
            if (cargo_id.value)
                cargo_id.value = null;
            
            // Se filtran solo las áreas del departamento seleccionado
            let areas_select = Object.values(areas).filter(area => area.departamento_id == departamento_id.value);
            
            // Se reescribe el menú del select de áreas
            let menu = $('#mdc-area_id').find('.mdc-list');
            menu.empty();
            for (let i = 0; i < areas_select.length; i++) {
                const area = areas_select[i];
                menu.append('<li class="mdc-list-item" data-value="' + area.id + '" role="option"><span class="mdc-list-item__text capitalize">' + area.descripcion.toLowerCase() + '</span></li>');
            }
        });

        area_id.listen('MDCSelect:change', (el) => {
            $('#area_id').val(area_id.value);
            
            // Se reinicia el campo de cargo
            if (cargo_id.value)
                cargo_id.value = null;
            
            // Se filtran solo los cargos del áreas seleccionada
            let cargos_select = Object.values(cargos).filter(cargo => cargo.area_id == area_id.value);
            
            // Se reescribe el menú del select de cargos
            let menu = $('#mdc-cargo_id').find('.mdc-list');
            menu.empty();
            for (let i = 0; i < cargos_select.length; i++) {
                const cargo = cargos_select[i];
                menu.append('<li class="mdc-list-item" data-value="' + cargo.id + '" role="option"><span class="mdc-list-item__text capitalize">' + cargo.descripcion.toLowerCase() + '</span></li>');
            }
        });

        cargo_id.listen('MDCSelect:change', (el) => {
            $('#cargo_id').val(cargo_id.value);
        });

        const validarUsuario = async function() {
            @if (isset($usuario))
                if (documento.value == '{{ $usuario->documento }}')
                    return false;
            @endif
            let url = urlValidarUsuario.replace('documento', documento.value);
            try {
                const validacion = await $.ajax({
                    method: 'GET',
                    url: url,
                    context: document.body
                }).done(function(response) {
                    return response;
                }).fail(function(error) {
                    console.error(error);
                    return false;
                });
                return validacion;
            } catch(e) {
                console.error(e);
                return false;
            }
        }

        // Valida el formulario antes de enviarlo
        const validar = async function() {
            let errors = 0;

            // Validación del campo de documento
            if (!documento.valid || documento.value == null || documento.value == '') {
                documento.valid = false;
                documento.helperTextContent = 'Ingrese el documento.';
                M.toast({html: '<span class="mr-3">Error en el número de documento.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            }

            // Validación del campo de nombre
            if (!nombre.valid || nombre.value == null || nombre.value == '') {
                nombre.valid = false;
                nombre.helperTextContent = 'Ingrese el nombre.';
                M.toast({html: '<span class="mr-3">Error en el nombre del usuario.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            }

            // Validación del campo de teléfono
            let regex = /^(300|301|302|303|304|305|310|311|312|313|314|315|316|317|318|319|320|321|322|323|350|351)[\d]{7}$/;
            if (telefono.value.length == 7) {
                regex = /^[1-9]\d{6}$/;
            }
            if (!telefono.valid || telefono.value == null || telefono.value == '') {
                telefono.valid = false;
                telefono.helperTextContent = 'Ingrese el telefono.';
                M.toast({html: '<span class="mr-3">Error en el telefono del usuario.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            } else if (!regex.test(telefono.value)) {
                telefono.valid = false;
                telefono.helperTextContent = 'El telefono es inválido.';
                M.toast({html: '<span class="mr-3">Error en el telefono del usuario.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            }

            // Validación del campo de correo electrónico
            let regexCorreo = /^[^\s@]+@([^\s@.,]+\.)+[^\s@.,]{2,}$/;
            if (!correo.valid || correo.value == null || correo.value == '') {
                correo.valid = false;
                correo.helperTextContent = 'Ingrese el correo.';
                M.toast({html: '<span class="mr-3">Error en el correo del usuario.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            } else if (!regexCorreo.test(correo.value)) {
                correo.valid = false;
                correo.helperTextContent = 'El correo es inválido.';
                M.toast({html: '<span class="mr-3">Error en el correo del usuario.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            }

            // Validación del campo de regional
            if (!regional_id.valid || regional_id.value == null || regional_id.value == '') {
                regional_id.valid = false;
                regional_idHelper.foundation.setContent('Seleccione una regional.');
                M.toast({html: '<span class="mr-3">Error en la regional del usuario.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            }

            @if (!isset($usuario) || $usuario->rol_id > Auth::user()->rol_id)
                // Validación del campo de rol
                if (!rol_id.valid || rol_id.value == null || rol_id.value == '') {
                    rol_id.valid = false;
                    rol_idHelper.foundation.setContent('Seleccione un rol.');
                    M.toast({html: '<span class="mr-3">Error en el rol del usuario.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                    errors++;
                }
            @endif

            // Validación del campo de departamento
            if (!departamento_id.valid || departamento_id.value == null || departamento_id.value == '') {
                departamento_id.valid = false;
                departamento_idHelper.foundation.setContent('Seleccione un departamento.');
                M.toast({html: '<span class="mr-3">Error en el departamento del usuario.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            }

            // Validación del campo de área
            if (!area_id.valid || area_id.value == null || area_id.value == '') {
                area_id.valid = false;
                area_idHelper.foundation.setContent('Seleccione un área.');
                M.toast({html: '<span class="mr-3">Error en el área del usuario.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            }

            // Validación del campo de cargo
            if (!cargo_id.valid || cargo_id.value == null || cargo_id.value == '') {
                cargo_id.valid = false;
                cargo_idHelper.foundation.setContent('Seleccione un cargo.');
                M.toast({html: '<span class="mr-3">Error en el cargo del usuario.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            }

            if (errors)
                return false;
            
            // Validación del número de documento para que no sea duplicado
            let validacionUsuario = await validarUsuario();
            if (validacionUsuario) {
                if (validacionUsuario.usuario) {
                    documento.valid = false;
                    documento.helperTextContent = 'El documento ya existe.';
                    let fecha = new Date(validacionUsuario.usuario.created_at);
                    Swal.fire({
                        title: 'El documento ya existe.',
                        text: 'El documento ' +validacionUsuario.usuario.documento+ ' se encuentra registrado con el nombre: ' +validacionUsuario.usuario.nombre+ ' y se creó el día ' +fecha.toLocaleDateString('es-CO')+ '.',
                        icon: 'error'
                    });
                    return false;
                }
            }
            
            return true;
        }

        // Ejecuta la función de validación antes de enviar el formulario
        $('.btn-guardar').on('click', async function(e) {
            $('#guardando').show();
            $('body').css('overflow', 'hidden');
            $(this).attr('disabled', 'disabled');
            e.preventDefault();
            let validacion = await validar();
            if (validacion) {
                $('#cargar-form').submit();
            } else {
                $('#guardando').hide();
                $('body').css('overflow', '');
                $(this).removeAttr('disabled');
            }
        });
    </script>
@endsection