@extends('layouts.app')

@section('styles')
    <link href="{{ asset('vendor/dropify/css/dropify.min.css') }}" rel="stylesheet">
    <style>
        .dropify-wrapper {
            height: 164px;
        }
    </style>
@endsection

@section('content')
    <form action="{{ route('documentos.edit', ['codigo' => $documento->codigo]) }}" method="post" id="editar-form" accept-charset="UTF-8" enctype="multipart/form-data" files="true">
        @csrf
        <div class="container-full">
            <div class="row">
                <div class="col s12 m8">
                    <h1 class="title uppercase font-gilroy">{{ $documento->descripcion }}</h1>
                    <div class="breadcrumbs full-width">
                        <a href="{{ route('dashboard') }}" class="breadcrumb">Dashboard</a>
                        <a href="{{ route('documentos.show', ['codigo' => $documento->codigo]) }}" class="breadcrumb">{{ $documento->codigo }}</a>
                        <a class="breadcrumb">Editar</a>
                    </div>
                </div>
                <div class="col m4 right-align mt-2-s hide-on-small-only">
                    <button class="mdc-button mdc-button--raised mdc-button--large btn-guardar" type="submit">
                        <span class="mdc-button__label mr-1">Guardar</span>
                        <i class="fas fa-save"></i>
                    </button>
                </div>
            </div>
            <div class="row mb-0">
                <div class="col s12 m6 l7 xl8">
                    <div class="card highlighted">
                        <div class="card-content">
                            <div class="row mb-0">
                                <div class="col s12 mb-1">
                                    <blockquote class="my-0" style="line-height: 25px; min-height: 25px;">
                                        <h2 class="title subtitle-1 font-gilroy uppercase mb-0"><b>DATOS DEL DOCUMENTO</b></h2>
                                    </blockquote>
                                </div>
                            </div>
                            <div class="row mb-0">
                                <div class="col s12 m6 mt-1">
                                    @if($documento->version)
                                        <div class="mdc-touch-target-wrapper">
                                            <div class="mdc-checkbox mdc-checkbox__dense mdc-checkbox--touch ml-0 my-0" id="mdc-descargar">
                                                <input type="checkbox" class="mdc-checkbox__native-control" id="descargar" name="descargar" {{ null !== old('descargar') ? (old('descargar') ? 'checked' : '') : ($documento->descargar ? 'checked' : '') }} {{ $documento->version->tipo == 'pdf' ? '' : 'disabled' }}/>
                                                <div class="mdc-checkbox__background">
                                                    <svg class="mdc-checkbox__checkmark" viewBox="0 0 24 24">
                                                        <path class="mdc-checkbox__checkmark-path" fill="none" d="M1.73,12.91 8.1,19.28 22.79,4.59"/>
                                                    </svg>
                                                    <div class="mdc-checkbox__mixedmark"></div>
                                                </div>
                                                <div class="mdc-checkbox__ripple"></div>
                                            </div>
                                            <label for="descargar" class="mdc-checkbox__dense noselect nowrap font-gilroy">PERMITIR DESCARGA DEL ARCHIVO</label>
                                        </div>
                                    @endif
                                </div>
                                <div class="col s12 m6 mt-1">
                                    <div class="mdc-touch-target-wrapper">
                                        <div class="mdc-checkbox mdc-checkbox__dense mdc-checkbox--touch ml-0 my-0" id="mdc-firmar">
                                            <input type="checkbox" class="mdc-checkbox__native-control" id="firmar" name="firmar" {{ null !== old('firmar') ? (old('firmar') ? 'checked' : '') : ($documento->firmar ? 'checked' : '') }}/>
                                            <div class="mdc-checkbox__background">
                                                <svg class="mdc-checkbox__checkmark" viewBox="0 0 24 24">
                                                    <path class="mdc-checkbox__checkmark-path" fill="none" d="M1.73,12.91 8.1,19.28 22.79,4.59"/>
                                                </svg>
                                                <div class="mdc-checkbox__mixedmark"></div>
                                            </div>
                                            <div class="mdc-checkbox__ripple"></div>
                                        </div>
                                        <label for="firmar" class="mdc-checkbox__dense noselect nowrap font-gilroy">HABILITAR FIRMA EN EL DOCUMENTO</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-2 mb-0">
                                <div class="col s12 m6 mb-2">
                                    <label class="mdc-text-field mdc-text-field--outlined mdc-text-field--dense focusable" id="mdc-codigo">
                                        <span class="mdc-notched-outline">
                                            <span class="mdc-notched-outline__leading"></span>
                                            <span class="mdc-notched-outline__notch">
                                                <span class="mdc-floating-label" id="lbl_codigo">Código del Documento</span>
                                            </span>
                                            <span class="mdc-notched-outline__trailing"></span>
                                        </span>
                                        <input type="text" class="mdc-text-field__input" aria-labelledby="lbl_codigo" id="codigo" name="codigo" value="{{ isset($documento) && $documento->codigo ? $documento->codigo : '' }}" maxlength="20" required>
                                    </label>
                                    <div class="mdc-text-field-helper-line">
                                        <div class="mdc-text-field-helper-text mdc-text-field-helper-text--validation-msg nowrap" id="mdc-helper-codigo" aria-hidden="true"></div>
                                        <div class="mdc-text-field-character-counter">0 / 20</div>
                                    </div>
                                </div>
                                <div class="col s12 m6 mb-2">
                                    <div class="mdc-select mdc-select--outlined mdc-select--dense mdc-select--required" id="mdc-categoria_id">
                                        <div class="mdc-select__anchor" aria-required="true" aria-labelledby="outlined-select-label">
                                            <input type="text" name="categoria_id" id="categoria_id" class="mdc-select__input-value" value="{{ isset($documento) ? $documento->categoria_id : '' }}">
                                            <span id="categoria_id__selected-text" class="mdc-select__selected-text"></span>
                                            <span class="mdc-select__dropdown-icon">
                                                <svg class="mdc-select__dropdown-icon-graphic" viewBox="7 10 10 5">
                                                    <polygon class="mdc-select__dropdown-icon-inactive" stroke="none" fill-rule="evenodd" points="7 10 12 15 17 10"></polygon>
                                                    <polygon class="mdc-select__dropdown-icon-active" stroke="none" fill-rule="evenodd" points="7 15 12 10 17 15"></polygon>
                                                </svg>
                                            </span>
                                            <span class="mdc-notched-outline">
                                                <span class="mdc-notched-outline__leading"></span>
                                                <span class="mdc-notched-outline__notch">
                                                    <span id="outlined-select-label" class="mdc-floating-label">Categoría</span>
                                                </span>
                                                <span class="mdc-notched-outline__trailing"></span>
                                            </span>
                                        </div>
                                        <!-- Other elements from the select remain. -->
                                        <div class="mdc-select__menu mdc-menu mdc-menu-surface" role="listbox">
                                            <ul class="mdc-list">
                                                @foreach ($categorias as $categoria)
                                                    <li class="mdc-list-item {{ isset($documento) && $categoria->id == $documento->categoria_id ? 'mdc-list-item--selected' : '' }}" data-value="{{ $categoria->id }}" role="option" {{ isset($documento) && $categoria->id == $documento->categoria_id ? 'aria-selected="true"' : '' }}>
                                                        <span class="mdc-list-item__text">{{ ucfirst(strtolower($categoria->descripcion)) }}</span>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="mdc-select-helper-text mdc-select-helper-text--validation-msg nowrap" id="mdc-helper-categoria_id" style="height: 15px;"></div>
                                </div>
                                <div class="col s12">
                                    <label class="mdc-text-field mdc-text-field--outlined mdc-text-field--textarea mdc-text-field--textarea-dense" id="mdc-descripcion">
                                        <span class="mdc-text-field__resizer">
                                            <textarea class="mdc-text-field__input" rows="3" cols="40" maxlength="100" aria-label="Label" name="descripcion" required>{{ isset($documento) && $documento->descripcion ? $documento->descripcion : '' }}</textarea>
                                        </span>
                                        <span class="mdc-notched-outline">
                                            <span class="mdc-notched-outline__leading"></span>
                                            <span class="mdc-notched-outline__notch">
                                                <span class="mdc-floating-label" id="lbl_descripcion">Título del Documento</span>
                                            </span>
                                            <span class="mdc-notched-outline__trailing"></span>
                                        </span>
                                    </label>
                                    <div class="mdc-text-field-helper-line">
                                        <div class="mdc-text-field-helper-text mdc-text-field-helper-text--validation-msg nowrap" id="mdc-helper-categoria_id" aria-hidden="true"></div>
                                        <div class="mdc-text-field-character-counter">0 / 100</div>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-0 mt-1">
                                <div class="col s6 mt-1">
                                    <div class="mdc-touch-target-wrapper">
                                        <div class="mdc-checkbox mdc-checkbox__dense mdc-checkbox--touch ml-0 my-0" id="mdc-regionales">
                                            <input type="checkbox" class="mdc-checkbox__native-control" id="regionales" name="regionales" {{ null !== old('regionales') ? (old('regionales') ? 'checked' : '') : ($regionales->count() == $documento->regionales->count() ? 'checked' : '') }}/>
                                            <div class="mdc-checkbox__background">
                                                <svg class="mdc-checkbox__checkmark" viewBox="0 0 24 24">
                                                    <path class="mdc-checkbox__checkmark-path" fill="none" d="M1.73,12.91 8.1,19.28 22.79,4.59"/>
                                                </svg>
                                                <div class="mdc-checkbox__mixedmark"></div>
                                            </div>
                                            <div class="mdc-checkbox__ripple"></div>
                                        </div>
                                        <label for="regionales" class="mdc-checkbox__dense noselect nowrap font-gilroy">Todas las Regionales</label>
                                    </div>
                                </div>
                                @foreach ($regionales as $regional)
                                    <div class="col s6 mt-1">
                                        <div class="mdc-touch-target-wrapper">
                                            <div class="mdc-checkbox mdc-checkbox__dense mdc-checkbox--touch mdc-chk-regional ml-0 my-0" id="mdc-regional-{{ $regional->id }}">
                                                <input type="checkbox" class="mdc-checkbox__native-control mdc-regional" id="regional-{{ $regional->id }}" name="regional-{{ $regional->id }}" {{ null !== old('regional-' . $regional->id) ? (old('regional-' . $regional->id) ? 'checked' : '') : ($documento->regionales->where('id', $regional->id)->first() ? 'checked': '') }}/>
                                                <div class="mdc-checkbox__background">
                                                    <svg class="mdc-checkbox__checkmark" viewBox="0 0 24 24">
                                                        <path class="mdc-checkbox__checkmark-path" fill="none" d="M1.73,12.91 8.1,19.28 22.79,4.59"/>
                                                    </svg>
                                                    <div class="mdc-checkbox__mixedmark"></div>
                                                </div>
                                                <div class="mdc-checkbox__ripple"></div>
                                            </div>
                                            <label for="regional-{{ $regional->id }}" class="mdc-checkbox__dense noselect nowrap font-gilroy">Regional {{ $regional->nombre }}</label>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col s12 m6 l5 xl4">
                    <div class="card highlighted">
                        <div class="card-content">
                            <div class="row mb-0">
                                <div class="col s6 mb-1">
                                    <blockquote class="my-0" style="line-height: 25px; min-height: 25px;">
                                        <h2 class="title subtitle-1 font-gilroy uppercase mb-0"><b>VERSIONES</b></h2>
                                    </blockquote>
                                </div>
                                <div class="col s6 right-align mb-1">
                                    <a class="mdc-button mdc-button--super-dense mdc-button--raised" href="{{ route('documentos.version', ['codigo' => $documento->codigo]) }}">
                                        <span class="mdc-button__label mr-1">Añadir Versión</span>
                                        <i class="fas fa-file-upload"></i>
                                    </a>
                                </div>
                                <div class="col s12 mt-2">
                                    <div class="mdc-data-table mdc-data-table--dense full-width">
                                        <div class="mdc-data-table__table-container">
                                            <table class="mdc-data-table__table" aria-label="Listado de bodegas">
                                                <thead>
                                                    <tr class="mdc-data-table__header-row">
                                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">N°</th>
                                                        <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Fecha</th>
                                                        <th class="mdc-data-table__header-cell pr-0" role="columnheader" scope="col">Acciones</th>
                                                    </tr>
                                                </thead>
                                                <tbody class="mdc-data-table__content">
                                                    @forelse ($documento->versiones->sortByDesc('version') as $index => $version)
                                                        <tr class="mdc-data-table__row">
                                                            <td class="mdc-data-table__cell noselect">{{ $version->version }}</td>
                                                            <td class="mdc-data-table__cell noselect">{{ date('d/m/Y', strtotime($version->created_at)) }}</td>
                                                            <td class="mdc-data-table__cell noselect nowrap">
                                                                <a class="link link-download link-{{ $version->tipo }}" data-id="{{ $version->id }}" href="{{ asset('private-storage/' . $version->url) }}" download target="_blank">
                                                                    Descargar<i style="margin-left: 5px;" class="fz-16 far fa-file-{{ $version->tipo }} icon-{{ $version->tipo }}"></i>
                                                                </a>
                                                                @if($documento->versiones->count() > 1)
                                                                    <button class="link link-primary px-0 ml-1 cursor-pointer btn_borrar_version" data-id="{{ $version->id }}" data-version="{{ $version->version }}" type="button">
                                                                        Borrar<i style="margin-left: 5px;" class="fz-16 fas fa-trash-alt"></i>
                                                                    </button>
                                                                @endif
                                                            </td>
                                                        </tr>
                                                    @empty
                                                    <tr class="mdc-data-table__row">
                                                        <td class="mdc-data-table__cell center noselect" colspan="3">No hay versiones</td>
                                                    </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mb-0">
                <div class="col s12">
                    <div class="card highlighted">
                        <div class="card-content">
                            <div class="row">
                                <div class="col s12 m6 mb-1">
                                    <blockquote class="my-0" style="line-height: 25px; height: 25px;">
                                        <h2 class="title subtitle-1 font-gilroy uppercase mb-0"><b>Seleccionar Cargos</b></h2>
                                    </blockquote>
                                </div>
                                <div class="col s12 m6 mb-1">
                                    <div class="mdc-touch-target-wrapper">
                                        <div class="mdc-checkbox mdc-checkbox__dense mdc-checkbox--touch ml-0 my-0" id="mdc-chk-all">
                                            <input type="checkbox" class="mdc-checkbox__native-control" id="chk-all" name="chk-all" {{ old('chk-all') ? 'checked' : ($cargos->count() == $documento->cargos_count ? 'checked' : '') }}/>
                                            <div class="mdc-checkbox__background">
                                                <svg class="mdc-checkbox__checkmark" viewBox="0 0 24 24">
                                                    <path class="mdc-checkbox__checkmark-path" fill="none" d="M1.73,12.91 8.1,19.28 22.79,4.59"/>
                                                </svg>
                                                <div class="mdc-checkbox__mixedmark"></div>
                                            </div>
                                            <div class="mdc-checkbox__ripple"></div>
                                        </div>
                                        <label for="chk-all" class="mdc-checkbox__dense noselect nowrap font-gilroy">SELECCIONAR TODOS LOS CARGOS</label>
                                    </div>
                                </div>
                            </div>
                            @foreach ($departamentos as $departamento)
                                <hr class="mt-2">
                                <div class="row mb-0 mt-2">
                                    <div class="col s12">
                                        <div class="mdc-touch-target-wrapper">
                                            <div class="mdc-checkbox mdc-checkbox__dense mdc-checkbox--touch ml-0 my-0 mdc-chk-departamento" id="mdc-chk-departamento-{{ $departamento->id }}">
                                                <input type="checkbox" class="mdc-checkbox__native-control" id="chk-departamento-{{ $departamento->id }}" name="chk-departamento-{{ $departamento->id }}" {{ old('chk-departamento-' . $departamento->id) ? 'checked' : ($departamento->cargos->count() == count(array_filter($cargosDocumento, function($item) use ($departamento) { return $departamento->areas->find($item['area_id']); })) ? 'checked' : '') }}/>
                                                <div class="mdc-checkbox__background">
                                                    <svg class="mdc-checkbox__checkmark" viewBox="0 0 24 24">
                                                        <path class="mdc-checkbox__checkmark-path" fill="none" d="M1.73,12.91 8.1,19.28 22.79,4.59"/>
                                                    </svg>
                                                    <div class="mdc-checkbox__mixedmark"></div>
                                                </div>
                                                <div class="mdc-checkbox__ripple"></div>
                                            </div>
                                            <label for="chk-departamento-{{ $departamento->id }}" class="mdc-checkbox__dense noselect nowrap">
                                                <h5 class="title subtitle-3 uppercase black-text font-gilroy" style="line-height: 25px!important">{{ ($departamento->descripcion) }}</h5>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                @foreach ($departamento->areas->sortBy('descripcion') as $area)
                                    <div class="row mb-0 mt-2">
                                        <div class="col s12">
                                            <div class="mdc-touch-target-wrapper">
                                                <div class="mdc-checkbox mdc-checkbox__dense mdc-checkbox--touch ml-0 my-0 mdc-chk-area chk-departamento-{{ $departamento->id }}" id="mdc-chk-area-{{ $area->id }}">
                                                    <input type="checkbox" class="mdc-checkbox__native-control" id="chk-area-{{ $area->id }}" name="chk-area-{{ $area->id }}" {{ old('chk-area-' . $area->id) ? 'checked' : ($area->cargos->count() == count(array_filter($cargosDocumento, function($item) use ($area) { return $item['area_id'] == $area->id; })) ? 'checked' : '') }}/>
                                                    <div class="mdc-checkbox__background">
                                                        <svg class="mdc-checkbox__checkmark" viewBox="0 0 24 24">
                                                            <path class="mdc-checkbox__checkmark-path" fill="none" d="M1.73,12.91 8.1,19.28 22.79,4.59"/>
                                                        </svg>
                                                        <div class="mdc-checkbox__mixedmark"></div>
                                                    </div>
                                                    <div class="mdc-checkbox__ripple"></div>
                                                </div>
                                                <label for="chk-area-{{ $area->id }}" class="mdc-checkbox__dense noselect nowrap font-gilroy"><h5 class="subtitle subtitle-3 uppercase black-text" style="line-height: 25px!important">{{ ($area->descripcion) }}</h5></label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mt-1 mb-0">
                                        @foreach ($area->cargos->sortBy('descripcion') as $cargo)
                                            <div class="col s12 m4 xl3">
                                                <div class="mdc-touch-target-wrapper">
                                                    <div class="mdc-checkbox mdc-checkbox__dense mdc-checkbox--touch ml-0 my-0 mdc-chk-cargo chk-area-{{ $area->id }} chk-departamento-{{ $departamento->id }}" id="mdc-chk-cargo-{{ $cargo->id }}">
                                                        <input data-area="{{ $area->id }}" type="checkbox" class="mdc-checkbox__native-control" id="chk-cargo-{{ $cargo->id }}" name="chk-cargo-{{ $cargo->id }}" {{ old('cargo-' . $cargo->id) ? 'checked' : (count(array_filter($cargosDocumento, function($item) use ($cargo) { return $item['id'] == $cargo->id; })) ? 'checked' : '') }}/>
                                                        <div class="mdc-checkbox__background">
                                                            <svg class="mdc-checkbox__checkmark" viewBox="0 0 24 24">
                                                                <path class="mdc-checkbox__checkmark-path" fill="none" d="M1.73,12.91 8.1,19.28 22.79,4.59"/>
                                                            </svg>
                                                            <div class="mdc-checkbox__mixedmark"></div>
                                                        </div>
                                                        <div class="mdc-checkbox__ripple"></div>
                                                    </div>
                                                    <label for="chk-cargo-{{ $cargo->id }}" class="mdc-checkbox__dense noselect nowrap font-gilroy uppercase">{{ ($cargo->descripcion) }}</label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @endforeach
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mb-0 mt-2">
                <div class="col s12">
                    <a class="mdc-button mdc-button--outlined mdc-button--large" href="{{ route('dashboard') }}">
                        <span class="mdc-button__label mr-1">Volver</span>
                        <i class="fas fa-reply"></i>
                    </a>
                    <button class="mdc-button mdc-button--raised mdc-button--large btn-guardar" type="submit">
                        <span class="mdc-button__label mr-1">Guardar</span>
                        <i class="fas fa-save"></i>
                    </button>
                </div>
            </div>
        </div>
    </form>
    <div class="cargando noselect px-5 center" id="guardando" style="display: none">
        <div id="html-spinner"></div>
        <span class="title mt-1">Guardando Cambios en el Documento</span>
    </div>
    <div class="cargando noselect px-5 center" id="eliminando" style="display: none">
        <div id="html-spinner"></div>
        <span class="title mt-1">Eliminando Versión</span>
    </div>
@endsection

@section('scripts')
    <script src="{{ asset('vendor/dropify/js/dropify.min.js') }}"></script>
    <script>
        $('#dashboard').addClass('mdc-list-item--active');

        let versiones = {{ $documento->versiones->count() }};

        let urlValidarDocumento = '{{ route('ajax.documentos.validar', ['codigo' => 'codigo', 'version' => 'version']) }}';
        let utlEliminarVersion = '{{ route('ajax.documentos.version.eliminar', ['codigo' => $documento->codigo, 'version' => 'version']) }}';
        
        const codigo = new mdc.textField.MDCTextField(document.querySelector('#mdc-codigo'));
        const categoria_id = new mdc.select.MDCSelect(document.querySelector('#mdc-categoria_id'));
        const categoria_idHelper = new mdc.select.MDCSelectHelperText(document.querySelector('#mdc-helper-categoria_id'));
        const descripcion = new mdc.textField.MDCTextField(document.querySelector('#mdc-descripcion'));

        categoria_id.listen('MDCSelect:change', (el) => {
            $('#categoria_id').val(categoria_id.value);
        });

        const regionales = new mdc.checkbox.MDCCheckbox(document.querySelector('#mdc-regionales'));
        const checkall = new mdc.checkbox.MDCCheckbox(document.querySelector('#mdc-chk-all'));
        const checkboxes_regionales = [].map.call(document.querySelectorAll('.mdc-chk-regional'), function(el) {
            return new mdc.checkbox.MDCCheckbox(el);
        });
        const checkboxes_departamentos = [].map.call(document.querySelectorAll('.mdc-chk-departamento'), function(el) {
            return new mdc.checkbox.MDCCheckbox(el);
        });
        const checkboxes_areas = [].map.call(document.querySelectorAll('.mdc-chk-area'), function(el) {
            return new mdc.checkbox.MDCCheckbox(el);
        });
        const checkboxes_cargos = [].map.call(document.querySelectorAll('.mdc-chk-cargo'), function(el) {
            return new mdc.checkbox.MDCCheckbox(el);
        });

        $('#mdc-regionales').on('change', 'input', function () {
            if ($(this).is(':checked')) {
                for (let index = 0; index < checkboxes_regionales.length; index++) {
                    const chk = checkboxes_regionales[index];
                    chk.checked = true;
                }
            } else {
                for (let index = 0; index < checkboxes_regionales.length; index++) {
                    const chk = checkboxes_regionales[index];
                    chk.checked = false;
                }
            }
        });

        $('.mdc-regional').on('change', function () {
            if ($(this).is(':checked')) {
                let regionalesChecked = $('.mdc-regional:checked').length;
                if (regionalesChecked == checkboxes_regionales.length) {
                    regionales.checked = true;
                } else {
                    regionales.checked = false;
                }
            } else {
                regionales.checked = false;
            }
        });

        $('#mdc-chk-all input').on('change', function () {
            if ($(this).is(':checked')) {
                for (let index = 0; index < checkboxes_departamentos.length; index++) {
                    const chk = checkboxes_departamentos[index];
                    chk.checked = true;
                }
                for (let index = 0; index < checkboxes_areas.length; index++) {
                    const chk = checkboxes_areas[index];
                    chk.checked = true;
                }
                for (let index = 0; index < checkboxes_cargos.length; index++) {
                    const chk = checkboxes_cargos[index];
                    chk.checked = true;
                }
            } else {
                for (let index = 0; index < checkboxes_departamentos.length; index++) {
                    const chk = checkboxes_departamentos[index];
                    chk.checked = false;
                }
                for (let index = 0; index < checkboxes_areas.length; index++) {
                    const chk = checkboxes_areas[index];
                    chk.checked = false;
                }
                for (let index = 0; index < checkboxes_cargos.length; index++) {
                    const chk = checkboxes_cargos[index];
                    chk.checked = false;
                }
            }
        });

        $('.mdc-chk-departamento input').on('change', function () {
            let id = $(this).attr('id');
            let chkList = $('.' + id);
            if ($(this).is(':checked')) {
                for (let index = 0; index < chkList.length; index++) {
                    let chkItem = $(chkList)[index];
                    $(chkItem).find('input').prop('checked', true);
                }
            } else {
                for (let index = 0; index < chkList.length; index++) {
                    let chkItem = $(chkList)[index];
                    $(chkItem).find('input').prop('checked', false);
                }
            }
        });

        $('.mdc-chk-area input').on('change', function () {
            let id = $(this).attr('id');
            let chkList = $('.' + id);
            if ($(this).is(':checked')) {
                for (let index = 0; index < chkList.length; index++) {
                    let chkItem = $(chkList)[index];
                    $(chkItem).find('input').prop('checked', true);
                }
            } else {
                for (let index = 0; index < chkList.length; index++) {
                    let chkItem = $(chkList)[index];
                    $(chkItem).find('input').prop('checked', false);
                }
            }
        });

        $('.dropify').dropify({
            messages: {
                'default': 'Arrastra y suelta un archivo aquí o haz click',
                'replace': 'Arrastra y suelta un archivo o haz clic para reemplazar',
                'remove':  'Quitar Archivo',
                'error':   'Ooops, hubo un error inesperado.',
            },
            error: {
                'fileSize': 'El tamaño del archivo es demasiado grande.',
                'fileExtension': 'La extensión del archivo no es válida.',
            }
        });

        $('.dropify').on('change', function () {
            if ($('.dropify').val().split('.').pop().toLowerCase() == 'pdf') {
                $('#descargar').removeAttr('disabled');
            } else {
                $('#descargar').prop('checked', true);
                $('#descargar').attr('disabled', 'disabled');
            }
        });

        const validarDocumento = async function() {
            if (codigo.value == '{{ $documento->codigo }}')
                return false;
            let url = urlValidarDocumento.replace('codigo', codigo.value).replace('version', '{{ $documento->version ? $documento->version->version : '' }}');
            try {
                const validacion = await $.ajax({
                    method: 'GET',
                    url: url,
                    context: document.body
                }).done(function(response) {
                    return response;
                }).fail(function(error) {
                    console.error(error);
                    return false;
                });
                return validacion;
            } catch(e) {
                console.error(e);
                return false;
            }
        }

        // Valida el formulario antes de enviarlo
        const validar = async function() {
            if (!codigo.valid || codigo.value == null || codigo.value == '') {
                codigo.valid = false;
                codigo.helperTextContent = 'Ingrese el código del documento.';
                M.toast({html: '<span class="mr-3">Error en el código del documento.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                return false;
            }
            if (!categoria_id.valid || categoria_id.value == null || categoria_id.value == '') {
                categoria_id.valid = false;
                categoria_idHelper.foundation.setContent('Seleccione una categoría.');
                M.toast({html: '<span class="mr-3">Error en la categoría del documento.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                return false;
            }
            if (!descripcion.valid || descripcion.value == null || descripcion.value == '') {
                descripcion.valid = false;
                descripcion.helperTextContent = 'Ingrese el título del documento.';
                M.toast({html: '<span class="mr-3">Error en el título del documento.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                return false;
            }
            if ($('.mdc-chk-cargo input:checked').length < 1) {
                M.toast({html: '<span class="mr-3">Seleccione por lo menos, un cargo.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                return false;
            }
            let validacionDocumento = await validarDocumento();
            if (validacionDocumento) {
                if (validacionDocumento.documento) {
                    codigo.valid = false;
                    codigo.helperTextContent = 'El código ya existe.';
                    let fecha = new Date(validacionDocumento.documento.created_at);
                    Swal.fire({
                        title: 'El documento ya existe.',
                        text: 'El documento ' +validacionDocumento.documento.codigo+ ' se encuentra registrado con el título: ' +validacionDocumento.documento.descripcion+ ' y fue subido el día ' +fecha.toLocaleDateString('es-CO')+ '.',
                        icon: 'error'
                    });
                    return false;
                }
            }

            return true;
        }

        // Ejecuta la función de validación antes de enviar el formulario
        $('.btn-guardar').on('click', async function(e) {
            $('#guardando').show();
            $('body').css('overflow', 'hidden');
            $(this).attr('disabled', 'disabled');
            e.preventDefault();
            let validacion = await validar();
            if (validacion) {
                $('#editar-form').submit();
            } else {
                $('#guardando').hide();
                $('body').css('overflow', '');
                $(this).removeAttr('disabled');
            }
        });

        $('.btn_borrar_version').on('click', function(e) {
            let id = $(this).data('id');
            let version = $(this).data('version');
            Swal.fire({
                title: '¿Eliminar Versión?',
                text: 'Esta acción eliminará la versión '+ version +' del documento.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#ff0000',
                confirmButtonText: 'Si, eliminar!',
                cancelButtonText: 'Cancelar',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    $('#eliminando').show();
                    $('body').css('overflow', 'hidden');
                    $(this).attr('disabled', 'disabled');
                    let url = utlEliminarVersion.replace('version', id);
                    $.ajax({
                        method: 'POST',
                        url: url,
                        context: document.body,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    }).done(function(response) {
                        window.location.reload();
                    }).fail(function(error) {
                        console.error(error);
                        $('#eliminando').hide();
                        $('body').css('overflow', '');
                        $(this).removeAttr('disabled');
                        Swal.fire({
                            title: 'Ooops!',
                            text: 'Hubo un error inesperado. Intente más tarde nuevamente.',
                            icon: 'error'
                        });
                    });
                }
            });
        });
    </script>
@endsection