@extends('layouts.app')

@section('content')
    <div class="container-full">
        <div class="row">
            <div class="col s12">
                <h1 class="title uppercase font-gilroy">LISTADO DE PROCESOS</h1>
                <div class="breadcrumbs full-width">
                    <a class="breadcrumb">Sistema de Documentos Internos</a>
                </div>
            </div>
        </div>
        <div class="row">
            @foreach ($procesos as $proceso)
                @if($proceso->documentos)
                    <div class="col s12 m6 l4 xl3" class="card-proceso" data-proceso="{{ $proceso->nombre }}">
                        <a href="{{ route('dashboard.proceso', ['proceso' => $proceso->slug]) }}">
                            <div class="card cursor-pointer full-width" style="display: inline-flex; align-items: center; height: 95px;">
                                <div class="center bg-primary" style="width: 95px; height: 100%; align-items: center; display: flex; justify-content: center;">
                                    <div style="display: grid">
                                        <span class="white-text" style="font-size: 34px; font-weight: 700; line-height: 34px; margin-bottom: 5px;">{{ $proceso->codigo }}</span>
                                        <i class="fas fa-folder-open white-text" style="font-size: 16px"></i>
                                    </div>
                                </div>
                                <div class="card-content" style="width: calc(100% - 95px);">
                                    <span class="card-title nowrap primary" style="color: initial">{{ $proceso->nombre }}</span>
                                    <label class="cursor-pointer" style="color: #717171">
                                        @switch($proceso->documentos)
                                            @case(0)
                                                Sin documentos
                                                @break
                                            @case(1)
                                                1 documento
                                                @break
                                            @default
                                                {{ $proceso->documentos }} documentos
                                        @endswitch
                                    </label>
                                </div>
                            </div>
                        </a>
                    </div>
                @endif
            @endforeach
            <div class="col s12 m6 l4 xl3" class="card-proceso" data-proceso="todos los documentos">
                <a href="{{ route('dashboard.proceso', ['proceso' => 'todos']) }}">
                    <div class="card cursor-pointer full-width" style="display: inline-flex; align-items: center; height: 95px;">
                        <div class="center bg-primary" style="width: 95px; height: 100%; align-items: center; display: flex; justify-content: center;">
                            <div style="display: grid">
                                <span class="white-text" style="font-size: 34px; font-weight: 700; line-height: 34px; margin-bottom: 5px;">ALL</span>
                                <i class="fas fa-folder-open white-text" style="font-size: 16px"></i>
                            </div>
                        </div>
                        <div class="card-content" style="width: calc(100% - 95px);">
                            <span class="card-title nowrap primary" style="color: initial">Todos los Documentos</span>
                            <label class="cursor-pointer" style="color: #717171">
                                @switch($total_documentos)
                                    @case(0)
                                        Sin documentos
                                        @break
                                    @case(1)
                                        1 documento
                                        @break
                                    @default
                                        {{ $total_documentos }} documentos
                                @endswitch
                            </label>
                        </div>
                    </div>
                </a>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $('#dashboard').addClass('mdc-list-item--active');
    </script>
@endsection