@extends('layouts.app')

@php
    setlocale(LC_ALL, 'es_ES');
    \Carbon\Carbon::setLocale('es');
@endphp

@section('content')
    <div class="container-full">
        <div class="row">
            <div class="col s12 m8">
                <h1 class="title uppercase font-gilroy">{{ $cargo->descripcion }}</h1>
                <div class="breadcrumbs full-width">
                    <a href="{{ route('dashboard') }}" class="breadcrumb">Dashboard</a>
                    <a href="{{ route('cargos') }}" class="breadcrumb">Cargos</a>
                    <a class="breadcrumb">{{ $cargo->descripcion }}</a>
                </div>
            </div>
            <div class="col m4 right-align mt-2-s">
                <div style="display: inline-block;">
                    <div id="demo-menu" class="mdc-menu-surface--anchor">
                        <button id="menu-button" type="button" class="mdc-button mdc-button--raised mdc-button--large">
                            <span class="mdc-button__label mr-1">Opciones</span>
                            <i class="fas fa-cog"></i>
                        </button>
                        <div class="mdc-menu mdc-menu-surface" id="menu-options">
                            <ul class="mdc-list py-0" role="menu" aria-hidden="true" aria-orientation="vertical" tabindex="-1">
                                <li class="mdc-list-item nowrap px-2" role="menuitem">
                                    <span class="mdc-list-item__ripple"></span>
                                    <a class="link-primary d-flex full-width full-height px-2" href="{{ route('cargos.editar', ['cargo' => $cargo->id]) }}" class="mdc-list-item__text">
                                        <div class="valign-wrapper full-width">
                                            <span>Editar</span>
                                            <div class="right-align full-width no-line-height">
                                                <i class="ml-1 fas fa-pen"></i>
                                            </div>
                                        </div>
                                    </a>
                                </li>
                                <li class="mdc-list-item nowrap px-2" role="menuitem">
                                    <span class="mdc-list-item__ripple"></span>
                                    <a class="link-primary d-flex full-width full-height px-2" href="{{ route('cargos.eliminar', ['cargo' => $cargo->id]) }}" class="mdc-list-item__text">
                                        <div class="valign-wrapper full-width">
                                            <span>Eliminar</span>
                                            <div class="right-align full-width no-line-height">
                                                <i class="ml-1 fas fa-trash"></i>
                                            </div>
                                        </div>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mb-0">
            <div class="col s12">
                <div class="card highlighted">
                    <div class="card-content">
                        <div class="row mb-2">
                            <div class="col s12 mb-1">
                                <blockquote class="my-0" style="line-height: 25px; height: 25px;">
                                    <h2 class="title subtitle-1 font-gilroy uppercase mb-0"><b>DATOS DEL Cargo</b></h2>
                                </blockquote>
                            </div>
                        </div>
                        <div class="row mb-0">
                            <div class="col s12 m6 mb-2">
                                <label>Descrición</label>
                                <span class="card-subtitle subtitle-3 highlighted capitalize">{{ mb_strtolower($cargo->descripcion) }}</span>
                            </div>
                            <div class="col s12 m6 mb-2">
                                <label>Área</label>
                                <span class="card-subtitle subtitle-3 highlighted capitalize">{{ mb_strtolower($cargo->area->descripcion) }}</span>
                            </div>
                            <div class="col s12 m6 mb-2">
                                <label>Departamento</label>
                                <span class="card-subtitle subtitle-3 highlighted capitalize">{{ mb_strtolower($cargo->area->departamento->descripcion) }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mb-0">
            <div class="col s12 m6">
                <div class="card highlighted">
                    <div class="card-content">
                        <div class="row mb-0">
                            <div class="col s12 mb-1">
                                <blockquote class="my-0" style="line-height: 25px; min-height: 25px;">
                                    <h2 class="title subtitle-1 font-gilroy uppercase mb-0">
                                        <b>ÚLTIMOS DOCUMENTOS</b>
                                    </h2>
                                </blockquote>
                            </div>
                            <div class="col s12 mt-2">
                                <div class="mdc-data-table mdc-data-table--dense full-width">
                                    <div class="mdc-data-table__table-container">
                                        <table class="mdc-data-table__table" aria-label="Listado de bodegas">
                                            <thead>
                                                <tr class="mdc-data-table__header-row">
                                                    <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Código</th>
                                                    <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Nombre</th>
                                                    <th class="mdc-data-table__header-cell" role="columnheader" scope="col">Fecha</th>
                                                </tr>
                                            </thead>
                                            <tbody class="mdc-data-table__content">
                                                @forelse ($cargo->documentos()->limit(5)->get() as $index => $documento)
                                                    <tr class="mdc-data-table__row">
                                                        <td class="mdc-data-table__cell noselect nowrap">
                                                            <a class="link link-{{ $documento->version->tipo }}" href="{{ route('documentos.show', ['codigo' => $documento->codigo]) }}" target="_blank">{{ mb_strtoupper($documento->codigo) .' V'. $documento->version->version }}</a>
                                                        </td>
                                                        <td class="mdc-data-table__cell">{{ ucfirst(mb_strtolower($documento->descripcion)) }}</td>
                                                        <td class="mdc-data-table__cell nowrap">
                                                            @switch(\Carbon\Carbon::parse($cargo->created_at)->startOfDay()->diffInDays($hoy->startOfDay(), false))
                                                                @case(0)
                                                                    Hoy
                                                                    @break
                                                                @case(1)
                                                                    Ayer
                                                                    @break
                                                                @default
                                                                    {{ \Carbon\Carbon::parse($cargo->created_at)->day . ' de '. ucfirst(\Carbon\Carbon::parse($cargo->created_at)->monthName) . (\Carbon\Carbon::parse($cargo->created_at)->year == $hoy->year ? '' : ' de ' . \Carbon\Carbon::parse($cargo->created_at)->year) }}
                                                            @endswitch
                                                        </td>
                                                    </tr>
                                                @empty
                                                    <tr class="mdc-data-table__row">
                                                        <th class="mdc-data-table__cell center" scope="row" colspan="3">No hay documentos asignados.</th>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mb-0 mt-2">
            <div class="col s12">
                <a class="mdc-button mdc-button--outlined mdc-button--large" href="{{ route('cargos') }}">
                    <span class="mdc-button__label mr-1">Volver</span>
                    <i class="fas fa-reply"></i>
                </a>
            </div>
        </div>
    </div>
    <div class="cargando noselect px-5 center" id="reiniciando" style="display: none">
        <div id="html-spinner"></div>
        <span class="title mt-1">Reiniciando Contraseña</span>
    </div>
@endsection

@section('scripts')
    <script>
    </script>
@endsection