@extends('layouts.app')

@section('content')
    <form action="{{ route('mis-datos.contrasena') }}" method="post" id="contrasena-form" accept-charset="UTF-8">
        @csrf
        <div class="container-full">
            <div class="row">
                <div class="col s12 m8">
                    <h1 class="title uppercase font-gilroy">{{ $usuario->nombre }}</h1>
                    <div class="breadcrumbs full-width">
                        <a href="{{ route('dashboard') }}" class="breadcrumb">Dashboard</a>
                        <a href="{{ route('mis-datos') }}" class="breadcrumb">Mis Datos</a>
                        <a class="breadcrumb">Contraseña</a>
                    </div>
                </div>
            </div>
            <div class="row mb-0">
                <div class="col s12">
                    <div class="card highlighted">
                        <div class="card-content">
                            <div class="row mb-2">
                                <div class="col s12 mb-1">
                                    <blockquote class="my-0" style="line-height: 25px; height: 25px;">
                                        <h2 class="title subtitle-1 font-gilroy uppercase mb-0"><b>CAMBIAR CONTRASEÑA DE ACCESO</b></h2>
                                    </blockquote>
                                </div>
                            </div>
                            <div class="row mb-0">
                                <div class="col s12 m4 mb-2-s">
                                    <label class="mdc-text-field mdc-text-field--outlined mdc-text-field--dense focusable" id="mdc-password_old">
                                        <span class="mdc-notched-outline">
                                            <span class="mdc-notched-outline__leading"></span>
                                            <span class="mdc-notched-outline__notch">
                                                <span class="mdc-floating-label" id="lbl_password_old">Contraseña Actual</span>
                                            </span>
                                            <span class="mdc-notched-outline__trailing"></span>
                                        </span>
                                        <input type="password" autocomplete="off" class="mdc-text-field__input" aria-labelledby="lbl_password_old" id="password_old" name="password_old" maxlength="16" minlength="8" required>
                                    </label>
                                    <div class="mdc-text-field-helper-line">
                                        <div class="mdc-text-field-helper-text mdc-text-field-helper-text--validation-msg nowrap" id="mdc-helper-password_old" aria-hidden="true"></div>
                                        <div class="mdc-text-field-character-counter">0 / 16</div>
                                    </div>
                                </div>
                                <div class="col s12 m4 mb-2-s">
                                    <label class="mdc-text-field mdc-text-field--outlined mdc-text-field--dense focusable" id="mdc-password_new">
                                        <span class="mdc-notched-outline">
                                            <span class="mdc-notched-outline__leading"></span>
                                            <span class="mdc-notched-outline__notch">
                                                <span class="mdc-floating-label" id="lbl_password_new">Nueva Contraseña</span>
                                            </span>
                                            <span class="mdc-notched-outline__trailing"></span>
                                        </span>
                                        <input type="password" autocomplete="off" class="mdc-text-field__input" aria-labelledby="lbl_password_new" id="password_new" name="password_new" maxlength="16" minlength="8" required>
                                    </label>
                                    <div class="mdc-text-field-helper-line">
                                        <div class="mdc-text-field-helper-text mdc-text-field-helper-text--validation-msg nowrap" id="mdc-helper-password_new" aria-hidden="true"></div>
                                        <div class="mdc-text-field-character-counter">0 / 16</div>
                                    </div>
                                </div>
                                <div class="col s12 m4">
                                    <label class="mdc-text-field mdc-text-field--outlined mdc-text-field--dense focusable" id="mdc-password">
                                        <span class="mdc-notched-outline">
                                            <span class="mdc-notched-outline__leading"></span>
                                            <span class="mdc-notched-outline__notch">
                                                <span class="mdc-floating-label" id="lbl_password">Confirmar Contraseña</span>
                                            </span>
                                            <span class="mdc-notched-outline__trailing"></span>
                                        </span>
                                        <input type="password" autocomplete="off" class="mdc-text-field__input" aria-labelledby="lbl_password" id="password" name="password" maxlength="16" minlength="8" required>
                                    </label>
                                    <div class="mdc-text-field-helper-line">
                                        <div class="mdc-text-field-helper-text mdc-text-field-helper-text--validation-msg nowrap" id="mdc-helper-password" aria-hidden="true"></div>
                                        <div class="mdc-text-field-character-counter">0 / 16</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mb-0 mt-2">
                <div class="col s12">
                    <a class="mdc-button mdc-button--outlined mdc-button--large" href="{{ route('usuarios') }}">
                        <span class="mdc-button__label mr-1">Volver</span>
                        <i class="fas fa-reply"></i>
                    </a>
                    <button class="mdc-button mdc-button--raised mdc-button--large btn-guardar" id="" type="submit">
                        <span class="mdc-button__label mr-1">Actualizar</span>
                        <i class="fas fa-lock"></i>
                    </button>
                </div>
            </div>
        </div>
    </form>
    <div class="cargando noselect px-5 center" id="guardando" style="display: none">
        <div id="html-spinner"></div>
        <span class="title mt-1">Actualizando Contraseña</span>
    </div>
@endsection

@section('scripts')
    <script>
        $('#{{ $usuario->id == Auth::id() ? 'mis-datos' : 'usuarios' }}').addClass('mdc-list-item--active');
        
        const password_old = new mdc.textField.MDCTextField(document.querySelector('#mdc-password_old'));
        const password_new = new mdc.textField.MDCTextField(document.querySelector('#mdc-password_new'));
        const password = new mdc.textField.MDCTextField(document.querySelector('#mdc-password'));

        // Valida el formulario antes de enviarlo
        const validar = async function() {
            let errors = 0;
            let regex = new RegExp("^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9]).{8,}$");

            // Validación del campo contraseña actual
            if (!password_old.valid || password_old.value == null || password_old.value == '') {
                password_old.valid = false;
                password_old.helperTextContent = 'Ingrese la contraseña actual.';
                M.toast({html: '<span class="mr-3">Error en la contraseña actual.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            }

            // Validación del campo de nueva contraseña
            if (password_new.value == null || password_new.value == '') {
                password_new.valid = false;
                password_new.helperTextContent = 'Ingrese una Contraseña.';
                M.toast({html: '<span class="mr-3">Ingrese la nueva contraseña.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            } else if (password_new.value.length < 8) {
                password_new.valid = false;
                password_new.helperTextContent = 'Mínimo 8 caracteres.';
                M.toast({html: '<span class="mr-3">La contraseña ingresada es muy corta.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            } else if (password_new.value.length > 16) {
                password_new.valid = false;
                password_new.helperTextContent = 'Máximo 16 caracteres.';
                M.toast({html: '<span class="mr-3">La contraseña ingresada es muy larga.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            } else if (!regex.test(password_new.value)) {
                password_new.valid = false;
                password_new.helperTextContent = 'Debe tener un número y una mayúscula.';
                M.toast({html: '<span class="mr-3">La contraseña debe tener un número y una mayúscula.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            } else if (!password_new.valid) {
                password_new.valid = false;
                password_new.helperTextContent = 'Ingrese una contraseña.';
                M.toast({html: '<span class="mr-3">Error en la nueva contraseña.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            }

            // Validación del campo contraseña actual vs nueva contraseña
            if (password_old.value && password_new.value && (password_old.value == password_new.value || password_old.value == password.value)) {
                password_new.valid = false;
                password_new.helperTextContent = 'Debe ser diferente.';
                if (password.value) {
                    password.value = '';
                }
                M.toast({html: '<span class="mr-3">La nueva contraseña debe ser diferente.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            }

            // Validación del campo de confirmación de contraseña
            if (password.value != password_new.value) {
                password.valid = false;
                password.helperTextContent = 'La contraseña no coincide.';
                M.toast({html: '<span class="mr-3">Las contraseñas no coinciden.</span><a class="btn btn-flat white-text px-0" onclick="M.Toast.getInstance(this.parentElement).dismiss();"><i class="fas fa-times"></i></a>', classes: 'red darken-2 white-text'});
                errors++;
            }

            if (errors)
                return false;
            
            return true;
        }

        // Ejecuta la función de validación antes de enviar el formulario
        $('.btn-guardar').on('click', async function(e) {
            $('#guardando').show();
            $('body').css('overflow', 'hidden');
            $(this).attr('disabled', 'disabled');
            e.preventDefault();
            let validacion = await validar();
            if (validacion) {
                $('#contrasena-form').submit();
            } else {
                $('#guardando').hide();
                $('body').css('overflow', '');
                $(this).removeAttr('disabled');
            }
        });
    </script>
@endsection