<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" style="display: flex;">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Avicampo') }}</title>
    <link rel="icon" href="{{ asset('imagenes/favicon.svg') }}" sizes="32x32" />
    <link rel="icon" href="{{ asset('imagenes/favicon.svg') }}" sizes="192x192" />
    <link rel="apple-touch-icon" href="{{ asset('imagenes/favicon.svg') }}" />

    <!-- Fonts -->
    <link rel="stylesheet" href="{{ asset('vendor/fontawesome/css/all.min.css') }}">

    <!-- Styles -->
    <link rel="stylesheet" href="{{ asset('vendor/materialize/css/materialize.css') }}">
    <link rel="stylesheet" href="{{ asset('vendor/material.io/material-components-web.min.css') }}">
    <link href="{{ asset('css/styles.css') }}" rel="stylesheet">
    <link href="{{ asset('css/login.css') }}" rel="stylesheet">
</head>
<body style="display: flex;">
    <div id="login" class="container-full">
        <div class="row full-height mb-0">
            <div id="background-login" class="col s12 l8 xl9 full-height px-0 hide-on-med-and-down" style="background-color: black">
                <div id="slider-login" class="full-height">
                    <img src="{{ asset('imagenes/login/login.jpg') }}" alt="Pollo Asado">
                </div>
            </div>
            <div class="col s12 l4 xl3 full-height valign-wrapper">
                <form method="POST" action="{{ route('login') }}" class="full-width px-4" id="login-form">
                    @csrf
                    <input type="hidden" name="ip" id="ip" class="hide" value="{{ Session::get('ip') }}">
                    <div class="row my-2">
                        <div class="col s12 mb-2 center">
                            <img src="{{ asset('imagenes/logos/avicampo-logo.png') }}" alt="Avicampo Logo" class="card-logo">
                            <h3 class="subtitle mb-2" style="font-family: 'Gilroy';">Sistema de Documentos Internos</h3>
                        </div>
                        <div class="col s12 mb-1">
                            <label class="mdc-text-field mdc-text-field--outlined @error('documento') mdc-text-field--invalid @enderror">
                                <input type="text" class="mdc-text-field__input" aria-labelledby="lbl_documento" name="documento" id="documento" required @isset($inputs['documento']) value="{{ $inputs['documento'] }}" @endisset>
                                <span class="mdc-notched-outline">
                                    <span class="mdc-notched-outline__leading"></span>
                                    <span class="mdc-notched-outline__notch">
                                        <span class="mdc-floating-label" id="lbl_documento">Usuario</span>
                                    </span>
                                    <span class="mdc-notched-outline__trailing"></span>
                                </span>
                            </label>
                            <div class="mdc-text-field-helper-line">
                                <div class="mdc-text-field-helper-text mdc-text-field-helper-text--validation-msg" id="my-helper-id" aria-hidden="true">
                                    @error('documento')
                                        El usuario no se encuentra registrado
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="col s12 mb-1">
                            <label class="mdc-text-field mdc-text-field--outlined @error('password') mdc-text-field--invalid @enderror">
                                <input type="password" class="mdc-text-field__input" aria-labelledby="lbl_password" name="password" id="password" required>
                                <span class="mdc-notched-outline">
                                    <span class="mdc-notched-outline__leading"></span>
                                    <span class="mdc-notched-outline__notch">
                                        <span class="mdc-floating-label" id="lbl_password">Contraseña</span>
                                    </span>
                                    <span class="mdc-notched-outline__trailing"></span>
                                </span>
                            </label>
                            <div class="mdc-text-field-helper-line">
                                <div class="mdc-text-field-helper-text mdc-text-field-helper-text--validation-msg" id="my-helper-id" aria-hidden="true">
                                    @error('password')
                                        La contraseña es errónea
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="col s12 mb-2">
                            <div class="mdc-touch-target-wrapper">
                                <div class="mdc-checkbox mdc-checkbox--touch">
                                    <input type="checkbox" class="mdc-checkbox__native-control" id="remember" name="remember"/>
                                    <div class="mdc-checkbox__background">
                                        <svg class="mdc-checkbox__checkmark" viewBox="0 0 24 24">
                                            <path class="mdc-checkbox__checkmark-path" fill="none" d="M1.73,12.91 8.1,19.28 22.79,4.59"/>
                                        </svg>
                                        <div class="mdc-checkbox__mixedmark"></div>
                                    </div>
                                    <div class="mdc-checkbox__ripple"></div>
                                </div>
                                <label for="remember" class="noselect nowrap">Mantener la sesión iniciada</label>
                            </div>
                        </div>
                        <div class="col s12 center-align">
                            <button class="mdc-button mdc-button--raised mdc-button--large" id="submit">
                                <span class="mdc-button__label mr-1">Iniciar Sesión</span>
                                <i class="fas fa-sign-in-alt send"></i>
                                <i class="fas fa-spinner sending" style="display: none"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
          </div>
        </div>
    </div>
    <!-- Scripts -->
    <script src="{{ asset('vendor/jquery/jquery-3.5.1.min.js') }}"></script>
    <script src="{{ asset('js/ip.js') }}"></script>
    <script src="{{ asset('vendor/materialize/js/materialize.min.js') }}"></script>
    <script src="{{ asset('vendor/material.io/material-components-web.min.js') }}"></script>
    <script type="text/javascript">
        const textFields = [].map.call(document.querySelectorAll('.mdc-text-field'), function(el) {
            return new mdc.textField.MDCTextField(el);
        });
    </script>
    <script type="text/javascript">
        $(document).ready(async function() {
            var imagenSlider = $('#slider-login img');
            if (imagenSlider.width() < $('#slider-login').width()) {
                imagenSlider.attr('width', '100%');
                imagenSlider.attr('height', 'auto');
            }

            $('#login-form').submit(function(){
                $('#submit').attr('disabled', 'disabled');
                $('#submit .send').hide();
                $('#submit .sending').show();
            });

            // Consulta la ip en cloudfare
            @if (!Session::has('ip'))
                let ipCliente = await getIp();
                $('#ip').val(ipCliente);
            @endif
        });
    </script>
</body>
</html>