/*
 Highstock JS v8.2.2 (2020-10-22)

 Highstock as a plugin for Highcharts

 (c) 2010-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(I){b(I);b.Highcharts=I;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function I(b,x,D,u){b.hasOwnProperty(x)||(b[x]=u.apply(null,D))}b=b?b._modules:{};I(b,"Core/Axis/NavigatorAxis.js",[b["Core/Globals.js"],b["Core/Utilities.js"]],function(b,x){var D=b.isTouchDevice,u=x.addEvent,t=x.correctFloat,
y=x.defined,a=x.isNumber,f=x.pick,J=function(){function b(a){this.axis=a}b.prototype.destroy=function(){this.axis=void 0};b.prototype.toFixedRange=function(b,v,A,q){var E=this.axis,l=E.chart;l=l&&l.fixedRange;var m=(E.pointRange||0)/2;b=f(A,E.translate(b,!0,!E.horiz));v=f(q,E.translate(v,!0,!E.horiz));E=l&&(v-b)/l;y(A)||(b=t(b+m));y(q)||(v=t(v-m));.7<E&&1.3>E&&(q?b=v-l:v=b+l);a(b)&&a(v)||(b=v=void 0);return{min:b,max:v}};return b}();return function(){function a(){}a.compose=function(a){a.keepProps.push("navigatorAxis");
u(a,"init",function(){this.navigatorAxis||(this.navigatorAxis=new J(this))});u(a,"zoom",function(a){var f=this.chart.options,q=f.navigator,E=this.navigatorAxis,l=f.chart.pinchType,m=f.rangeSelector;f=f.chart.zoomType;this.isXAxis&&(q&&q.enabled||m&&m.enabled)&&("y"===f?a.zoomed=!1:(!D&&"xy"===f||D&&"xy"===l)&&this.options.range&&(q=E.previousZoom,y(a.newMin)?E.previousZoom=[this.min,this.max]:q&&(a.newMin=q[0],a.newMax=q[1],E.previousZoom=void 0)));"undefined"!==typeof a.zoomed&&a.preventDefault()})};
a.AdditionsClass=J;return a}()});I(b,"Core/Axis/ScrollbarAxis.js",[b["Core/Globals.js"],b["Core/Utilities.js"]],function(b,x){var D=x.addEvent,u=x.defined,t=x.pick;return function(){function y(){}y.compose=function(a,f){D(a,"afterInit",function(){var a=this;a.options&&a.options.scrollbar&&a.options.scrollbar.enabled&&(a.options.scrollbar.vertical=!a.horiz,a.options.startOnTick=a.options.endOnTick=!1,a.scrollbar=new f(a.chart.renderer,a.options.scrollbar,a.chart),D(a.scrollbar,"changed",function(f){var y=
t(a.options&&a.options.min,a.min),v=t(a.options&&a.options.max,a.max),A=u(a.dataMin)?Math.min(y,a.min,a.dataMin):y,q=(u(a.dataMax)?Math.max(v,a.max,a.dataMax):v)-A;u(y)&&u(v)&&(a.horiz&&!a.reversed||!a.horiz&&a.reversed?(y=A+q*this.to,A+=q*this.from):(y=A+q*(1-this.from),A+=q*(1-this.to)),t(this.options.liveRedraw,b.svg&&!b.isTouchDevice&&!this.chart.isBoosting)||"mouseup"===f.DOMType||!u(f.DOMType)?a.setExtremes(A,y,!0,"mousemove"!==f.DOMType,f):this.setRange(this.from,this.to))}))});D(a,"afterRender",
function(){var a=Math.min(t(this.options.min,this.min),this.min,t(this.dataMin,this.min)),f=Math.max(t(this.options.max,this.max),this.max,t(this.dataMax,this.max)),b=this.scrollbar,v=this.axisTitleMargin+(this.titleOffset||0),A=this.chart.scrollbarsOffsets,q=this.options.margin||0;b&&(this.horiz?(this.opposite||(A[1]+=v),b.position(this.left,this.top+this.height+2+A[1]-(this.opposite?q:0),this.width,this.height),this.opposite||(A[1]+=q),v=1):(this.opposite&&(A[0]+=v),b.position(this.left+this.width+
2+A[0]-(this.opposite?0:q),this.top,this.width,this.height),this.opposite&&(A[0]+=q),v=0),A[v]+=b.size+b.options.margin,isNaN(a)||isNaN(f)||!u(this.min)||!u(this.max)||this.min===this.max?b.setRange(0,1):(A=(this.min-a)/(f-a),a=(this.max-a)/(f-a),this.horiz&&!this.reversed||!this.horiz&&this.reversed?b.setRange(A,a):b.setRange(1-a,1-A)))});D(a,"afterGetOffset",function(){var a=this.horiz?2:1,f=this.scrollbar;f&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[a]+=f.size+f.options.margin)})};
return y}()});I(b,"Core/Scrollbar.js",[b["Core/Axis/Axis.js"],b["Core/Globals.js"],b["Core/Axis/ScrollbarAxis.js"],b["Core/Utilities.js"],b["Core/Options.js"]],function(b,x,D,u,t){var y=u.addEvent,a=u.correctFloat,f=u.defined,J=u.destroyObjectProperties,B=u.fireEvent,H=u.merge,v=u.pick,A=u.removeEvent;u=t.defaultOptions;var q=x.hasTouch,E=x.isTouchDevice,l=x.swapXY=function(a,C){C&&a.forEach(function(d){for(var h=d.length,a,C=0;C<h;C+=2)a=d[C+1],"number"===typeof a&&(d[C+1]=d[C+2],d[C+2]=a)});return a};
t=function(){function m(a,d,h){this._events=[];this.from=this.chartY=this.chartX=0;this.scrollbar=this.group=void 0;this.scrollbarButtons=[];this.scrollbarGroup=void 0;this.scrollbarLeft=0;this.scrollbarRifles=void 0;this.scrollbarStrokeWidth=1;this.to=this.size=this.scrollbarTop=0;this.track=void 0;this.trackBorderWidth=1;this.userOptions={};this.y=this.x=0;this.chart=h;this.options=d;this.renderer=h.renderer;this.init(a,d,h)}m.prototype.addEvents=function(){var a=this.options.inverted?[1,0]:[0,
1],d=this.scrollbarButtons,h=this.scrollbarGroup.element,l=this.track.element,m=this.mouseDownHandler.bind(this),k=this.mouseMoveHandler.bind(this),g=this.mouseUpHandler.bind(this);a=[[d[a[0]].element,"click",this.buttonToMinClick.bind(this)],[d[a[1]].element,"click",this.buttonToMaxClick.bind(this)],[l,"click",this.trackClick.bind(this)],[h,"mousedown",m],[h.ownerDocument,"mousemove",k],[h.ownerDocument,"mouseup",g]];q&&a.push([h,"touchstart",m],[h.ownerDocument,"touchmove",k],[h.ownerDocument,"touchend",
g]);a.forEach(function(e){y.apply(null,e)});this._events=a};m.prototype.buttonToMaxClick=function(a){var d=(this.to-this.from)*v(this.options.step,.2);this.updatePosition(this.from+d,this.to+d);B(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};m.prototype.buttonToMinClick=function(C){var d=a(this.to-this.from)*v(this.options.step,.2);this.updatePosition(a(this.from-d),a(this.to-d));B(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:C})};m.prototype.cursorToScrollbarPosition=
function(a){var d=this.options;d=d.minWidth>this.calculatedWidth?d.minWidth:0;return{chartX:(a.chartX-this.x-this.xOffset)/(this.barWidth-d),chartY:(a.chartY-this.y-this.yOffset)/(this.barWidth-d)}};m.prototype.destroy=function(){var a=this.chart.scroller;this.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(d){this[d]&&this[d].destroy&&(this[d]=this[d].destroy())},this);a&&this===a.scrollbar&&(a.scrollbar=null,J(a.scrollbarButtons))};m.prototype.drawScrollbarButton=
function(a){var d=this.renderer,h=this.scrollbarButtons,C=this.options,m=this.size;var k=d.g().add(this.group);h.push(k);k=d.rect().addClass("highcharts-scrollbar-button").add(k);this.chart.styledMode||k.attr({stroke:C.buttonBorderColor,"stroke-width":C.buttonBorderWidth,fill:C.buttonBackgroundColor});k.attr(k.crisp({x:-.5,y:-.5,width:m+1,height:m+1,r:C.buttonBorderRadius},k.strokeWidth()));k=d.path(l([["M",m/2+(a?-1:1),m/2-3],["L",m/2+(a?-1:1),m/2+3],["L",m/2+(a?2:-2),m/2]],C.vertical)).addClass("highcharts-scrollbar-arrow").add(h[a]);
this.chart.styledMode||k.attr({fill:C.buttonArrowColor})};m.prototype.init=function(a,d,h){this.scrollbarButtons=[];this.renderer=a;this.userOptions=d;this.options=H(m.defaultOptions,d);this.chart=h;this.size=v(this.options.size,this.options.height);d.enabled&&(this.render(),this.addEvents())};m.prototype.mouseDownHandler=function(a){a=this.chart.pointer.normalize(a);a=this.cursorToScrollbarPosition(a);this.chartX=a.chartX;this.chartY=a.chartY;this.initPositions=[this.from,this.to];this.grabbedCenter=
!0};m.prototype.mouseMoveHandler=function(a){var d=this.chart.pointer.normalize(a),h=this.options.vertical?"chartY":"chartX",l=this.initPositions||[];!this.grabbedCenter||a.touches&&0===a.touches[0][h]||(d=this.cursorToScrollbarPosition(d)[h],h=this[h],h=d-h,this.hasDragged=!0,this.updatePosition(l[0]+h,l[1]+h),this.hasDragged&&B(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a}))};m.prototype.mouseUpHandler=function(a){this.hasDragged&&B(this,"changed",{from:this.from,
to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a});this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null};m.prototype.position=function(a,d,h,l){var m=this.options.vertical,k=0,g=this.rendered?"animate":"attr";this.x=a;this.y=d+this.trackBorderWidth;this.width=h;this.xOffset=this.height=l;this.yOffset=k;m?(this.width=this.yOffset=h=k=this.size,this.xOffset=d=0,this.barWidth=l-2*h,this.x=a+=this.options.margin):(this.height=this.xOffset=l=d=this.size,this.barWidth=h-2*l,this.y+=this.options.margin);
this.group[g]({translateX:a,translateY:this.y});this.track[g]({width:h,height:l});this.scrollbarButtons[1][g]({translateX:m?0:h-d,translateY:m?l-k:0})};m.prototype.removeEvents=function(){this._events.forEach(function(a){A.apply(null,a)});this._events.length=0};m.prototype.render=function(){var a=this.renderer,d=this.options,h=this.size,m=this.chart.styledMode,f;this.group=f=a.g("scrollbar").attr({zIndex:d.zIndex,translateY:-99999}).add();this.track=a.rect().addClass("highcharts-scrollbar-track").attr({x:0,
r:d.trackBorderRadius||0,height:h,width:h}).add(f);m||this.track.attr({fill:d.trackBackgroundColor,stroke:d.trackBorderColor,"stroke-width":d.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=a.g().add(f);this.scrollbar=a.rect().addClass("highcharts-scrollbar-thumb").attr({height:h,width:h,r:d.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=a.path(l([["M",-3,h/4],["L",-3,2*h/3],["M",0,h/4],["L",
0,2*h/3],["M",3,h/4],["L",3,2*h/3]],d.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);m||(this.scrollbar.attr({fill:d.barBackgroundColor,stroke:d.barBorderColor,"stroke-width":d.barBorderWidth}),this.scrollbarRifles.attr({stroke:d.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)};m.prototype.setRange=
function(l,d){var h=this.options,m=h.vertical,C=h.minWidth,k=this.barWidth,g,e=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(f(k)){l=Math.max(l,0);var p=Math.ceil(k*l);this.calculatedWidth=g=a(k*Math.min(d,1)-p);g<C&&(p=(k-C+g)*l,g=C);C=Math.floor(p+this.xOffset+this.yOffset);k=g/2-.5;this.from=l;this.to=d;m?(this.scrollbarGroup[e]({translateY:C}),this.scrollbar[e]({height:g}),this.scrollbarRifles[e]({translateY:k}),this.scrollbarTop=C,
this.scrollbarLeft=0):(this.scrollbarGroup[e]({translateX:C}),this.scrollbar[e]({width:g}),this.scrollbarRifles[e]({translateX:k}),this.scrollbarLeft=C,this.scrollbarTop=0);12>=g?this.scrollbarRifles.hide():this.scrollbarRifles.show(!0);!1===h.showFull&&(0>=l&&1<=d?this.group.hide():this.group.show());this.rendered=!0}};m.prototype.trackClick=function(a){var d=this.chart.pointer.normalize(a),h=this.to-this.from,l=this.y+this.scrollbarTop,m=this.x+this.scrollbarLeft;this.options.vertical&&d.chartY>
l||!this.options.vertical&&d.chartX>m?this.updatePosition(this.from+h,this.to+h):this.updatePosition(this.from-h,this.to-h);B(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};m.prototype.update=function(a){this.destroy();this.init(this.chart.renderer,H(!0,this.options,a),this.chart)};m.prototype.updatePosition=function(l,d){1<d&&(l=a(1-a(d-l)),d=1);0>l&&(d=a(d-l),l=0);this.from=l;this.to=d};m.defaultOptions={height:E?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,
margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:1,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"#333333",trackBackgroundColor:"#f2f2f2",trackBorderColor:"#f2f2f2",trackBorderWidth:1};return m}();x.Scrollbar||(u.scrollbar=H(!0,t.defaultOptions,u.scrollbar),x.Scrollbar=t,D.compose(b,t));return x.Scrollbar});I(b,"Core/Navigator.js",[b["Core/Axis/Axis.js"],b["Core/Series/Series.js"],
b["Core/Chart/Chart.js"],b["Core/Color/Color.js"],b["Core/Globals.js"],b["Series/LineSeries.js"],b["Core/Axis/NavigatorAxis.js"],b["Core/Options.js"],b["Core/Scrollbar.js"],b["Core/Utilities.js"]],function(b,x,D,u,t,y,a,f,J,B){u=u.parse;var H=t.hasTouch,v=t.isTouchDevice,A=f.defaultOptions,q=B.addEvent,E=B.clamp,l=B.correctFloat,m=B.defined,C=B.destroyObjectProperties,d=B.erase,h=B.extend,K=B.find,F=B.isArray,k=B.isNumber,g=B.merge,e=B.pick,p=B.removeEvent,z=B.splat,w=function(e){for(var n=[],r=1;r<
arguments.length;r++)n[r-1]=arguments[r];n=[].filter.call(n,k);if(n.length)return Math[e].apply(0,n)};x="undefined"===typeof x.seriesTypes.areaspline?"line":"areaspline";h(A,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:u("#6685c2").setOpacity(.3).get(),outlineColor:"#cccccc",outlineWidth:1,series:{type:x,fillOpacity:.05,lineWidth:1,compare:null,
dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,smoothed:!0,units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",
tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#999999"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});t.Renderer.prototype.symbols["navigator-handle"]=function(e,n,r,a,w){e=(w&&w.width||0)/2;n=Math.round(e/3)+.5;w=w&&w.height||0;return[["M",-e-1,.5],
["L",e,.5],["L",e,w+.5],["L",-e-1,w+.5],["L",-e-1,.5],["M",-n,4],["L",-n,w-3],["M",n-1,4],["L",n-1,w-3]]};var c=function(){function c(n){this.zoomedMin=this.zoomedMax=this.yAxis=this.xAxis=this.top=this.size=this.shades=this.rendered=this.range=this.outlineHeight=this.outline=this.opposite=this.navigatorSize=this.navigatorSeries=this.navigatorOptions=this.navigatorGroup=this.navigatorEnabled=this.left=this.height=this.handles=this.chart=this.baseSeries=void 0;this.init(n)}c.prototype.drawHandle=function(n,
r,e,c){var w=this.navigatorOptions.handles.height;this.handles[r][c](e?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(n,10)+.5-w)}:{translateX:Math.round(this.left+parseInt(n,10)),translateY:Math.round(this.top+this.height/2-w/2-1)})};c.prototype.drawOutline=function(n,r,e,c){var w=this.navigatorOptions.maskInside,a=this.outline.strokeWidth(),d=a/2,g=a%2/2;a=this.outlineHeight;var p=this.scrollbarHeight||0,L=this.size,k=this.left-p,z=this.top;e?(k-=d,e=z+r+
g,r=z+n+g,g=[["M",k+a,z-p-g],["L",k+a,e],["L",k,e],["L",k,r],["L",k+a,r],["L",k+a,z+L+p]],w&&g.push(["M",k+a,e-d],["L",k+a,r+d])):(n+=k+p-g,r+=k+p-g,z+=d,g=[["M",k,z],["L",n,z],["L",n,z+a],["L",r,z+a],["L",r,z],["L",k+L+2*p,z]],w&&g.push(["M",n-d,z],["L",r+d,z]));this.outline[c]({d:g})};c.prototype.drawMasks=function(n,r,e,c){var a=this.left,w=this.top,g=this.height;if(e){var d=[a,a,a];var p=[w,w+n,w+r];var L=[g,g,g];var k=[n,r-n,this.size-r]}else d=[a,a+n,a+r],p=[w,w,w],L=[n,r-n,this.size-r],k=[g,
g,g];this.shades.forEach(function(n,r){n[c]({x:d[r],y:p[r],width:L[r],height:k[r]})})};c.prototype.renderElements=function(){var n=this,r=n.navigatorOptions,e=r.maskInside,c=n.chart,a=c.renderer,w,g={cursor:c.inverted?"ns-resize":"ew-resize"};n.navigatorGroup=w=a.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!e,e,!e].forEach(function(e,d){n.shades[d]=a.rect().addClass("highcharts-navigator-mask"+(1===d?"-inside":"-outside")).add(w);c.styledMode||n.shades[d].attr({fill:e?r.maskFill:"rgba(0,0,0,0)"}).css(1===
d&&g)});n.outline=a.path().addClass("highcharts-navigator-outline").add(w);c.styledMode||n.outline.attr({"stroke-width":r.outlineWidth,stroke:r.outlineColor});r.handles.enabled&&[0,1].forEach(function(e){r.handles.inverted=c.inverted;n.handles[e]=a.symbol(r.handles.symbols[e],-r.handles.width/2-1,0,r.handles.width,r.handles.height,r.handles);n.handles[e].attr({zIndex:7-e}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][e]).add(w);if(!c.styledMode){var d=r.handles;
n.handles[e].attr({fill:d.backgroundColor,stroke:d.borderColor,"stroke-width":d.lineWidth}).css(g)}})};c.prototype.update=function(n){(this.series||[]).forEach(function(n){n.baseSeries&&delete n.baseSeries.navigatorSeries});this.destroy();g(!0,this.chart.options.navigator,this.options,n);this.init(this.chart)};c.prototype.render=function(n,r,c,a){var w=this.chart,g=this.scrollbarHeight,d,p=this.xAxis,z=p.pointRange||0;var L=p.navigatorAxis.fake?w.xAxis[0]:p;var h=this.navigatorEnabled,G,N=this.rendered;
var f=w.inverted;var b=w.xAxis[0].minRange,C=w.xAxis[0].options.maxRange;if(!this.hasDragged||m(c)){n=l(n-z/2);r=l(r+z/2);if(!k(n)||!k(r))if(N)c=0,a=e(p.width,L.width);else return;this.left=e(p.left,w.plotLeft+g+(f?w.plotWidth:0));this.size=G=d=e(p.len,(f?w.plotHeight:w.plotWidth)-2*g);w=f?g:d+2*g;c=e(c,p.toPixels(n,!0));a=e(a,p.toPixels(r,!0));k(c)&&Infinity!==Math.abs(c)||(c=0,a=w);n=p.toValue(c,!0);r=p.toValue(a,!0);var q=Math.abs(l(r-n));q<b?this.grabbedLeft?c=p.toPixels(r-b-z,!0):this.grabbedRight&&
(a=p.toPixels(n+b+z,!0)):m(C)&&l(q-z)>C&&(this.grabbedLeft?c=p.toPixels(r-C-z,!0):this.grabbedRight&&(a=p.toPixels(n+C+z,!0)));this.zoomedMax=E(Math.max(c,a),0,G);this.zoomedMin=E(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(c,a),0,G);this.range=this.zoomedMax-this.zoomedMin;G=Math.round(this.zoomedMax);c=Math.round(this.zoomedMin);h&&(this.navigatorGroup.attr({visibility:"visible"}),N=N&&!this.hasDragged?"animate":"attr",this.drawMasks(c,G,f,N),this.drawOutline(c,G,f,N),this.navigatorOptions.handles.enabled&&
(this.drawHandle(c,0,f,N),this.drawHandle(G,1,f,N)));this.scrollbar&&(f?(f=this.top-g,L=this.left-g+(h||!L.opposite?0:(L.titleOffset||0)+L.axisTitleMargin),g=d+2*g):(f=this.top+(h?this.height:-g),L=this.left-g),this.scrollbar.position(L,f,w,g),this.scrollbar.setRange(this.zoomedMin/(d||1),this.zoomedMax/(d||1)));this.rendered=!0}};c.prototype.addMouseEvents=function(){var n=this,r=n.chart,c=r.container,e=[],a,w;n.mouseMoveHandler=a=function(r){n.onMouseMove(r)};n.mouseUpHandler=w=function(r){n.onMouseUp(r)};
e=n.getPartsEvents("mousedown");e.push(q(r.renderTo,"mousemove",a),q(c.ownerDocument,"mouseup",w));H&&(e.push(q(r.renderTo,"touchmove",a),q(c.ownerDocument,"touchend",w)),e.concat(n.getPartsEvents("touchstart")));n.eventsToUnbind=e;n.series&&n.series[0]&&e.push(q(n.series[0].xAxis,"foundExtremes",function(){r.navigator.modifyNavigatorAxisExtremes()}))};c.prototype.getPartsEvents=function(n){var r=this,c=[];["shades","handles"].forEach(function(e){r[e].forEach(function(a,w){c.push(q(a.element,n,function(n){r[e+
"Mousedown"](n,w)}))})});return c};c.prototype.shadesMousedown=function(n,r){n=this.chart.pointer.normalize(n);var c=this.chart,e=this.xAxis,a=this.zoomedMin,w=this.left,g=this.size,d=this.range,p=n.chartX;c.inverted&&(p=n.chartY,w=this.top);if(1===r)this.grabbedCenter=p,this.fixedWidth=d,this.dragOffset=p-a;else{n=p-w-d/2;if(0===r)n=Math.max(0,n);else if(2===r&&n+d>=g)if(n=g-d,this.reversedExtremes){n-=d;var z=this.getUnionExtremes().dataMin}else var k=this.getUnionExtremes().dataMax;n!==a&&(this.fixedWidth=
d,r=e.navigatorAxis.toFixedRange(n,n+d,z,k),m(r.min)&&c.xAxis[0].setExtremes(Math.min(r.min,r.max),Math.max(r.min,r.max),!0,null,{trigger:"navigator"}))}};c.prototype.handlesMousedown=function(n,r){this.chart.pointer.normalize(n);n=this.chart;var c=n.xAxis[0],e=this.reversedExtremes;0===r?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=e?c.min:c.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=e?c.max:c.min);n.fixedRange=null};c.prototype.onMouseMove=
function(n){var r=this,c=r.chart,a=r.left,w=r.navigatorSize,g=r.range,d=r.dragOffset,p=c.inverted;n.touches&&0===n.touches[0].pageX||(n=c.pointer.normalize(n),c=n.chartX,p&&(a=r.top,c=n.chartY),r.grabbedLeft?(r.hasDragged=!0,r.render(0,0,c-a,r.otherHandlePos)):r.grabbedRight?(r.hasDragged=!0,r.render(0,0,r.otherHandlePos,c-a)):r.grabbedCenter&&(r.hasDragged=!0,c<d?c=d:c>w+d-g&&(c=w+d-g),r.render(0,0,c-d,c-d+g)),r.hasDragged&&r.scrollbar&&e(r.scrollbar.options.liveRedraw,t.svg&&!v&&!this.chart.isBoosting)&&
(n.DOMType=n.type,setTimeout(function(){r.onMouseUp(n)},0)))};c.prototype.onMouseUp=function(n){var c=this.chart,e=this.xAxis,a=this.scrollbar,w=n.DOMEvent||n,d=c.inverted,g=this.rendered&&!this.hasDragged?"animate":"attr";if(this.hasDragged&&(!a||!a.hasDragged)||"scrollbar"===n.trigger){a=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var p=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var z=this.fixedExtreme;this.zoomedMax===this.size&&(z=this.reversedExtremes?
a.dataMin:a.dataMax);0===this.zoomedMin&&(p=this.reversedExtremes?a.dataMax:a.dataMin);e=e.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,p,z);m(e.min)&&c.xAxis[0].setExtremes(Math.min(e.min,e.max),Math.max(e.min,e.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:w})}"mousemove"!==n.DOMType&&"touchmove"!==n.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=
null);this.navigatorEnabled&&k(this.zoomedMin)&&k(this.zoomedMax)&&(c=Math.round(this.zoomedMin),n=Math.round(this.zoomedMax),this.shades&&this.drawMasks(c,n,d,g),this.outline&&this.drawOutline(c,n,d,g),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(c,0,d,g),this.drawHandle(n,1,d,g)))};c.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(n){n()}),this.eventsToUnbind=void 0);this.removeBaseSeriesEvents()};
c.prototype.removeBaseSeriesEvents=function(){var n=this.baseSeries||[];this.navigatorEnabled&&n[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&n.forEach(function(n){p(n,"updatedData",this.updatedDataHandler)},this),n[0].xAxis&&p(n[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))};c.prototype.init=function(n){var c=n.options,d=c.navigator,p=d.enabled,z=c.scrollbar,k=z.enabled;c=p?d.height:0;var G=k?z.height:0;this.handles=[];this.shades=[];this.chart=n;this.setBaseSeries();this.height=
c;this.scrollbarHeight=G;this.scrollbarEnabled=k;this.navigatorEnabled=p;this.navigatorOptions=d;this.scrollbarOptions=z;this.outlineHeight=c+G;this.opposite=e(d.opposite,!(p||!n.inverted));var h=this;p=h.baseSeries;z=n.xAxis.length;k=n.yAxis.length;var l=p&&p[0]&&p[0].xAxis||n.xAxis[0]||{options:{}};n.isDirtyBox=!0;h.navigatorEnabled?(h.xAxis=new b(n,g({breaks:l.options.breaks,ordinal:l.options.ordinal},d.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:z,isInternal:!0,
offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},n.inverted?{offsets:[G,0,-G,0],width:c}:{offsets:[0,-G,0,G],height:c})),h.yAxis=new b(n,g(d.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:k,isInternal:!0,reversed:e(d.yAxis&&d.yAxis.reversed,n.yAxis[0]&&n.yAxis[0].reversed,!1),zoomEnabled:!1},n.inverted?{width:c}:{height:c})),p||d.series.data?h.updateNavigatorSeries(!1):0===n.series.length&&(h.unbindRedraw=q(n,"beforeRedraw",function(){0<
n.series.length&&!h.series&&(h.setBaseSeries(),h.unbindRedraw())})),h.reversedExtremes=n.inverted&&!h.xAxis.reversed||!n.inverted&&h.xAxis.reversed,h.renderElements(),h.addMouseEvents()):(h.xAxis={chart:n,navigatorAxis:{fake:!0},translate:function(c,e){var a=n.xAxis[0],d=a.getExtremes(),r=a.len-2*G,g=w("min",a.options.min,d.dataMin);a=w("max",a.options.max,d.dataMax)-g;return e?c*a/r+g:r*(c-g)/a},toPixels:function(n){return this.translate(n)},toValue:function(n){return this.translate(n,!0)}},h.xAxis.navigatorAxis.axis=
h.xAxis,h.xAxis.navigatorAxis.toFixedRange=a.AdditionsClass.prototype.toFixedRange.bind(h.xAxis.navigatorAxis));n.options.scrollbar.enabled&&(n.scrollbar=h.scrollbar=new J(n.renderer,g(n.options.scrollbar,{margin:h.navigatorEnabled?0:10,vertical:n.inverted}),n),q(h.scrollbar,"changed",function(c){var e=h.size,a=e*this.to;e*=this.from;h.hasDragged=h.scrollbar.hasDragged;h.render(0,0,e,a);(n.options.scrollbar.liveRedraw||"mousemove"!==c.DOMType&&"touchmove"!==c.DOMType)&&setTimeout(function(){h.onMouseUp(c)})}));
h.addBaseSeriesEvents();h.addChartEvents()};c.prototype.getUnionExtremes=function(n){var c=this.chart.xAxis[0],a=this.xAxis,d=a.options,g=c.options,p;n&&null===c.dataMin||(p={dataMin:e(d&&d.min,w("min",g.min,c.dataMin,a.dataMin,a.min)),dataMax:e(d&&d.max,w("max",g.max,c.dataMax,a.dataMax,a.max))});return p};c.prototype.setBaseSeries=function(n,c){var a=this.chart,e=this.baseSeries=[];n=n||a.options&&a.options.navigator.baseSeries||(a.series.length?K(a.series,function(n){return!n.options.isInternal}).index:
0);(a.series||[]).forEach(function(c,a){c.options.isInternal||!c.options.showInNavigator&&(a!==n&&c.options.id!==n||!1===c.options.showInNavigator)||e.push(c)});this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,c)};c.prototype.updateNavigatorSeries=function(c,a){var n=this,d=n.chart,w=n.baseSeries,r,k,G=n.navigatorOptions.series,l,m={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,
isInternal:!0,states:{inactive:{opacity:1}}},f=n.series=(n.series||[]).filter(function(c){var a=c.baseSeries;return 0>w.indexOf(a)?(a&&(p(a,"updatedData",n.updatedDataHandler),delete a.navigatorSeries),c.chart&&c.destroy(),!1):!0});w&&w.length&&w.forEach(function(c){var p=c.navigatorSeries,z=h({color:c.color,visible:c.visible},F(G)?A.navigator.series:G);p&&!1===n.navigatorOptions.adaptToUpdatedData||(m.name="Navigator "+w.length,r=c.options||{},l=r.navigatorOptions||{},k=g(r,m,z,l),k.pointRange=e(z.pointRange,
l.pointRange,A.plotOptions[k.type||"line"].pointRange),z=l.data||z.data,n.hasNavigatorData=n.hasNavigatorData||!!z,k.data=z||r.data&&r.data.slice(0),p&&p.options?p.update(k,a):(c.navigatorSeries=d.initSeries(k),c.navigatorSeries.baseSeries=c,f.push(c.navigatorSeries)))});if(G.data&&(!w||!w.length)||F(G))n.hasNavigatorData=!1,G=z(G),G.forEach(function(c,a){m.name="Navigator "+(f.length+1);k=g(A.navigator.series,{color:d.series[a]&&!d.series[a].options.isInternal&&d.series[a].color||d.options.colors[a]||
d.options.colors[0]},m,c);k.data=c.data;k.data&&(n.hasNavigatorData=!0,f.push(d.initSeries(k)))});c&&this.addBaseSeriesEvents()};c.prototype.addBaseSeriesEvents=function(){var c=this,a=c.baseSeries||[];a[0]&&a[0].xAxis&&q(a[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes);a.forEach(function(n){q(n,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)});q(n,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)});!1!==this.navigatorOptions.adaptToUpdatedData&&
n.xAxis&&q(n,"updatedData",this.updatedDataHandler);q(n,"remove",function(){this.navigatorSeries&&(d(c.series,this.navigatorSeries),m(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)})},this)};c.prototype.getBaseSeriesMin=function(c){return this.baseSeries.reduce(function(c,n){return Math.min(c,n.xData?n.xData[0]:c)},c)};c.prototype.modifyNavigatorAxisExtremes=function(){var c=this.xAxis,a;"undefined"!==typeof c.getExtremes&&(!(a=this.getUnionExtremes(!0))||
a.dataMin===c.min&&a.dataMax===c.max||(c.min=a.dataMin,c.max=a.dataMax))};c.prototype.modifyBaseAxisExtremes=function(){var c=this.chart.navigator,a=this.getExtremes(),d=a.dataMin,w=a.dataMax;a=a.max-a.min;var g=c.stickToMin,p=c.stickToMax,z=e(this.options.overscroll,0),h=c.series&&c.series[0],G=!!this.setExtremes;if(!this.eventArgs||"rangeSelectorButton"!==this.eventArgs.trigger){if(g){var l=d;var m=l+a}p&&(m=w+z,g||(l=Math.max(d,m-a,c.getBaseSeriesMin(h&&h.xData?h.xData[0]:-Number.MAX_VALUE))));
G&&(g||p)&&k(l)&&(this.min=this.userMin=l,this.max=this.userMax=m)}c.stickToMin=c.stickToMax=null};c.prototype.updatedDataHandler=function(){var c=this.chart.navigator,a=this.navigatorSeries,e=c.getBaseSeriesMin(this.xData[0]);c.stickToMax=c.reversedExtremes?0===Math.round(c.zoomedMin):Math.round(c.zoomedMax)>=Math.round(c.size);c.stickToMin=k(this.xAxis.min)&&this.xAxis.min<=e&&(!this.chart.fixedRange||!c.stickToMax);a&&!c.hasNavigatorData&&(a.options.pointStart=this.xData[0],a.setData(this.options.data,
!1,null,!1))};c.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(q(this.chart,"redraw",function(){var c=this.navigator,a=c&&(c.baseSeries&&c.baseSeries[0]&&c.baseSeries[0].xAxis||this.xAxis[0]);a&&c.render(a.min,a.max)}),q(this.chart,"getMargins",function(){var c=this.navigator,a=c.opposite?"plotTop":"marginBottom";this.inverted&&(a=c.opposite?"marginRight":"plotLeft");this[a]=(this[a]||0)+(c.navigatorEnabled||!this.inverted?c.outlineHeight:
0)+c.navigatorOptions.margin}))};c.prototype.destroy=function(){this.removeEvents();this.xAxis&&(d(this.chart.xAxis,this.xAxis),d(this.chart.axes,this.xAxis));this.yAxis&&(d(this.chart.yAxis,this.yAxis),d(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(c){c.destroy&&c.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(c){this[c]&&this[c].destroy&&this[c].destroy();this[c]=null},
this);[this.handles].forEach(function(c){C(c)},this)};return c}();t.Navigator||(t.Navigator=c,a.compose(b),q(D,"beforeShowResetZoom",function(){var c=this.options,a=c.navigator,e=c.rangeSelector;if((a&&a.enabled||e&&e.enabled)&&(!v&&"x"===c.chart.zoomType||v&&"x"===c.chart.pinchType))return!1}),q(D,"beforeRender",function(){var a=this.options;if(a.navigator.enabled||a.scrollbar.enabled)this.scroller=this.navigator=new c(this)}),q(D,"afterSetChartSize",function(){var c=this.legend,a=this.navigator;
if(a){var d=c&&c.options;var w=a.xAxis;var g=a.yAxis;var p=a.scrollbarHeight;this.inverted?(a.left=a.opposite?this.chartWidth-p-a.height:this.spacing[3]+p,a.top=this.plotTop+p):(a.left=this.plotLeft+p,a.top=a.navigatorOptions.top||this.chartHeight-a.height-p-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(d&&"bottom"===d.verticalAlign&&"proximate"!==d.layout&&d.enabled&&!d.floating?c.legendHeight+e(d.margin,10):0)-(this.titleOffset?this.titleOffset[2]:
0));w&&g&&(this.inverted?w.options.left=g.options.left=a.left:w.options.top=g.options.top=a.top,w.setAxisSize(),g.setAxisSize())}}),q(D,"update",function(c){var a=c.options.navigator||{},e=c.options.scrollbar||{};this.navigator||this.scroller||!a.enabled&&!e.enabled||(g(!0,this.options.navigator,a),g(!0,this.options.scrollbar,e),delete c.options.navigator,delete c.options.scrollbar)}),q(D,"afterUpdate",function(a){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||
(this.scroller=this.navigator=new c(this),e(a.redraw,!0)&&this.redraw(a.animation))}),q(D,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),q(y,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),D.prototype.callbacks.push(function(c){var a=c.navigator;a&&c.xAxis[0]&&(c=c.xAxis[0].getExtremes(),a.render(c.min,c.max))}));t.Navigator=c;return t.Navigator});I(b,"Core/Axis/OrdinalAxis.js",[b["Core/Axis/Axis.js"],
b["Core/Globals.js"],b["Core/Series/CartesianSeries.js"],b["Core/Utilities.js"],b["Core/Chart/Chart.js"]],function(b,x,D,u,t){var y=u.addEvent,a=u.css,f=u.defined,J=u.pick,B=u.timeUnits,H;(function(b){var A=function(){function a(a){this.index={};this.axis=a}a.prototype.beforeSetTickPositions=function(){var a=this.axis,l=a.ordinal,m=[],f,d=!1,h=a.getExtremes(),b=h.min,q=h.max,k,g=a.isXAxis&&!!a.options.breaks;h=a.options.ordinal;var e=Number.MAX_VALUE,p=a.chart.options.chart.ignoreHiddenSeries,z;if(h||
g){a.series.forEach(function(c,a){f=[];if(!(p&&!1===c.visible||!1===c.takeOrdinalPosition&&!g)&&(m=m.concat(c.processedXData),w=m.length,m.sort(function(c,a){return c-a}),e=Math.min(e,J(c.closestPointRange,e)),w)){for(a=0;a<w-1;)m[a]!==m[a+1]&&f.push(m[a+1]),a++;f[0]!==m[0]&&f.unshift(m[0]);m=f}c.isSeriesBoosting&&(z=!0)});z&&(m.length=0);var w=m.length;if(2<w){var c=m[1]-m[0];for(k=w-1;k--&&!d;)m[k+1]-m[k]!==c&&(d=!0);!a.options.keepOrdinalPadding&&(m[0]-b>c||q-m[m.length-1]>c)&&(d=!0)}else a.options.overscroll&&
(2===w?e=m[1]-m[0]:1===w?(e=a.options.overscroll,m=[m[0],m[0]+e]):e=l.overscrollPointsRange);d?(a.options.overscroll&&(l.overscrollPointsRange=e,m=m.concat(l.getOverscrollPositions())),l.positions=m,c=a.ordinal2lin(Math.max(b,m[0]),!0),k=Math.max(a.ordinal2lin(Math.min(q,m[m.length-1]),!0),1),l.slope=q=(q-b)/(k-c),l.offset=b-c*q):(l.overscrollPointsRange=J(a.closestPointRange,l.overscrollPointsRange),l.positions=a.ordinal.slope=l.offset=void 0)}a.isOrdinal=h&&d;l.groupIntervalFactor=null};a.prototype.getExtendedPositions=
function(){var a=this,l=a.axis,m=l.constructor.prototype,f=l.chart,d=l.series[0].currentDataGrouping,h=a.index,b=d?d.count+d.unitName:"raw",q=l.options.overscroll,k=l.getExtremes(),g;h||(h=a.index={});if(!h[b]){var e={series:[],chart:f,getExtremes:function(){return{min:k.dataMin,max:k.dataMax+q}},options:{ordinal:!0},ordinal:{},ordinal2lin:m.ordinal2lin,val2lin:m.val2lin};e.ordinal.axis=e;l.series.forEach(function(p){g={xAxis:e,xData:p.xData.slice(),chart:f,destroyGroupedData:x.noop,getProcessedData:D.prototype.getProcessedData};
g.xData=g.xData.concat(a.getOverscrollPositions());g.options={dataGrouping:d?{enabled:!0,forced:!0,approximation:"open",units:[[d.unitName,[d.count]]]}:{enabled:!1}};p.processData.apply(g);e.series.push(g)});l.ordinal.beforeSetTickPositions.apply({axis:e});h[b]=e.ordinal.positions}return h[b]};a.prototype.getGroupIntervalFactor=function(a,l,m){m=m.processedXData;var f=m.length,d=[];var h=this.groupIntervalFactor;if(!h){for(h=0;h<f-1;h++)d[h]=m[h+1]-m[h];d.sort(function(a,d){return a-d});d=d[Math.floor(f/
2)];a=Math.max(a,m[0]);l=Math.min(l,m[f-1]);this.groupIntervalFactor=h=f*d/(l-a)}return h};a.prototype.getOverscrollPositions=function(){var a=this.axis,l=a.options.overscroll,m=this.overscrollPointsRange,b=[],d=a.dataMax;if(f(m))for(b.push(d);d<=a.dataMax+l;)d+=m,b.push(d);return b};a.prototype.postProcessTickInterval=function(a){var l=this.axis,m=this.slope;return m?l.options.breaks?l.closestPointRange||a:a/(m/l.closestPointRange):a};return a}();b.Composition=A;b.compose=function(q,A,l){q.keepProps.push("ordinal");
var m=q.prototype;q.prototype.getTimeTicks=function(a,d,h,l,m,k,g){void 0===m&&(m=[]);void 0===k&&(k=0);var e=0,p,z,w={},c=[],G=-Number.MAX_VALUE,n=this.options.tickPixelInterval,r=this.chart.time,b=[];if(!this.options.ordinal&&!this.options.breaks||!m||3>m.length||"undefined"===typeof d)return r.getTimeTicks.apply(r,arguments);var q=m.length;for(p=0;p<q;p++){var C=p&&m[p-1]>h;m[p]<d&&(e=p);if(p===q-1||m[p+1]-m[p]>5*k||C){if(m[p]>G){for(z=r.getTimeTicks(a,m[e],m[p],l);z.length&&z[0]<=G;)z.shift();
z.length&&(G=z[z.length-1]);b.push(c.length);c=c.concat(z)}e=p+1}if(C)break}z=z.info;if(g&&z.unitRange<=B.hour){p=c.length-1;for(e=1;e<p;e++)if(r.dateFormat("%d",c[e])!==r.dateFormat("%d",c[e-1])){w[c[e]]="day";var A=!0}A&&(w[c[0]]="day");z.higherRanks=w}z.segmentStarts=b;c.info=z;if(g&&f(n)){e=b=c.length;A=[];var v;for(r=[];e--;)p=this.translate(c[e]),v&&(r[e]=v-p),A[e]=v=p;r.sort();r=r[Math.floor(r.length/2)];r<.6*n&&(r=null);e=c[b-1]>h?b-1:b;for(v=void 0;e--;)p=A[e],b=Math.abs(v-p),v&&b<.8*n&&
(null===r||b<.8*r)?(w[c[e]]&&!w[c[e+1]]?(b=e+1,v=p):b=e,c.splice(b,1)):v=p}return c};m.lin2val=function(a,d){var h=this.ordinal,l=h.positions;if(l){var m=h.slope,k=h.offset;h=l.length-1;if(d)if(0>a)a=l[0];else if(a>h)a=l[h];else{h=Math.floor(a);var g=a-h}else for(;h--;)if(d=m*h+k,a>=d){m=m*(h+1)+k;g=(a-d)/(m-d);break}return"undefined"!==typeof g&&"undefined"!==typeof l[h]?l[h]+(g?g*(l[h+1]-l[h]):0):a}return a};m.val2lin=function(a,d){var h=this.ordinal,l=h.positions;if(l){var m=l.length,k;for(k=m;k--;)if(l[k]===
a){var g=k;break}for(k=m-1;k--;)if(a>l[k]||0===k){a=(a-l[k])/(l[k+1]-l[k]);g=k+a;break}d=d?g:h.slope*(g||0)+h.offset}else d=a;return d};m.ordinal2lin=m.val2lin;y(q,"afterInit",function(){this.ordinal||(this.ordinal=new b.Composition(this))});y(q,"foundExtremes",function(){this.isXAxis&&f(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&
f(this.userMin)&&(this.min+=this.options.overscroll))});y(q,"afterSetScale",function(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)});y(q,"initialAxisTranslation",function(){this.ordinal&&(this.ordinal.beforeSetTickPositions(),this.tickInterval=this.ordinal.postProcessTickInterval(this.tickInterval))});y(A,"pan",function(l){var d=this.xAxis[0],h=d.options.overscroll,m=l.originalEvent.chartX,f=this.options.chart&&this.options.chart.panning,
k=!1;if(f&&"y"!==f.type&&d.options.ordinal&&d.series.length){var g=this.mouseDownX,e=d.getExtremes(),p=e.dataMax,z=e.min,w=e.max,c=this.hoverPoints,G=d.closestPointRange||d.ordinal&&d.ordinal.overscrollPointsRange;g=(g-m)/(d.translationSlope*(d.ordinal.slope||G));var n={ordinal:{positions:d.ordinal.getExtendedPositions()}};G=d.lin2val;var r=d.val2lin;if(!n.ordinal.positions)k=!0;else if(1<Math.abs(g)){c&&c.forEach(function(a){a.setState()});if(0>g){c=n;var b=d.ordinal.positions?d:n}else c=d.ordinal.positions?
d:n,b=n;n=b.ordinal.positions;p>n[n.length-1]&&n.push(p);this.fixedRange=w-z;g=d.navigatorAxis.toFixedRange(null,null,G.apply(c,[r.apply(c,[z,!0])+g,!0]),G.apply(b,[r.apply(b,[w,!0])+g,!0]));g.min>=Math.min(e.dataMin,z)&&g.max<=Math.max(p,w)+h&&d.setExtremes(g.min,g.max,!0,!1,{trigger:"pan"});this.mouseDownX=m;a(this.container,{cursor:"move"})}}else k=!0;k||f&&/y/.test(f.type)?h&&(d.max=d.dataMax+h):l.preventDefault()});y(l,"updatedData",function(){var a=this.xAxis;a&&a.options.ordinal&&delete a.ordinal.index})}})(H||
(H={}));H.compose(b,t,D);return H});I(b,"Core/Axis/BrokenAxis.js",[b["Core/Axis/Axis.js"],b["Series/LineSeries.js"],b["Extensions/Stacking.js"],b["Core/Utilities.js"]],function(b,x,D,u){var t=u.addEvent,y=u.find,a=u.fireEvent,f=u.isArray,J=u.isNumber,B=u.pick,H=function(){function v(a){this.hasBreaks=!1;this.axis=a}v.isInBreak=function(a,b){var f=a.repeat||Infinity,l=a.from,m=a.to-a.from;b=b>=l?(b-l)%f:f-(l-b)%f;return a.inclusive?b<=m:b<m&&0!==b};v.lin2Val=function(a){var b=this.brokenAxis;b=b&&
b.breakArray;if(!b)return a;var f;for(f=0;f<b.length;f++){var l=b[f];if(l.from>=a)break;else l.to<a?a+=l.len:v.isInBreak(l,a)&&(a+=l.len)}return a};v.val2Lin=function(a){var b=this.brokenAxis;b=b&&b.breakArray;if(!b)return a;var f=a,l;for(l=0;l<b.length;l++){var m=b[l];if(m.to<=a)f-=m.len;else if(m.from>=a)break;else if(v.isInBreak(m,a)){f-=a-m.from;break}}return f};v.prototype.findBreakAt=function(a,b){return y(b,function(b){return b.from<a&&a<b.to})};v.prototype.isInAnyBreak=function(a,b){var f=
this.axis,l=f.options.breaks,m=l&&l.length,q;if(m){for(;m--;)if(v.isInBreak(l[m],a)){var d=!0;q||(q=B(l[m].showPoints,!f.isXAxis))}var h=d&&b?d&&!q:d}return h};v.prototype.setBreaks=function(u,q){var t=this,l=t.axis,m=f(u)&&!!u.length;l.isDirty=t.hasBreaks!==m;t.hasBreaks=m;l.options.breaks=l.userOptions.breaks=u;l.forceRedraw=!0;l.series.forEach(function(a){a.isDirty=!0});m||l.val2lin!==v.val2Lin||(delete l.val2lin,delete l.lin2val);m&&(l.userOptions.ordinal=!1,l.lin2val=v.lin2Val,l.val2lin=v.val2Lin,
l.setExtremes=function(a,d,h,l,m){if(t.hasBreaks){for(var k,g=this.options.breaks;k=t.findBreakAt(a,g);)a=k.to;for(;k=t.findBreakAt(d,g);)d=k.from;d<a&&(d=a)}b.prototype.setExtremes.call(this,a,d,h,l,m)},l.setAxisTranslation=function(m){b.prototype.setAxisTranslation.call(this,m);t.unitLength=null;if(t.hasBreaks){m=l.options.breaks||[];var d=[],h=[],f=0,q,k=l.userMin||l.min,g=l.userMax||l.max,e=B(l.pointRangePadding,0),p;m.forEach(function(a){q=a.repeat||Infinity;v.isInBreak(a,k)&&(k+=a.to%q-k%q);
v.isInBreak(a,g)&&(g-=g%q-a.from%q)});m.forEach(function(a){w=a.from;for(q=a.repeat||Infinity;w-q>k;)w-=q;for(;w<k;)w+=q;for(p=w;p<g;p+=q)d.push({value:p,move:"in"}),d.push({value:p+(a.to-a.from),move:"out",size:a.breakSize})});d.sort(function(a,e){return a.value===e.value?("in"===a.move?0:1)-("in"===e.move?0:1):a.value-e.value});var z=0;var w=k;d.forEach(function(a){z+="in"===a.move?1:-1;1===z&&"in"===a.move&&(w=a.value);0===z&&(h.push({from:w,to:a.value,len:a.value-w-(a.size||0)}),f+=a.value-w-
(a.size||0))});l.breakArray=t.breakArray=h;t.unitLength=g-k-f+e;a(l,"afterBreaks");l.staticScale?l.transA=l.staticScale:t.unitLength&&(l.transA*=(g-l.min+e)/t.unitLength);e&&(l.minPixelPadding=l.transA*l.minPointOffset);l.min=k;l.max=g}});B(q,!0)&&l.chart.redraw()};return v}();u=function(){function b(){}b.compose=function(b,f){b.keepProps.push("brokenAxis");var q=x.prototype;q.drawBreaks=function(l,m){var b=this,d=b.points,h,f,q,k;if(l&&l.brokenAxis&&l.brokenAxis.hasBreaks){var g=l.brokenAxis;m.forEach(function(e){h=
g&&g.breakArray||[];f=l.isXAxis?l.min:B(b.options.threshold,l.min);d.forEach(function(d){k=B(d["stack"+e.toUpperCase()],d[e]);h.forEach(function(e){if(J(f)&&J(k)){q=!1;if(f<e.from&&k>e.to||f>e.from&&k<e.from)q="pointBreak";else if(f<e.from&&k>e.from&&k<e.to||f>e.from&&k>e.to&&k<e.from)q="pointInBreak";q&&a(l,q,{point:d,brk:e})}})})})}};q.gappedPath=function(){var a=this.currentDataGrouping,b=a&&a.gapSize;a=this.options.gapSize;var f=this.points.slice(),d=f.length-1,h=this.yAxis,q;if(a&&0<d)for("value"!==
this.options.gapUnit&&(a*=this.basePointRange),b&&b>a&&b>=this.basePointRange&&(a=b),q=void 0;d--;)q&&!1!==q.visible||(q=f[d+1]),b=f[d],!1!==q.visible&&!1!==b.visible&&(q.x-b.x>a&&(q=(b.x+q.x)/2,f.splice(d+1,0,{isNull:!0,x:q}),h.stacking&&this.options.stacking&&(q=h.stacking.stacks[this.stackKey][q]=new D(h,h.options.stackLabels,!1,q,this.stack),q.total=0)),q=b);return this.getGraphPath(f)};t(b,"init",function(){this.brokenAxis||(this.brokenAxis=new H(this))});t(b,"afterInit",function(){"undefined"!==
typeof this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)});t(b,"afterSetTickPositions",function(){var a=this.brokenAxis;if(a&&a.hasBreaks){var b=this.tickPositions,f=this.tickPositions.info,d=[],h;for(h=0;h<b.length;h++)a.isInAnyBreak(b[h])||d.push(b[h]);this.tickPositions=d;this.tickPositions.info=f}});t(b,"afterSetOptions",function(){this.brokenAxis&&this.brokenAxis.hasBreaks&&(this.options.ordinal=!1)});t(f,"afterGeneratePoints",function(){var a=this.options.connectNulls,b=this.points,
f=this.xAxis,d=this.yAxis;if(this.isDirty)for(var h=b.length;h--;){var q=b[h],v=!(null===q.y&&!1===a)&&(f&&f.brokenAxis&&f.brokenAxis.isInAnyBreak(q.x,!0)||d&&d.brokenAxis&&d.brokenAxis.isInAnyBreak(q.y,!0));q.visible=v?!1:!1!==q.options.visible}});t(f,"afterRender",function(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,B(this.pointArrayMap,["y"]))})};return b}();u.compose(b,x);return u});I(b,"masters/modules/broken-axis.src.js",[],function(){});I(b,"Extensions/DataGrouping.js",[b["Core/Axis/Axis.js"],
b["Core/Axis/DateTimeAxis.js"],b["Core/Globals.js"],b["Core/Options.js"],b["Core/Series/Point.js"],b["Core/Tooltip.js"],b["Core/Utilities.js"]],function(b,x,D,u,t,y,a){"";var f=a.addEvent,J=a.arrayMax,B=a.arrayMin,H=a.correctFloat,v=a.defined,A=a.error,q=a.extend,E=a.format,l=a.isNumber,m=a.merge,C=a.pick;a=D.Series;var d=D.approximations={sum:function(a){var c=a.length;if(!c&&a.hasNulls)var e=null;else if(c)for(e=0;c--;)e+=a[c];return e},average:function(a){var c=a.length;a=d.sum(a);l(a)&&c&&(a=
H(a/c));return a},averages:function(){var a=[];[].forEach.call(arguments,function(c){a.push(d.average(c))});return"undefined"===typeof a[0]?void 0:a},open:function(a){return a.length?a[0]:a.hasNulls?null:void 0},high:function(a){return a.length?J(a):a.hasNulls?null:void 0},low:function(a){return a.length?B(a):a.hasNulls?null:void 0},close:function(a){return a.length?a[a.length-1]:a.hasNulls?null:void 0},ohlc:function(a,c,e,g){a=d.open(a);c=d.high(c);e=d.low(e);g=d.close(g);if(l(a)||l(c)||l(e)||l(g))return[a,
c,e,g]},range:function(a,c){a=d.low(a);c=d.high(c);if(l(a)||l(c))return[a,c];if(null===a&&null===c)return null}},h=function(a,c,e,g){var p=this,n=p.data,w=p.options&&p.options.data,b=[],k=[],h=[],z=a.length,f=!!c,G=[],q=p.pointArrayMap,t=q&&q.length,u=["x"].concat(q||["y"]),y=0,A=0,B;g="function"===typeof g?g:d[g]?d[g]:d[p.getDGApproximation&&p.getDGApproximation()||"average"];t?q.forEach(function(){G.push([])}):G.push([]);var x=t||1;for(B=0;B<=z&&!(a[B]>=e[0]);B++);for(B;B<=z;B++){for(;"undefined"!==
typeof e[y+1]&&a[B]>=e[y+1]||B===z;){var F=e[y];p.dataGroupInfo={start:p.cropStart+A,length:G[0].length};var C=g.apply(p,G);p.pointClass&&!v(p.dataGroupInfo.options)&&(p.dataGroupInfo.options=m(p.pointClass.prototype.optionsToObject.call({series:p},p.options.data[p.cropStart+A])),u.forEach(function(a){delete p.dataGroupInfo.options[a]}));"undefined"!==typeof C&&(b.push(F),k.push(C),h.push(p.dataGroupInfo));A=B;for(F=0;F<x;F++)G[F].length=0,G[F].hasNulls=!1;y+=1;if(B===z)break}if(B===z)break;if(q)for(F=
p.cropStart+B,C=n&&n[F]||p.pointClass.prototype.applyOptions.apply({series:p},[w[F]]),F=0;F<t;F++){var E=C[q[F]];l(E)?G[F].push(E):null===E&&(G[F].hasNulls=!0)}else F=f?c[B]:null,l(F)?G[0].push(F):null===F&&(G[0].hasNulls=!0)}return{groupedXData:b,groupedYData:k,groupMap:h}},K={approximations:d,groupData:h},F=a.prototype,k=F.processData,g=F.generatePoints,e={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S",
"%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},p={line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5}},z=D.defaultDataGroupingUnits=
[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];F.getDGApproximation=function(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("column")?"sum":"average"};F.groupData=h;F.processData=function(){var a=this.chart,c=this.options.dataGrouping,e=!1!==this.allowDG&&c&&C(c.enabled,a.options.isStock),d=this.visible||!a.options.chart.ignoreHiddenSeries,
g,p=this.currentDataGrouping,b=!1;this.forceCrop=e;this.groupPixelWidth=null;this.hasProcessed=!0;e&&!this.requireSorting&&(this.requireSorting=b=!0);e=!1===k.apply(this,arguments)||!e;b&&(this.requireSorting=!1);if(!e){this.destroyGroupedData();e=c.groupAll?this.xData:this.processedXData;var h=c.groupAll?this.yData:this.processedYData,f=a.plotSizeX;a=this.xAxis;var l=a.options.ordinal,m=this.groupPixelWidth=a.getGroupPixelWidth&&a.getGroupPixelWidth();if(m){this.isDirty=g=!0;this.points=null;b=a.getExtremes();
var q=b.min;b=b.max;l=l&&a.ordinal&&a.ordinal.getGroupIntervalFactor(q,b,this)||1;m=m*(b-q)/f*l;f=a.getTimeTicks(x.AdditionsClass.prototype.normalizeTimeTickInterval(m,c.units||z),Math.min(q,e[0]),Math.max(b,e[e.length-1]),a.options.startOfWeek,e,this.closestPointRange);h=F.groupData.apply(this,[e,h,f,c.approximation]);e=h.groupedXData;l=h.groupedYData;var t=0;if(c.smoothed&&e.length){var u=e.length-1;for(e[u]=Math.min(e[u],b);u--&&0<u;)e[u]+=m/2;e[0]=Math.max(e[0],q)}for(u=1;u<f.length;u++)f.info.segmentStarts&&
-1!==f.info.segmentStarts.indexOf(u)||(t=Math.max(f[u]-f[u-1],t));q=f.info;q.gapSize=t;this.closestPointRange=f.info.totalRange;this.groupMap=h.groupMap;if(v(e[0])&&e[0]<a.min&&d){if(!v(a.options.min)&&a.min<=a.dataMin||a.min===a.dataMin)a.min=Math.min(e[0],a.min);a.dataMin=Math.min(e[0],a.dataMin)}c.groupAll&&(c=this.cropData(e,l,a.min,a.max,1),e=c.xData,l=c.yData);this.processedXData=e;this.processedYData=l}else this.groupMap=null;this.hasGroupedData=g;this.currentDataGrouping=q;this.preventGraphAnimation=
(p&&p.totalRange)!==(q&&q.totalRange)}};F.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(a,c){a&&(this.groupedData[c]=a.destroy?a.destroy():null)},this),this.groupedData.length=0)};F.generatePoints=function(){g.apply(this);this.destroyGroupedData();this.groupedData=this.hasGroupedData?this.points:null};f(t,"update",function(){if(this.dataGroup)return A(24,!1,this.series.chart),!1});f(y,"headerFormatter",function(a){var c=this.chart,d=c.time,g=a.labelConfig,p=g.series,
b=p.tooltipOptions,h=p.options.dataGrouping,k=b.xDateFormat,z=p.xAxis,w=b[(a.isFooter?"footer":"header")+"Format"];if(z&&"datetime"===z.options.type&&h&&l(g.key)){var f=p.currentDataGrouping;h=h.dateTimeLabelFormats||e.dateTimeLabelFormats;if(f)if(b=h[f.unitName],1===f.count)k=b[0];else{k=b[1];var m=b[2]}else!k&&h&&(k=this.getXDateFormat(g,b,z));k=d.dateFormat(k,g.key);m&&(k+=d.dateFormat(m,g.key+f.totalRange-1));p.chart.styledMode&&(w=this.styledModeFormat(w));a.text=E(w,{point:q(g.point,{key:k}),
series:p},c);a.preventDefault()}});f(a,"destroy",F.destroyGroupedData);f(a,"afterSetOptions",function(a){a=a.options;var c=this.type,d=this.chart.options.plotOptions,g=u.defaultOptions.plotOptions[c].dataGrouping,b=this.useCommonDataGrouping&&e;if(p[c]||b)g||(g=m(e,p[c])),a.dataGrouping=m(b,g,d.series&&d.series.dataGrouping,d[c].dataGrouping,this.userOptions.dataGrouping)});f(b,"afterSetScale",function(){this.series.forEach(function(a){a.hasProcessed=!1})});b.prototype.getGroupPixelWidth=function(){var a=
this.series,c=a.length,d,g=0,p=!1,b;for(d=c;d--;)(b=a[d].options.dataGrouping)&&(g=Math.max(g,C(b.groupPixelWidth,e.groupPixelWidth)));for(d=c;d--;)(b=a[d].options.dataGrouping)&&a[d].hasProcessed&&(c=(a[d].processedXData||a[d].data).length,a[d].groupPixelWidth||c>this.chart.plotSizeX/g||c&&b.forced)&&(p=!0);return p?g:0};b.prototype.setDataGrouping=function(a,c){var e;c=C(c,!0);a||(a={forced:!1,units:null});if(this instanceof b)for(e=this.series.length;e--;)this.series[e].update({dataGrouping:a},
!1);else this.chart.options.series.forEach(function(c){c.dataGrouping=a},!1);this.ordinal&&(this.ordinal.slope=void 0);c&&this.chart.redraw()};D.dataGrouping=K;"";return K});I(b,"Series/OHLCSeries.js",[b["Core/Series/Series.js"],b["Core/Series/Point.js"]],function(b,x){var D=b.seriesTypes;b.seriesType("ohlc","column",{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},
threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0},{directTouch:!1,pointArrayMap:["open","high","low","close"],toYData:function(b){return[b.open,b.high,b.low,b.close]},pointValKey:"close",pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},init:function(){D.column.prototype.init.apply(this,arguments);this.options.stacking=void 0},pointAttribs:function(b,t){t=D.column.prototype.pointAttribs.call(this,b,t);var u=this.options;delete t.fill;!b.options.color&&u.upColor&&b.open<b.close&&
(t.stroke=u.upColor);return t},translate:function(){var b=this,t=b.yAxis,y=!!b.modifyValue,a=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];D.column.prototype.translate.apply(b);b.points.forEach(function(f){[f.open,f.high,f.low,f.close,f.low].forEach(function(u,B){null!==u&&(y&&(u=b.modifyValue(u)),f[a[B]]=t.toPixels(u,!0))});f.tooltipPos[1]=f.plotHigh+t.pos-b.chart.plotTop})},drawPoints:function(){var b=this,t=b.chart,y=function(a,b,t){var f=a[0];a=a[1];"number"===typeof f[2]&&(f[2]=Math.max(t+
b,f[2]));"number"===typeof a[2]&&(a[2]=Math.min(t-b,a[2]))};b.points.forEach(function(a){var f=a.graphic,u=!f;if("undefined"!==typeof a.plotY){f||(a.graphic=f=t.renderer.path().add(b.group));t.styledMode||f.attr(b.pointAttribs(a,a.selected&&"select"));var B=f.strokeWidth();var x=B%2/2;var v=Math.round(a.plotX)-x;var A=Math.round(a.shapeArgs.width/2);var q=[["M",v,Math.round(a.yBottom)],["L",v,Math.round(a.plotHigh)]];if(null!==a.open){var E=Math.round(a.plotOpen)+x;q.push(["M",v,E],["L",v-A,E]);y(q,
B/2,E)}null!==a.close&&(E=Math.round(a.plotClose)+x,q.push(["M",v,E],["L",v+A,E]),y(q,B/2,E));f[u?"attr":"animate"]({d:q}).addClass(a.getClassName(),!0)}})},animate:null},{getClassName:function(){return x.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")}});""});I(b,"Series/CandlestickSeries.js",[b["Core/Series/Series.js"],b["Core/Options.js"],b["Core/Utilities.js"]],function(b,x,D){x=x.defaultOptions;D=D.merge;var u=b.seriesTypes.column.prototype;
b.seriesType("candlestick","ohlc",D(x.plotOptions.column,{states:{hover:{lineWidth:2}},tooltip:x.plotOptions.ohlc.tooltip,threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}),{pointAttribs:function(b,y){var a=u.pointAttribs.call(this,b,y),f=this.options,t=b.open<b.close,B=f.lineColor||this.color;a["stroke-width"]=f.lineWidth;a.fill=b.options.color||(t?f.upColor||this.color:this.color);a.stroke=b.options.lineColor||(t?f.upLineColor||B:B);y&&(b=f.states[y],a.fill=b.color||
a.fill,a.stroke=b.lineColor||a.stroke,a["stroke-width"]=b.lineWidth||a["stroke-width"]);return a},drawPoints:function(){var b=this,u=b.chart,a=b.yAxis.reversed;b.points.forEach(function(f){var t=f.graphic,y=!t;if("undefined"!==typeof f.plotY){t||(f.graphic=t=u.renderer.path().add(b.group));b.chart.styledMode||t.attr(b.pointAttribs(f,f.selected&&"select")).shadow(b.options.shadow);var x=t.strokeWidth()%2/2;var v=Math.round(f.plotX)-x;var A=f.plotOpen;var q=f.plotClose;var E=Math.min(A,q);A=Math.max(A,
q);var l=Math.round(f.shapeArgs.width/2);q=a?A!==f.yBottom:Math.round(E)!==Math.round(f.plotHigh);var m=a?Math.round(E)!==Math.round(f.plotHigh):A!==f.yBottom;E=Math.round(E)+x;A=Math.round(A)+x;x=[];x.push(["M",v-l,A],["L",v-l,E],["L",v+l,E],["L",v+l,A],["Z"],["M",v,E],["L",v,q?Math.round(a?f.yBottom:f.plotHigh):E],["M",v,A],["L",v,m?Math.round(a?f.plotHigh:f.yBottom):A]);t[y?"attr":"animate"]({d:x}).addClass(f.getClassName(),!0)}})}});""});I(b,"Mixins/OnSeries.js",[b["Core/Globals.js"],b["Core/Utilities.js"]],
function(b,x){var D=x.defined,u=x.stableSort,t=b.seriesTypes;return{getPlotBox:function(){return b.Series.prototype.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){t.column.prototype.translate.apply(this);var b=this,a=b.options,f=b.chart,x=b.points,B=x.length-1,H,v=a.onSeries;v=v&&f.get(v);a=a.onKey||"y";var A=v&&v.options.step,q=v&&v.points,E=q&&q.length,l=f.inverted,m=b.xAxis,C=b.yAxis,d=0,h;if(v&&v.visible&&E){d=(v.pointXOffset||0)+(v.barW||
0)/2;f=v.currentDataGrouping;var K=q[E-1].x+(f?f.totalRange:0);u(x,function(a,e){return a.x-e.x});for(a="plot"+a[0].toUpperCase()+a.substr(1);E--&&x[B];){var F=q[E];f=x[B];f.y=F.y;if(F.x<=f.x&&"undefined"!==typeof F[a]){if(f.x<=K&&(f.plotY=F[a],F.x<f.x&&!A&&(h=q[E+1])&&"undefined"!==typeof h[a])){var k=(f.x-F.x)/(h.x-F.x);f.plotY+=k*(h[a]-F[a]);f.y+=k*(h.y-F.y)}B--;E++;if(0>B)break}}}x.forEach(function(a,e){a.plotX+=d;if("undefined"===typeof a.plotY||l)0<=a.plotX&&a.plotX<=m.len?l?(a.plotY=m.translate(a.x,
0,1,0,1),a.plotX=D(a.y)?C.translate(a.y,0,0,0,1):0):a.plotY=(m.opposite?0:b.yAxis.len)+m.offset:a.shapeArgs={};if((H=x[e-1])&&H.plotX===a.plotX){"undefined"===typeof H.stackIndex&&(H.stackIndex=0);var p=H.stackIndex+1}a.stackIndex=p});this.onSeries=v}}});I(b,"Series/FlagsSeries.js",[b["Core/Series/Series.js"],b["Core/Globals.js"],b["Mixins/OnSeries.js"],b["Core/Renderer/SVG/SVGElement.js"],b["Core/Renderer/SVG/SVGRenderer.js"],b["Core/Utilities.js"]],function(b,x,D,u,t,y){function a(a){C[a+"pin"]=
function(d,b,f,k,g){var e=g&&g.anchorX;g=g&&g.anchorY;"circle"===a&&k>f&&(d-=Math.round((k-f)/2),f=k);var p=C[a](d,b,f,k);if(e&&g){var h=e;"circle"===a?h=d+f/2:(d=p[0],f=p[1],"M"===d[0]&&"L"===f[0]&&(h=(d[1]+f[1])/2));p.push(["M",h,b>g?b:b+k],["L",e,g]);p=p.concat(C.circle(e-1,g-1,2,2))}return p}}var f=x.noop,J=y.addEvent,B=y.defined,H=y.isNumber,v=y.merge,A=y.objectEach,q=y.wrap;y=x.Renderer;var E=x.Series,l=x.TrackerMixin,m=x.VMLRenderer,C=t.prototype.symbols;"";b.seriesType("flags","column",{pointRange:0,
allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}<br/>"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd6eb"}},style:{fontSize:"11px",fontWeight:"bold"}},{sorted:!1,noSharedTooltip:!0,allowDG:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],forceCrop:!0,init:E.prototype.init,pointAttribs:function(a,b){var d=this.options,f=a&&a.color||this.color,k=d.lineColor,g=a&&a.lineWidth;a=a&&a.fillColor||
d.fillColor;b&&(a=d.states[b].fillColor,k=d.states[b].lineColor,g=d.states[b].lineWidth);return{fill:a||f,stroke:k||f,"stroke-width":g||d.lineWidth||0}},translate:D.translate,getPlotBox:D.getPlotBox,drawPoints:function(){var a=this.points,b=this.chart,f=b.renderer,l=b.inverted,k=this.options,g=k.y,e,p=this.yAxis,z={},w=[];for(e=a.length;e--;){var c=a[e];var m=(l?c.plotY:c.plotX)>this.xAxis.len;var n=c.plotX;var r=c.stackIndex;var t=c.options.shape||k.shape;var y=c.plotY;"undefined"!==typeof y&&(y=
c.plotY+g-("undefined"!==typeof r&&r*k.stackDistance));c.anchorX=r?void 0:c.plotX;var C=r?void 0:c.plotY;var E="flag"!==t;r=c.graphic;"undefined"!==typeof y&&0<=n&&!m?(r||(r=c.graphic=f.label("",null,null,t,null,null,k.useHTML),b.styledMode||r.attr(this.pointAttribs(c)).css(v(k.style,c.style)),r.attr({align:E?"center":"left",width:k.width,height:k.height,"text-align":k.textAlign}).addClass("highcharts-point").add(this.markerGroup),c.graphic.div&&(c.graphic.div.point=c),b.styledMode||r.shadow(k.shadow),
r.isNew=!0),0<n&&(n-=r.strokeWidth()%2),t={y:y,anchorY:C},k.allowOverlapX&&(t.x=n,t.anchorX=c.anchorX),r.attr({text:c.options.title||k.title||"A"})[r.isNew?"attr":"animate"](t),k.allowOverlapX||(z[c.plotX]?z[c.plotX].size=Math.max(z[c.plotX].size,r.width):z[c.plotX]={align:E?.5:0,size:r.width,target:n,anchorX:n}),c.tooltipPos=[n,y+p.pos-b.plotTop]):r&&(c.graphic=r.destroy())}k.allowOverlapX||(A(z,function(a){a.plotX=a.anchorX;w.push(a)}),x.distribute(w,l?p.len:this.xAxis.len,100),a.forEach(function(a){var c=
a.graphic&&z[a.plotX];c&&(a.graphic[a.graphic.isNew?"attr":"animate"]({x:c.pos+c.align*c.size,anchorX:a.anchorX}),B(c.pos)?a.graphic.isNew=!1:(a.graphic.attr({x:-9999,anchorX:-9999}),a.graphic.isNew=!0))}));k.useHTML&&q(this.markerGroup,"on",function(a){return u.prototype.on.apply(a.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})},drawTracker:function(){var a=this.points;l.drawTrackerPoint.apply(this);a.forEach(function(b){var d=b.graphic;d&&J(d.element,"mouseover",function(){0<
b.stackIndex&&!b.raised&&(b._y=d.y,d.attr({y:b._y-8}),b.raised=!0);a.forEach(function(a){a!==b&&a.raised&&a.graphic&&(a.graphic.attr({y:a._y}),a.raised=!1)})})})},animate:function(a){a&&this.setClip()},setClip:function(){E.prototype.setClip.apply(this,arguments);!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup.clip(this.chart[this.sharedClipKey])},buildKDTree:f,invertGroups:f},{isValid:function(){return H(this.y)||"undefined"===typeof this.y}});C.flag=function(a,b,f,l,k){var d=k&&k.anchorX||
a;k=k&&k.anchorY||b;var e=C.circle(d-1,k-1,2,2);e.push(["M",d,k],["L",a,b+l],["L",a,b],["L",a+f,b],["L",a+f,b+l],["L",a,b+l],["Z"]);return e};a("circle");a("square");y===m&&["circlepin","flag","squarepin"].forEach(function(a){m.prototype.symbols[a]=C[a]});""});I(b,"Extensions/RangeSelector.js",[b["Core/Axis/Axis.js"],b["Core/Chart/Chart.js"],b["Core/Globals.js"],b["Core/Options.js"],b["Core/Renderer/SVG/SVGElement.js"],b["Core/Utilities.js"]],function(b,x,D,u,t,y){var a=u.defaultOptions,f=y.addEvent,
J=y.createElement,B=y.css,H=y.defined,v=y.destroyObjectProperties,A=y.discardElement,q=y.extend,E=y.fireEvent,l=y.isNumber,m=y.merge,C=y.objectEach,d=y.pick,h=y.pInt,I=y.splat;q(a,{rangeSelector:{verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputPosition:{align:"right",x:0,y:0},buttonPosition:{align:"left",x:0,y:0},labelStyle:{color:"#666666"}}});a.lang=m(a.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"From",rangeSelectorTo:"To"});var F=
function(){function k(a){this.buttons=void 0;this.buttonOptions=k.prototype.defaultButtons;this.options=void 0;this.chart=a;this.init(a)}k.prototype.clickButton=function(a,e){var p=this.chart,g=this.buttonOptions[a],k=p.xAxis[0],c=p.scroller&&p.scroller.getUnionExtremes()||k||{},h=c.dataMin,n=c.dataMax,m=k&&Math.round(Math.min(k.max,d(n,k.max))),q=g.type;c=g._range;var t,v=g.dataGrouping;if(null!==h&&null!==n){p.fixedRange=c;v&&(this.forcedDataGrouping=!0,b.prototype.setDataGrouping.call(k||{chart:this.chart},
v,!1),this.frozenStates=g.preserveDataGrouping);if("month"===q||"year"===q)if(k){q={range:g,max:m,chart:p,dataMin:h,dataMax:n};var u=k.minFromRange.call(q);l(q.newMax)&&(m=q.newMax)}else c=g;else if(c)u=Math.max(m-c,h),m=Math.min(u+c,n);else if("ytd"===q)if(k)"undefined"===typeof n&&(h=Number.MAX_VALUE,n=Number.MIN_VALUE,p.series.forEach(function(a){a=a.xData;h=Math.min(a[0],h);n=Math.max(a[a.length-1],n)}),e=!1),m=this.getYTDExtremes(n,h,p.time.useUTC),u=t=m.min,m=m.max;else{this.deferredYTDClick=
a;return}else"all"===q&&k&&(u=h,m=n);H(u)&&(u+=g._offsetMin);H(m)&&(m+=g._offsetMax);this.setSelected(a);if(k)k.setExtremes(u,m,d(e,1),null,{trigger:"rangeSelectorButton",rangeSelectorButton:g});else{var x=I(p.options.xAxis)[0];var y=x.range;x.range=c;var A=x.min;x.min=t;f(p,"load",function(){x.range=y;x.min=A})}}};k.prototype.setSelected=function(a){this.selected=this.options.selected=a};k.prototype.init=function(a){var e=this,b=a.options.rangeSelector,d=b.buttons||e.defaultButtons.slice(),g=b.selected,
c=function(){var a=e.minInput,c=e.maxInput;a&&a.blur&&E(a,"blur");c&&c.blur&&E(c,"blur")};e.chart=a;e.options=b;e.buttons=[];e.buttonOptions=d;this.unMouseDown=f(a.container,"mousedown",c);this.unResize=f(a,"resize",c);d.forEach(e.computeButtonRange);"undefined"!==typeof g&&d[g]&&this.clickButton(g,!1);f(a,"load",function(){a.xAxis&&a.xAxis[0]&&f(a.xAxis[0],"setExtremes",function(c){this.max-this.min!==a.fixedRange&&"rangeSelectorButton"!==c.trigger&&"updatedData"!==c.trigger&&e.forcedDataGrouping&&
!e.frozenStates&&this.setDataGrouping(!1,!1)})})};k.prototype.updateButtonStates=function(){var a=this,e=this.chart,b=e.xAxis[0],d=Math.round(b.max-b.min),k=!b.hasVisibleSeries,c=e.scroller&&e.scroller.getUnionExtremes()||b,f=c.dataMin,n=c.dataMax;e=a.getYTDExtremes(n,f,e.time.useUTC);var h=e.min,m=e.max,q=a.selected,t=l(q),v=a.options.allButtonsEnabled,u=a.buttons;a.buttonOptions.forEach(function(c,e){var p=c._range,g=c.type,l=c.count||1,z=u[e],w=0,r=c._offsetMax-c._offsetMin;c=e===q;var G=p>n-f,
x=p<b.minRange,y=!1,A=!1;p=p===d;("month"===g||"year"===g)&&d+36E5>=864E5*{month:28,year:365}[g]*l-r&&d-36E5<=864E5*{month:31,year:366}[g]*l+r?p=!0:"ytd"===g?(p=m-h+r===d,y=!c):"all"===g&&(p=b.max-b.min>=n-f,A=!c&&t&&p);g=!v&&(G||x||A||k);l=c&&p||p&&!t&&!y||c&&a.frozenStates;g?w=3:l&&(t=!0,w=2);z.state!==w&&(z.setState(w),0===w&&q===e&&a.setSelected(null))})};k.prototype.computeButtonRange=function(a){var e=a.type,b=a.count||1,g={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};
if(g[e])a._range=g[e]*b;else if("month"===e||"year"===e)a._range=864E5*{month:30,year:365}[e]*b;a._offsetMin=d(a.offsetMin,0);a._offsetMax=d(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin};k.prototype.setInputValue=function(a,e){var b=this.chart.options.rangeSelector,d=this.chart.time,g=this[a+"Input"];H(e)&&(g.previousValue=g.HCTime,g.HCTime=e);g.value=d.dateFormat(b.inputEditDateFormat||"%Y-%m-%d",g.HCTime);this[a+"DateBox"].attr({text:d.dateFormat(b.inputDateFormat||"%b %e, %Y",g.HCTime)})};
k.prototype.showInput=function(a){var e=this.inputGroup,b=this[a+"DateBox"];B(this[a+"Input"],{left:e.translateX+b.x+"px",top:e.translateY+"px",width:b.width-2+"px",height:b.height-2+"px",border:"2px solid silver"})};k.prototype.hideInput=function(a){B(this[a+"Input"],{border:0,width:"1px",height:"1px"});this.setInputValue(a)};k.prototype.defaultInputDateParser=function(a,e){var b=new Date;return D.isSafari?Date.parse(a.split(" ").join("T")):e?Date.parse(a+"Z"):Date.parse(a)-6E4*b.getTimezoneOffset()};
k.prototype.drawInput=function(b){function e(){var a=t.value,c=g.xAxis[0];var b=g.scroller&&g.scroller.xAxis?g.scroller.xAxis:c;var e=b.dataMin,p=b.dataMax;b=(f.inputDateParser||x)(a,g.time.useUTC);b!==t.previousValue&&(t.previousValue=b,l(b)||(b=a.split("-"),b=Date.UTC(h(b[0]),h(b[1])-1,h(b[2]))),l(b)&&(g.time.useUTC||(b+=6E4*(new Date).getTimezoneOffset()),r?b>d.maxInput.HCTime?b=void 0:b<e&&(b=e):b<d.minInput.HCTime?b=void 0:b>p&&(b=p),"undefined"!==typeof b&&c.setExtremes(r?b:c.min,r?c.max:b,
void 0,void 0,{trigger:"rangeSelectorInput"})))}var d=this,g=d.chart,k=g.renderer.style||{},c=g.renderer,f=g.options.rangeSelector,n=d.div,r="min"===b,t,v,u=this.inputGroup,x=this.defaultInputDateParser;this[b+"Label"]=v=c.label(a.lang[r?"rangeSelectorFrom":"rangeSelectorTo"],this.inputGroup.offset).addClass("highcharts-range-label").attr({padding:2}).add(u);u.offset+=v.width+5;this[b+"DateBox"]=c=c.label("",u.offset).addClass("highcharts-range-input").attr({padding:2,width:f.inputBoxWidth||90,height:f.inputBoxHeight||
17,"text-align":"center"}).on("click",function(){d.showInput(b);d[b+"Input"].focus()});g.styledMode||c.attr({stroke:f.inputBoxBorderColor||"#cccccc","stroke-width":1});c.add(u);u.offset+=c.width+(r?10:0);this[b+"Input"]=t=J("input",{name:b,className:"highcharts-range-selector",type:"text"},{top:g.plotTop+"px"},n);g.styledMode||(v.css(m(k,f.labelStyle)),c.css(m({color:"#333333"},k,f.inputStyle)),B(t,q({position:"absolute",border:0,width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:k.fontSize,
fontFamily:k.fontFamily,top:"-9999em"},f.inputStyle)));t.onfocus=function(){d.showInput(b)};t.onblur=function(){t===D.doc.activeElement&&e();d.hideInput(b);t.blur()};t.onchange=e;t.onkeypress=function(a){13===a.keyCode&&e()}};k.prototype.getPosition=function(){var a=this.chart,b=a.options.rangeSelector;a="top"===b.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+b.buttonPosition.y,inputTop:a+b.inputPosition.y-10}};k.prototype.getYTDExtremes=function(a,b,d){var e=this.chart.time,p=new e.Date(a),
c=e.get("FullYear",p);d=d?e.Date.UTC(c,0,1):+new e.Date(c,0,1);b=Math.max(b||0,d);p=p.getTime();return{max:Math.min(a||p,p),min:b}};k.prototype.render=function(b,e){var p=this,g=p.chart,k=g.renderer,c=g.container,f=g.options,n=f.exporting&&!1!==f.exporting.enabled&&f.navigation&&f.navigation.buttonOptions,l=a.lang,h=p.div,m=f.rangeSelector,q=d(f.chart.style&&f.chart.style.zIndex,0)+1;f=m.floating;var t=p.buttons;h=p.inputGroup;var u=m.buttonTheme,v=m.buttonPosition,x=m.inputPosition,y=m.inputEnabled,
A=u&&u.states,B=g.plotLeft,C=p.buttonGroup,E,D=p.options.verticalAlign,F=g.legend,H=F&&F.options,I=v.y,K=x.y,P=g.hasLoaded,Q=P?"animate":"attr",O=0,M=0;if(!1!==m.enabled){p.rendered||(p.group=E=k.g("range-selector-group").attr({zIndex:7}).add(),p.buttonGroup=C=k.g("range-selector-buttons").add(E),p.zoomText=k.text(l.rangeSelectorZoom,0,15).add(C),g.styledMode||(p.zoomText.css(m.labelStyle),u["stroke-width"]=d(u["stroke-width"],0)),p.buttonOptions.forEach(function(a,c){t[c]=k.button(a.text,0,0,function(b){var e=
a.events&&a.events.click,d;e&&(d=e.call(a,b));!1!==d&&p.clickButton(c);p.isActive=!0},u,A&&A.hover,A&&A.select,A&&A.disabled).attr({"text-align":"center"}).add(C)}),!1!==y&&(p.div=h=J("div",null,{position:"relative",height:0,zIndex:q}),c.parentNode.insertBefore(h,c),p.inputGroup=h=k.g("input-group").add(E),h.offset=0,p.drawInput("min"),p.drawInput("max")));p.zoomText[Q]({x:d(B+v.x,B)});var R=d(B+v.x,B)+p.zoomText.getBBox().width+5;p.buttonOptions.forEach(function(a,c){t[c][Q]({x:R});R+=t[c].width+
d(m.buttonSpacing,5)});B=g.plotLeft-g.spacing[3];p.updateButtonStates();n&&this.titleCollision(g)&&"top"===D&&"right"===v.align&&v.y+C.getBBox().height-12<(n.y||0)+n.height&&(O=-40);c=v.x-g.spacing[3];"right"===v.align?c+=O-B:"center"===v.align&&(c-=B/2);C.align({y:v.y,width:C.getBBox().width,align:v.align,x:c},!0,g.spacingBox);p.group.placed=P;p.buttonGroup.placed=P;!1!==y&&(O=n&&this.titleCollision(g)&&"top"===D&&"right"===x.align&&x.y-h.getBBox().height-12<(n.y||0)+n.height+g.spacing[0]?-40:0,
"left"===x.align?c=B:"right"===x.align&&(c=-Math.max(g.axisOffset[1],-O)),h.align({y:x.y,width:h.getBBox().width,align:x.align,x:x.x+c-2},!0,g.spacingBox),n=h.alignAttr.translateX+h.alignOptions.x-O+h.getBBox().x+2,c=h.alignOptions.width,l=C.alignAttr.translateX+C.getBBox().x,B=C.getBBox().width+20,(x.align===v.align||l+B>n&&n+c>l&&I<K+h.getBBox().height)&&h.attr({translateX:h.alignAttr.translateX+(g.axisOffset[1]>=-O?0:-O),translateY:h.alignAttr.translateY+C.getBBox().height+10}),p.setInputValue("min",
b),p.setInputValue("max",e),p.inputGroup.placed=P);p.group.align({verticalAlign:D},!0,g.spacingBox);b=p.group.getBBox().height+20;e=p.group.alignAttr.translateY;"bottom"===D&&(F=H&&"bottom"===H.verticalAlign&&H.enabled&&!H.floating?F.legendHeight+d(H.margin,10):0,b=b+F-20,M=e-b-(f?0:m.y)-(g.titleOffset?g.titleOffset[2]:0)-10);if("top"===D)f&&(M=0),g.titleOffset&&g.titleOffset[0]&&(M=g.titleOffset[0]),M+=g.margin[0]-g.spacing[0]||0;else if("middle"===D)if(K===I)M=0>K?e+void 0:e;else if(K||I)M=0>K||
0>I?M-Math.min(K,I):e-b+NaN;p.group.translate(m.x,m.y+Math.floor(M));!1!==y&&(p.minInput.style.marginTop=p.group.translateY+"px",p.maxInput.style.marginTop=p.group.translateY+"px");p.rendered=!0}};k.prototype.getHeight=function(){var a=this.options,b=this.group,d=a.y,f=a.buttonPosition.y,k=a.inputPosition.y;if(a.height)return a.height;a=b?b.getBBox(!0).height+13+d:0;b=Math.min(k,f);if(0>k&&0>f||0<k&&0<f)a+=Math.abs(b);return a};k.prototype.titleCollision=function(a){return!(a.options.title.text||
a.options.subtitle.text)};k.prototype.update=function(a){var b=this.chart;m(!0,b.options.rangeSelector,a);this.destroy();this.init(b);b.rangeSelector.render()};k.prototype.destroy=function(){var a=this,b=a.minInput,d=a.maxInput;a.unMouseDown();a.unResize();v(a.buttons);b&&(b.onfocus=b.onblur=b.onchange=null);d&&(d.onfocus=d.onblur=d.onchange=null);C(a,function(b,e){b&&"chart"!==e&&(b instanceof t?b.destroy():b instanceof window.HTMLElement&&A(b));b!==k.prototype[e]&&(a[e]=null)},this)};return k}();
F.prototype.defaultButtons=[{type:"month",count:1,text:"1m"},{type:"month",count:3,text:"3m"},{type:"month",count:6,text:"6m"},{type:"ytd",text:"YTD"},{type:"year",count:1,text:"1y"},{type:"all",text:"All"}];b.prototype.minFromRange=function(){var a=this.range,b=a.type,e=this.max,p=this.chart.time,f=function(a,c){var e="year"===b?"FullYear":"Month",d=new p.Date(a),f=p.get(e,d);p.set(e,d,f+c);f===p.get(e,d)&&p.set("Date",d,0);return d.getTime()-a};if(l(a)){var h=e-a;var c=a}else h=e+f(e,-a.count),
this.chart&&(this.chart.fixedRange=e-h);var m=d(this.dataMin,Number.MIN_VALUE);l(h)||(h=m);h<=m&&(h=m,"undefined"===typeof c&&(c=f(h,a.count)),this.newMax=Math.min(h+c,this.dataMax));l(e)||(h=void 0);return h};D.RangeSelector||(f(x,"afterGetContainer",function(){this.options.rangeSelector.enabled&&(this.rangeSelector=new F(this))}),f(x,"beforeRender",function(){var a=this.axes,b=this.rangeSelector;b&&(l(b.deferredYTDClick)&&(b.clickButton(b.deferredYTDClick),delete b.deferredYTDClick),a.forEach(function(a){a.updateNames();
a.setScale()}),this.getAxisMargins(),b.render(),a=b.options.verticalAlign,b.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))}),f(x,"update",function(a){var b=a.options.rangeSelector;a=this.rangeSelector;var e=this.extraBottomMargin,d=this.extraTopMargin;b&&b.enabled&&!H(a)&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=new F(this));this.extraTopMargin=this.extraBottomMargin=!1;a&&(a.render(),b=b&&b.verticalAlign||a.options&&a.options.verticalAlign,
a.options.floating||("bottom"===b?this.extraBottomMargin=!0:"middle"!==b&&(this.extraTopMargin=!0)),this.extraBottomMargin!==e||this.extraTopMargin!==d)&&(this.isDirtyBox=!0)}),f(x,"render",function(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))}),f(x,"getMargins",function(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&
(this.marginBottom+=a))}),x.prototype.callbacks.push(function(a){function b(){e=a.xAxis[0].getExtremes();h=a.legend;c=null===d||void 0===d?void 0:d.options.verticalAlign;l(e.min)&&d.render(e.min,e.max);d&&h.display&&"top"===c&&c===h.options.verticalAlign&&(k=m(a.spacingBox),k.y="vertical"===h.options.layout?a.plotTop:k.y+d.getHeight(),h.group.placed=!1,h.align(k))}var e,d=a.rangeSelector,h,k,c;if(d){var q=f(a.xAxis[0],"afterSetExtremes",function(a){d.render(a.min,a.max)});var n=f(a,"redraw",b);b()}f(a,
"destroy",function(){d&&(n(),q())})}),D.RangeSelector=F);return D.RangeSelector});I(b,"Core/Chart/StockChart.js",[b["Core/Axis/Axis.js"],b["Core/Chart/Chart.js"],b["Core/Globals.js"],b["Series/LineSeries.js"],b["Core/Series/Point.js"],b["Core/Renderer/SVG/SVGRenderer.js"],b["Core/Utilities.js"]],function(b,x,D,u,t,y,a){var f=a.addEvent,I=a.arrayMax,B=a.arrayMin,H=a.clamp,v=a.defined,A=a.extend,q=a.find,E=a.format,l=a.getOptions,m=a.isNumber,C=a.isString,d=a.merge,h=a.pick,K=a.splat;a=u.prototype;
var F=a.init,k=a.processData,g=t.prototype.tooltipFormatter;D.StockChart=D.stockChart=function(a,b,f){var e=C(a)||a.nodeName,c=arguments[e?1:0],p=c,g=c.series,m=l(),k,q=h(c.navigator&&c.navigator.enabled,m.navigator.enabled,!0);c.xAxis=K(c.xAxis||{}).map(function(a,b){return d({minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0},m.xAxis,m.xAxis&&m.xAxis[b],a,{type:"datetime",categories:null},q?{startOnTick:!1,endOnTick:!1}:null)});c.yAxis=
K(c.yAxis||{}).map(function(a,b){k=h(a.opposite,!0);return d({labels:{y:-2},opposite:k,showLastLabel:!(!a.categories&&"category"!==a.type),title:{text:null}},m.yAxis,m.yAxis&&m.yAxis[b],a)});c.series=null;c=d({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:q},scrollbar:{enabled:h(m.scrollbar.enabled,!0)},rangeSelector:{enabled:h(m.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:h(m.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},c,{isStock:!0});c.series=p.series=
g;return e?new x(a,c,f):new x(c,b)};f(u,"setOptions",function(a){var b;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?b={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(b={marker:{enabled:!1,radius:2}}),b&&(a.plotOptions[this.type]=d(a.plotOptions[this.type],b)))});f(b,"autoLabelAlign",function(a){var b=this.chart,d=this.options;b=b._labelPanes=b._labelPanes||{};var e=this.options.labels;this.chart.options.isStock&&"yAxis"===this.coll&&(d=d.top+","+d.height,!b[d]&&
e.enabled&&(15===e.x&&(e.x=0),"undefined"===typeof e.align&&(e.align="right"),b[d]=this,a.align="right",a.preventDefault()))});f(b,"destroy",function(){var a=this.chart,b=this.options&&this.options.top+","+this.options.height;b&&a._labelPanes&&a._labelPanes[b]===this&&delete a._labelPanes[b]});f(b,"getPlotLinePath",function(a){function b(a){var b="xAxis"===a?"yAxis":"xAxis";a=d.options[b];return m(a)?[c[b][a]]:C(a)?[c.get(a)]:e.map(function(a){return a[b]})}var d=this,e=this.isLinked&&!this.series?
this.linkedParent.series:this.series,c=d.chart,f=c.renderer,g=d.left,l=d.top,k,t,u,x,y=[],A=[],B=a.translatedValue,E=a.value,D=a.force;if(c.options.isStock&&!1!==a.acrossPanes&&"xAxis"===d.coll||"yAxis"===d.coll){a.preventDefault();A=b(d.coll);var F=d.isXAxis?c.yAxis:c.xAxis;F.forEach(function(a){if(v(a.options.id)?-1===a.options.id.indexOf("navigator"):1){var b=a.isXAxis?"yAxis":"xAxis";b=v(a.options[b])?c[b][a.options[b]]:c[b][0];d===b&&A.push(a)}});var I=A.length?[]:[d.isXAxis?c.yAxis[0]:c.xAxis[0]];
A.forEach(function(a){-1!==I.indexOf(a)||q(I,function(b){return b.pos===a.pos&&b.len===a.len})||I.push(a)});var J=h(B,d.translate(E,null,null,a.old));m(J)&&(d.horiz?I.forEach(function(a){var b;t=a.pos;x=t+a.len;k=u=Math.round(J+d.transB);"pass"!==D&&(k<g||k>g+d.width)&&(D?k=u=H(k,g,g+d.width):b=!0);b||y.push(["M",k,t],["L",u,x])}):I.forEach(function(a){var b;k=a.pos;u=k+a.len;t=x=Math.round(l+d.height-J);"pass"!==D&&(t<l||t>l+d.height)&&(D?t=x=H(t,l,l+d.height):b=!0);b||y.push(["M",k,t],["L",u,x])}));
a.path=0<y.length?f.crispPolyLine(y,a.lineWidth||1):null}});y.prototype.crispPolyLine=function(a,b){for(var d=0;d<a.length;d+=2){var e=a[d],c=a[d+1];e[1]===c[1]&&(e[1]=c[1]=Math.round(e[1])-b%2/2);e[2]===c[2]&&(e[2]=c[2]=Math.round(e[2])+b%2/2)}return a};f(b,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});f(b,"afterDrawCrosshair",function(a){var b,d;if(v(this.crosshair.label)&&this.crosshair.label.enabled&&this.cross){var e=this.chart,c=this.logarithmic,
f=this.options.crosshair.label,g=this.horiz,k=this.opposite,l=this.left,q=this.top,t=this.crossLabel,u=f.format,x="",y="inside"===this.options.tickPosition,B=!1!==this.crosshair.snap,C=0,D=a.e||this.cross&&this.cross.e,F=a.point;a=this.min;var H=this.max;c&&(a=c.lin2log(a),H=c.lin2log(H));c=g?"center":k?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";t||(t=this.crossLabel=e.renderer.label(null,null,null,f.shape||"callout").addClass("highcharts-crosshair-label"+(this.series[0]&&
" highcharts-color-"+this.series[0].colorIndex)).attr({align:f.align||c,padding:h(f.padding,8),r:h(f.borderRadius,3),zIndex:2}).add(this.labelGroup),e.styledMode||t.attr({fill:f.backgroundColor||this.series[0]&&this.series[0].color||"#666666",stroke:f.borderColor||"","stroke-width":f.borderWidth||0}).css(A({color:"#ffffff",fontWeight:"normal",fontSize:"11px",textAlign:"center"},f.style)));g?(c=B?F.plotX+l:D.chartX,q+=k?0:this.height):(c=k?this.width+l:0,q=B?F.plotY+q:D.chartY);u||f.formatter||(this.dateTime&&
(x="%b %d, %Y"),u="{value"+(x?":"+x:"")+"}");x=B?F[this.isXAxis?"x":"y"]:this.toValue(g?D.chartX:D.chartY);t.attr({text:u?E(u,{value:x},e):f.formatter.call(this,x),x:c,y:q,visibility:x<a||x>H?"hidden":"visible"});f=t.getBBox();if(m(t.y))if(g){if(y&&!k||!y&&k)q=t.y-f.height}else q=t.y-f.height/2;g?(b=l-f.x,d=l+this.width-f.x):(b="left"===this.labelAlign?l:0,d="right"===this.labelAlign?l+this.width:e.chartWidth);t.translateX<b&&(C=b-t.translateX);t.translateX+f.width>=d&&(C=-(t.translateX+f.width-d));
t.attr({x:c+C,y:q,anchorX:g?c:this.opposite?0:e.chartWidth,anchorY:g?this.opposite?e.chartHeight:0:q+f.height/2})}});a.init=function(){F.apply(this,arguments);this.setCompare(this.options.compare)};a.setCompare=function(a){this.modifyValue="value"===a||"percent"===a?function(b,d){var e=this.compareValue;return"undefined"!==typeof b&&"undefined"!==typeof e?(b="value"===a?b-e:b/e*100-(100===this.options.compareBase?0:100),d&&(d.change=b),b):0}:null;this.userOptions.compare=a;this.chart.hasRendered&&
(this.isDirty=!0)};a.processData=function(a){var b,d=-1,e=!0===this.options.compareStart?0:1;k.apply(this,arguments);if(this.xAxis&&this.processedYData){var c=this.processedXData;var f=this.processedYData;var g=f.length;this.pointArrayMap&&(d=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y"));for(b=0;b<g-e;b++){var h=f[b]&&-1<d?f[b][d]:f[b];if(m(h)&&c[b+e]>=this.xAxis.min&&0!==h){this.compareValue=h;break}}}};f(u,"afterGetExtremes",function(a){a=a.dataExtremes;if(this.modifyValue&&
a){var b=[this.modifyValue(a.dataMin),this.modifyValue(a.dataMax)];a.dataMin=B(b);a.dataMax=I(b)}});b.prototype.setCompare=function(a,b){this.isXAxis||(this.series.forEach(function(b){b.setCompare(a)}),h(b,!0)&&this.chart.redraw())};t.prototype.tooltipFormatter=function(a){var b=this.series.chart.numberFormatter;a=a.replace("{point.change}",(0<this.change?"+":"")+b(this.change,h(this.series.tooltipOptions.changeDecimals,2)));return g.apply(this,[a])};f(u,"render",function(){var a=this.chart;if(!(a.is3d&&
a.is3d()||a.polar)&&this.xAxis&&!this.xAxis.isRadial){var b=this.yAxis.len;if(this.xAxis.axisLine){var f=a.plotTop+a.plotHeight-this.yAxis.pos-this.yAxis.len,g=Math.floor(this.xAxis.axisLine.strokeWidth()/2);0<=f&&(b-=Math.max(g-f,0))}this.clipBox||a.hasRendered?a[this.sharedClipKey]&&(a[this.sharedClipKey].animate({width:this.xAxis.len,height:b}),a[this.sharedClipKey+"m"]&&a[this.sharedClipKey+"m"].animate({width:this.xAxis.len})):(this.clipBox=d(a.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=
b)}});f(x,"update",function(a){a=a.options;"scrollbar"in a&&this.navigator&&(d(!0,this.options.scrollbar,a.scrollbar),this.navigator.update({},!1),delete a.scrollbar)})});I(b,"masters/modules/stock.src.js",[],function(){})});
//# sourceMappingURL=stock.js.map