/*
 Highcharts JS v8.2.2 (2020-10-22)

 Marker clusters module for Highcharts

 (c) 2010-2019 Wojciech Chmiel

 License: www.highcharts.com/license
*/
(function(m){"object"===typeof module&&module.exports?(m["default"]=m,module.exports=m):"function"===typeof define&&define.amd?define("highcharts/modules/marker-clusters",["highcharts"],function(y){m(y);m.Highcharts=y;return m}):m("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(m){function y(m,v,y,A){m.hasOwnProperty(v)||(m[v]=A.apply(null,y))}m=m?m._modules:{};y(m,"Extensions/MarkerClusters.js",[m["Core/Animation/AnimationUtilities.js"],m["Core/Series/Series.js"],m["Core/Chart/Chart.js"],
m["Core/Globals.js"],m["Core/Options.js"],m["Core/Series/Point.js"],m["Core/Renderer/SVG/SVGRenderer.js"],m["Core/Utilities.js"],m["Core/Axis/Axis.js"]],function(m,v,y,A,Z,O,aa,w,ba){function I(a){var b=a.length,e=0,f=0,c;for(c=0;c<b;c++)e+=a[c].x,f+=a[c].y;return{x:e/b,y:f/b}}function P(a,b){var e=[];e.length=b;a.clusters.forEach(function(a){a.data.forEach(function(a){e[a.dataIndex]=a})});a.noise.forEach(function(a){e[a.data[0].dataIndex]=a.data[0]});return e}function Q(a,b,e,f,c){a.point&&(f&&a.point.graphic&&
(a.point.graphic.show(),a.point.graphic.attr({opacity:b}).animate({opacity:1},e)),c&&a.point.dataLabel&&(a.point.dataLabel.show(),a.point.dataLabel.attr({opacity:b}).animate({opacity:1},e)))}function R(a,b,e){a.point&&(b&&a.point.graphic&&a.point.graphic.hide(),e&&a.point.dataLabel&&a.point.dataLabel.hide())}function ca(a){a&&S(a,function(a){a.point&&a.point.destroy&&a.point.destroy()})}function K(a,b,e,f){Q(a,f,e,!0,!0);b.forEach(function(a){a.point&&a.point.destroy&&a.point.destroy()})}var T=m.animObject;
m=Z.defaultOptions;var B=w.addEvent,C=w.defined,U=w.error,V=w.isArray,L=w.isFunction,M=w.isObject,E=w.isNumber,N=w.merge,S=w.objectEach,W=w.relativeLength,G=w.syncTimeout;"";A=A.Series;v=v.seriesTypes.scatter;var X=A.prototype.generatePoints,Y=0,J=[],D={enabled:!1,allowOverlap:!0,animation:{duration:500},drillToCluster:!0,minimumClusterSize:2,layoutAlgorithm:{gridSize:50,distance:40,kmeansThreshold:100},marker:{symbol:"cluster",radius:15,lineWidth:0,lineColor:"#ffffff"},dataLabels:{enabled:!0,format:"{point.clusterPointsAmount}",
verticalAlign:"middle",align:"center",style:{color:"contrast"},inside:!0}};(m.plotOptions||{}).series=N((m.plotOptions||{}).series,{cluster:D,tooltip:{clusterFormat:"<span>Clustered points: {point.clusterPointsAmount}</span><br/>"}});aa.prototype.symbols.cluster=function(a,b,e,f){e/=2;f/=2;var c=this.arc(a+e,b+f,e-4,f-4,{start:.5*Math.PI,end:2.5*Math.PI,open:!1});var k=this.arc(a+e,b+f,e-3,f-3,{start:.5*Math.PI,end:2.5*Math.PI,innerR:e-2,open:!1});return this.arc(a+e,b+f,e-1,f-1,{start:.5*Math.PI,
end:2.5*Math.PI,innerR:e,open:!1}).concat(k,c)};v.prototype.animateClusterPoint=function(a){var b=this.xAxis,e=this.yAxis,f=this.chart,c=T((this.options.cluster||{}).animation),k=c.duration||500,h=(this.markerClusterInfo||{}).pointsState,n=(h||{}).newState,t=(h||{}).oldState,g=[],l=h=0,q=0,r=!1,u=!1;if(t&&n){var d=n[a.stateId];l=b.toPixels(d.x)-f.plotLeft;q=e.toPixels(d.y)-f.plotTop;if(1===d.parentsId.length){a=(n||{})[a.stateId].parentsId[0];var p=t[a];d.point&&d.point.graphic&&p&&p.point&&p.point.plotX&&
p.point.plotY&&p.point.plotX!==d.point.plotX&&p.point.plotY!==d.point.plotY&&(a=d.point.graphic.getBBox(),h=a.width/2,d.point.graphic.attr({x:p.point.plotX-h,y:p.point.plotY-h}),d.point.graphic.animate({x:l-(d.point.graphic.radius||0),y:q-(d.point.graphic.radius||0)},c,function(){u=!0;p.point&&p.point.destroy&&p.point.destroy()}),d.point.dataLabel&&d.point.dataLabel.alignAttr&&p.point.dataLabel&&p.point.dataLabel.alignAttr&&(d.point.dataLabel.attr({x:p.point.dataLabel.alignAttr.x,y:p.point.dataLabel.alignAttr.y}),
d.point.dataLabel.animate({x:d.point.dataLabel.alignAttr.x,y:d.point.dataLabel.alignAttr.y},c)))}else 0===d.parentsId.length?(R(d,!0,!0),G(function(){Q(d,.1,c,!0,!0)},k/2)):(R(d,!0,!0),d.parentsId.forEach(function(a){t&&t[a]&&(p=t[a],g.push(p),p.point&&p.point.graphic&&(r=!0,p.point.graphic.show(),p.point.graphic.animate({x:l-(p.point.graphic.radius||0),y:q-(p.point.graphic.radius||0),opacity:.4},c,function(){u=!0;K(d,g,c,.7)}),p.point.dataLabel&&-9999!==p.point.dataLabel.y&&d.point&&d.point.dataLabel&&
d.point.dataLabel.alignAttr&&(p.point.dataLabel.show(),p.point.dataLabel.animate({x:d.point.dataLabel.alignAttr.x,y:d.point.dataLabel.alignAttr.y,opacity:.4},c))))}),G(function(){u||K(d,g,c,.85)},k),r||G(function(){K(d,g,c,.1)},k/2))}};v.prototype.getGridOffset=function(){var a=this.chart,b=this.xAxis,e=this.yAxis;b=this.dataMinX&&this.dataMaxX?b.reversed?b.toPixels(this.dataMaxX):b.toPixels(this.dataMinX):a.plotLeft;a=this.dataMinY&&this.dataMaxY?e.reversed?e.toPixels(this.dataMinY):e.toPixels(this.dataMaxY):
a.plotTop;return{plotLeft:b,plotTop:a}};v.prototype.getScaledGridSize=function(a){var b=this.xAxis,e=!0,f=1,c=1;a=a.processedGridSize||D.layoutAlgorithm.gridSize;this.gridValueSize||(this.gridValueSize=Math.abs(b.toValue(a)-b.toValue(0)));b=b.toPixels(this.gridValueSize)-b.toPixels(0);for(b=+(a/b).toFixed(14);e&&1!==b;){var k=Math.pow(2,f);.75<b&&1.25>b?e=!1:b>=1/k&&b<1/k*2?(e=!1,c=k):b<=k&&b>k/2&&(e=!1,c=1/k);f++}return a/c/b};v.prototype.getRealExtremes=function(){var a=this.chart,b=this.xAxis,
e=this.yAxis;var f=b?b.toValue(a.plotLeft):0;b=b?b.toValue(a.plotLeft+a.plotWidth):0;var c=e?e.toValue(a.plotTop):0;a=e?e.toValue(a.plotTop+a.plotHeight):0;f>b&&(f=[f,b],b=f[0],f=f[1]);c>a&&(c=[c,a],a=c[0],c=c[1]);return{minX:f,maxX:b,minY:c,maxY:a}};v.prototype.onDrillToCluster=function(a){(a.point||a.target).firePointEvent("drillToCluster",a,function(a){var b=a.point||a.target,f=b.series.xAxis,c=b.series.yAxis,k=b.series.chart;if((b.series.options.cluster||{}).drillToCluster&&b.clusteredData){var h=
b.clusteredData.map(function(a){return a.x}).sort(function(a,b){return a-b});var n=b.clusteredData.map(function(a){return a.y}).sort(function(a,b){return a-b});b=h[0];var t=h[h.length-1];h=n[0];var g=n[n.length-1];n=Math.abs(.1*(t-b));var l=Math.abs(.1*(g-h));k.pointer.zoomX=!0;k.pointer.zoomY=!0;b>t&&(t=[t,b],b=t[0],t=t[1]);h>g&&(g=[g,h],h=g[0],g=g[1]);k.zoom({originalEvent:a,xAxis:[{axis:f,min:b-n,max:t+n}],yAxis:[{axis:c,min:h-l,max:g+l}]})}})};v.prototype.getClusterDistancesFromPoint=function(a,
b,e){var f=this.xAxis,c=this.yAxis,k=[],h;for(h=0;h<a.length;h++){var n=Math.sqrt(Math.pow(f.toPixels(b)-f.toPixels(a[h].posX),2)+Math.pow(c.toPixels(e)-c.toPixels(a[h].posY),2));k.push({clusterIndex:h,distance:n})}return k.sort(function(a,b){return a.distance-b.distance})};v.prototype.getPointsState=function(a,b,e){b=b?P(b,e):[];e=P(a,e);var f={},c;J=[];a.clusters.forEach(function(a){f[a.stateId]={x:a.x,y:a.y,id:a.stateId,point:a.point,parentsId:[]}});a.noise.forEach(function(a){f[a.stateId]={x:a.x,
y:a.y,id:a.stateId,point:a.point,parentsId:[]}});for(c=0;c<e.length;c++){a=e[c];var k=b[c];a&&k&&a.parentStateId&&k.parentStateId&&f[a.parentStateId]&&-1===f[a.parentStateId].parentsId.indexOf(k.parentStateId)&&(f[a.parentStateId].parentsId.push(k.parentStateId),-1===J.indexOf(k.parentStateId)&&J.push(k.parentStateId))}return f};v.prototype.markerClusterAlgorithms={grid:function(a,b,e,f){var c=this.xAxis,k=this.yAxis,h={},n=this.getGridOffset(),t;f=this.getScaledGridSize(f);for(t=0;t<a.length;t++){var g=
c.toPixels(a[t])-n.plotLeft;var l=k.toPixels(b[t])-n.plotTop;g=Math.floor(g/f);l=Math.floor(l/f);l=l+"-"+g;h[l]||(h[l]=[]);h[l].push({dataIndex:e[t],x:a[t],y:b[t]})}return h},kmeans:function(a,b,e,f){var c=[],k=[],h={},n=f.processedDistance||D.layoutAlgorithm.distance,t=f.iterations,g=0,l=!0,q=0,r=0;var u=[];var d;f.processedGridSize=f.processedDistance;q=this.markerClusterAlgorithms?this.markerClusterAlgorithms.grid.call(this,a,b,e,f):{};for(d in q)1<q[d].length&&(u=I(q[d]),c.push({posX:u.x,posY:u.y,
oldX:0,oldY:0,startPointsLen:q[d].length,points:[]}));for(;l;){c.map(function(a){a.points.length=0;return a});for(l=k.length=0;l<a.length;l++)q=a[l],r=b[l],u=this.getClusterDistancesFromPoint(c,q,r),u.length&&u[0].distance<n?c[u[0].clusterIndex].points.push({x:q,y:r,dataIndex:e[l]}):k.push({x:q,y:r,dataIndex:e[l]});for(d=0;d<c.length;d++)1===c[d].points.length&&(u=this.getClusterDistancesFromPoint(c,c[d].points[0].x,c[d].points[0].y),u[1].distance<n&&(c[u[1].clusterIndex].points.push(c[d].points[0]),
c[u[0].clusterIndex].points.length=0));l=!1;for(d=0;d<c.length;d++)if(u=I(c[d].points),c[d].oldX=c[d].posX,c[d].oldY=c[d].posY,c[d].posX=u.x,c[d].posY=u.y,c[d].posX>c[d].oldX+1||c[d].posX<c[d].oldX-1||c[d].posY>c[d].oldY+1||c[d].posY<c[d].oldY-1)l=!0;t&&(l=g<t-1);g++}c.forEach(function(a,b){h["cluster"+b]=a.points});k.forEach(function(a,b){h["noise"+b]=[a]});return h},optimizedKmeans:function(a,b,e,f){var c=this.xAxis,k=this.yAxis,h=f.processedDistance||D.layoutAlgorithm.gridSize,n={},t=this.getRealExtremes(),
g=(this.options.cluster||{}).marker,l,q,r;!this.markerClusterInfo||this.initMaxX&&this.initMaxX<t.maxX||this.initMinX&&this.initMinX>t.minX||this.initMaxY&&this.initMaxY<t.maxY||this.initMinY&&this.initMinY>t.minY?(this.initMaxX=t.maxX,this.initMinX=t.minX,this.initMaxY=t.maxY,this.initMinY=t.minY,n=this.markerClusterAlgorithms?this.markerClusterAlgorithms.kmeans.call(this,a,b,e,f):{},this.baseClusters=null):(this.baseClusters||(this.baseClusters={clusters:this.markerClusterInfo.clusters,noise:this.markerClusterInfo.noise}),
this.baseClusters.clusters.forEach(function(a){a.pointsOutside=[];a.pointsInside=[];a.data.forEach(function(b){q=Math.sqrt(Math.pow(c.toPixels(b.x)-c.toPixels(a.x),2)+Math.pow(k.toPixels(b.y)-k.toPixels(a.y),2));r=a.clusterZone&&a.clusterZone.marker&&a.clusterZone.marker.radius?a.clusterZone.marker.radius:g&&g.radius?g.radius:D.marker.radius;l=0<=h-r?h-r:r;q>r+l&&C(a.pointsOutside)?a.pointsOutside.push(b):C(a.pointsInside)&&a.pointsInside.push(b)});a.pointsInside.length&&(n[a.id]=a.pointsInside);
a.pointsOutside.forEach(function(b,f){n[a.id+"_noise"+f]=[b]})}),this.baseClusters.noise.forEach(function(a){n[a.id]=a.data}));return n}};v.prototype.preventClusterCollisions=function(a){var b=this.xAxis,e=this.yAxis,f=a.key.split("-").map(parseFloat),c=f[0],k=f[1],h=a.gridSize,n=a.groupedData,t=a.defaultRadius,g=a.clusterRadius,l=k*h,q=c*h,r=b.toPixels(a.x),u=e.toPixels(a.y);f=[];var d=0,p=0,m=(this.options.cluster||{}).marker,H=(this.options.cluster||{}).zones,v=this.getGridOffset(),w,y,z,A,B,E,
G;r-=v.plotLeft;u-=v.plotTop;for(z=1;5>z;z++){var F=z%2?-1:1;var x=3>z?-1:1;F=Math.floor((r+F*g)/h);x=Math.floor((u+x*g)/h);F=[x+"-"+F,x+"-"+k,c+"-"+F];for(x=0;x<F.length;x++)-1===f.indexOf(F[x])&&F[x]!==a.key&&f.push(F[x])}f.forEach(function(a){if(n[a]){n[a].posX||(E=I(n[a]),n[a].posX=E.x,n[a].posY=E.y);w=b.toPixels(n[a].posX||0)-v.plotLeft;y=e.toPixels(n[a].posY||0)-v.plotTop;var f=a.split("-").map(parseFloat);B=f[0];A=f[1];if(H)for(d=n[a].length,z=0;z<H.length;z++)d>=H[z].from&&d<=H[z].to&&(p=
C((H[z].marker||{}).radius)?H[z].marker.radius||0:m&&m.radius?m.radius:D.marker.radius);1<n[a].length&&0===p&&m&&m.radius?p=m.radius:1===n[a].length&&(p=t);G=g+p;p=0;A!==k&&Math.abs(r-w)<G&&(r=0>A-k?l+g:l+h-g);B!==c&&Math.abs(u-y)<G&&(u=0>B-c?q+g:q+h-g)}});f=b.toValue(r+v.plotLeft);x=e.toValue(u+v.plotTop);n[a.key].posX=f;n[a.key].posY=x;return{x:f,y:x}};v.prototype.isValidGroupedDataObject=function(a){var b=!1,e;if(!M(a))return!1;S(a,function(a){b=!0;if(V(a)&&a.length)for(e=0;e<a.length;e++){if(!M(a[e])||
!a[e].x||!a[e].y){b=!1;break}}else b=!1});return b};v.prototype.getClusteredData=function(a,b){var e=[],f=[],c=[],k=[],h=[],n=0,t=Math.max(2,b.minimumClusterSize||2),g,l;if(L(b.layoutAlgorithm.type)&&!this.isValidGroupedDataObject(a))return U("Highcharts marker-clusters module: The custom algorithm result is not valid!",!1,this.chart),!1;for(l in a)if(a[l].length>=t){var q=a[l];var r=Math.random().toString(36).substring(2,7)+"-"+Y++;var u=q.length;if(b.zones)for(g=0;g<b.zones.length;g++)if(u>=b.zones[g].from&&
u<=b.zones[g].to){var d=b.zones[g];d.zoneIndex=g;var p=b.zones[g].marker;var m=b.zones[g].className}var v=I(q);"grid"!==b.layoutAlgorithm.type||b.allowOverlap?v={x:v.x,y:v.y}:(g=this.options.marker||{},v=this.preventClusterCollisions({x:v.x,y:v.y,key:l,groupedData:a,gridSize:this.getScaledGridSize(b.layoutAlgorithm),defaultRadius:g.radius||3+(g.lineWidth||0),clusterRadius:p&&p.radius?p.radius:(b.marker||{}).radius||D.marker.radius}));for(g=0;g<u;g++)q[g].parentStateId=r;c.push({x:v.x,y:v.y,id:l,stateId:r,
index:n,data:q,clusterZone:d,clusterZoneClassName:m});e.push(v.x);f.push(v.y);h.push({options:{formatPrefix:"cluster",dataLabels:b.dataLabels,marker:N(b.marker,{states:b.states},p||{})}});if(this.options.data&&this.options.data.length)for(g=0;g<u;g++)M(this.options.data[q[g].dataIndex])&&(q[g].options=this.options.data[q[g].dataIndex]);n++;p=null}else for(g=0;g<a[l].length;g++)q=a[l][g],r=Math.random().toString(36).substring(2,7)+"-"+Y++,u=((this.options||{}).data||[])[q.dataIndex],e.push(q.x),f.push(q.y),
q.parentStateId=r,k.push({x:q.x,y:q.y,id:l,stateId:r,index:n,data:a[l]}),r=u&&"object"===typeof u&&!V(u)?N(u,{x:q.x,y:q.y}):{userOptions:u,x:q.x,y:q.y},h.push({options:r}),n++;return{clusters:c,noise:k,groupedXData:e,groupedYData:f,groupMap:h}};v.prototype.destroyClusteredData=function(){(this.markerClusterSeriesData||[]).forEach(function(a){a&&a.destroy&&a.destroy()});this.markerClusterSeriesData=null};v.prototype.hideClusteredData=function(){var a=this.markerClusterSeriesData,b=((this.markerClusterInfo||
{}).pointsState||{}).oldState||{},e=J.map(function(a){return(b[a].point||{}).id||""});(a||[]).forEach(function(a){a&&-1!==e.indexOf(a.id)?(a.graphic&&a.graphic.hide(),a.dataLabel&&a.dataLabel.hide()):a&&a.destroy&&a.destroy()})};v.prototype.generatePoints=function(){var a=this,b=a.chart,e=a.xAxis,f=a.yAxis,c=a.options.cluster,k=a.getRealExtremes(),h=[],n=[],t=[],g,l,q,r;if(c&&c.enabled&&a.xData&&a.yData&&!b.polar){var u=c.layoutAlgorithm.type;var d=c.layoutAlgorithm;d.processedGridSize=W(d.gridSize||
D.layoutAlgorithm.gridSize,b.plotWidth);d.processedDistance=W(d.distance||D.layoutAlgorithm.distance,b.plotWidth);b=d.kmeansThreshold||D.layoutAlgorithm.kmeansThreshold;e=Math.abs(e.toValue(d.processedGridSize/2)-e.toValue(0));f=Math.abs(f.toValue(d.processedGridSize/2)-f.toValue(0));for(r=0;r<a.xData.length;r++){if(!a.dataMaxX)if(C(p)&&C(g)&&C(m)&&C(l))E(a.yData[r])&&E(m)&&E(l)&&(p=Math.max(a.xData[r],p),g=Math.min(a.xData[r],g),m=Math.max(a.yData[r]||m,m),l=Math.min(a.yData[r]||l,l));else{var p=
g=a.xData[r];var m=l=a.yData[r]}a.xData[r]>=k.minX-e&&a.xData[r]<=k.maxX+e&&(a.yData[r]||k.minY)>=k.minY-f&&(a.yData[r]||k.maxY)<=k.maxY+f&&(h.push(a.xData[r]),n.push(a.yData[r]),t.push(r))}C(p)&&C(g)&&E(m)&&E(l)&&(a.dataMaxX=p,a.dataMinX=g,a.dataMaxY=m,a.dataMinY=l);k=L(u)?u:a.markerClusterAlgorithms?u&&a.markerClusterAlgorithms[u]?a.markerClusterAlgorithms[u]:h.length<b?a.markerClusterAlgorithms.kmeans:a.markerClusterAlgorithms.grid:function(){return!1};d=(h=k.call(this,h,n,t,d))?a.getClusteredData(h,
c):h;c.animation&&a.markerClusterInfo&&a.markerClusterInfo.pointsState&&a.markerClusterInfo.pointsState.oldState?(ca(a.markerClusterInfo.pointsState.oldState),h=a.markerClusterInfo.pointsState.newState):h={};n=a.xData.length;t=a.markerClusterInfo;d&&(a.processedXData=d.groupedXData,a.processedYData=d.groupedYData,a.hasGroupedData=!0,a.markerClusterInfo=d,a.groupMap=d.groupMap);X.apply(this);d&&a.markerClusterInfo&&((a.markerClusterInfo.clusters||[]).forEach(function(b){q=a.points[b.index];q.isCluster=
!0;q.clusteredData=b.data;q.clusterPointsAmount=b.data.length;b.point=q;B(q,"click",a.onDrillToCluster)}),(a.markerClusterInfo.noise||[]).forEach(function(b){b.point=a.points[b.index]}),c.animation&&a.markerClusterInfo&&(a.markerClusterInfo.pointsState={oldState:h,newState:a.getPointsState(d,t,n)}),c.animation?this.hideClusteredData():this.destroyClusteredData(),this.markerClusterSeriesData=this.hasGroupedData?this.points:null)}else X.apply(this)};B(y,"render",function(){(this.series||[]).forEach(function(a){if(a.markerClusterInfo){var b=
((a.markerClusterInfo||{}).pointsState||{}).oldState;(a.options.cluster||{}).animation&&a.markerClusterInfo&&0===a.chart.pointer.pinchDown.length&&"pan"!==(a.xAxis.eventArgs||{}).trigger&&b&&Object.keys(b).length&&(a.markerClusterInfo.clusters.forEach(function(b){a.animateClusterPoint(b)}),a.markerClusterInfo.noise.forEach(function(b){a.animateClusterPoint(b)}))}})});B(O,"update",function(){if(this.dataGroup)return U("Highcharts marker-clusters module: Running `Point.update` when point belongs to clustered series is not supported.",
!1,this.series.chart),!1});B(A,"destroy",v.prototype.destroyClusteredData);B(A,"afterRender",function(){var a=(this.options.cluster||{}).drillToCluster;this.markerClusterInfo&&this.markerClusterInfo.clusters&&this.markerClusterInfo.clusters.forEach(function(b){b.point&&b.point.graphic&&(b.point.graphic.addClass("highcharts-cluster-point"),a&&b.point&&(b.point.graphic.css({cursor:"pointer"}),b.point.dataLabel&&b.point.dataLabel.css({cursor:"pointer"})),C(b.clusterZone)&&b.point.graphic.addClass(b.clusterZoneClassName||
"highcharts-cluster-zone-"+b.clusterZone.zoneIndex))})});B(O,"drillToCluster",function(a){var b=(((a.point||a.target).series.options.cluster||{}).events||{}).drillToCluster;L(b)&&b.call(this,a)});B(ba,"setExtremes",function(){var a=this.chart,b=0,e;a.series.forEach(function(a){a.markerClusterInfo&&(e=T((a.options.cluster||{}).animation),b=e.duration||0)});G(function(){a.tooltip&&a.tooltip.destroy()},b)})});y(m,"masters/modules/marker-clusters.src.js",[],function(){})});
//# sourceMappingURL=marker-clusters.js.map