<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFirmasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('firmas', function (Blueprint $table) {
            $table->id();
            $table->string('ip');
            $table->string('imagen');
            $table->dateTime('created_at');
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('version_id');
            $table->foreign('user_id')->references('id')->on('users');
            $table->foreign('version_id')->references('id')->on('versiones');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('firmas');
    }
}
