<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class DocumentosRegionalesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('documentos_regionales', function (Blueprint $table) {
            $table->unsignedBigInteger('documento_id');
            $table->unsignedBigInteger('regional_id');
            $table->foreign('documento_id')->references('id')->on('documentos');
            $table->foreign('regional_id')->references('id')->on('regionales');
            $table->primary(['documento_id', 'regional_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('documentos_regionales');
    }
}
