<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCargosDocumentosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cargos_documentos', function (Blueprint $table) {
            $table->unsignedBigInteger('cargo_id');
            $table->unsignedBigInteger('documento_id');
            $table->foreign('cargo_id')->references('id')->on('cargos');
            $table->foreign('documento_id')->references('id')->on('documentos');
            $table->primary(['cargo_id', 'documento_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cargos_documentos');
    }
}
