<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('nombre');
            $table->string('documento')->unique();
            $table->string('password');
            $table->string('correo');
            $table->string('telefono');
            $table->unsignedBigInteger('cargo_id');
            $table->unsignedBigInteger('regional_id')->nullable();
            $table->unsignedBigInteger('rol_id');
            $table->rememberToken();
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('cargo_id')->references('id')->on('cargos');
            $table->foreign('regional_id')->references('id')->on('regionales');
            $table->foreign('rol_id')->references('id')->on('roles');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
