<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Version extends Model
{
    use SoftDeletes;

    protected $table = 'versiones';

    protected $fillable = [
        'id', 'version', 'tipo', 'url', 'documento_id', 'created_at', 'updated_at'
    ];
    
    public function documento() {
        return $this->belongsTo('App\Documento', 'documento_id', 'id');
    }
    
    public function firmas() {
        return $this->hasMany('App\Firma', 'version_id', 'id');
    }
}
