<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use Notifiable;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'nombre', 'documento', 'password', 'correo', 'telefono', 'cargo_id', 'regional_id', 'rol_id', 'created_at', 'updated_at', 'deleted_at'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];
    
    
    public function cargo(){
        return $this->belongsTo('App\Cargo', 'cargo_id', 'id');
    }
    
    public function regional(){
        return $this->belongsTo('App\Regional', 'regional_id', 'id');
    }
    
    public function rol(){
        return $this->belongsTo('App\Rol', 'rol_id', 'id');
    }
    
    public function firmas() {
        return $this->hasMany('App\Firma', 'user_id', 'id');
    }
    
    public function auditorias() {
        return $this->hasMany('App\Auditoria', 'user_id', 'id');
    }
}
