<?php

namespace App\Listeners;

use Illuminate\Auth\Events\Logout;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Auth;
use App\Auditoria;
use Session;

class LogSuccessfulLogout
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  Logout  $event
     * @return void
     */
    public function handle(Logout $event)
    {
        $auditoria = new Auditoria();
        $auditoria->modulo = 'Autenticación';
        $auditoria->observacion = 'Cierre de Sesión.';
        $auditoria->user_id = Auth::id();
        $auditoria->accion_id = 2;
        $auditoria->ip = Session::has('ip') ? Session::get('ip') : '';
        $auditoria->ip_avicampo = \Request::ip();
        $auditoria->save();
    }
}
