<?php

namespace App\Listeners;

use Illuminate\Auth\Events\Login;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Http\Request;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Auth;
use App\Auditoria;
use Session;

class LogSuccessfulLogin
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    /**
     * Handle the event.
     *
     * @param  Login  $event
     * @return void
     */
    public function handle(Login $event)
    {
        if (isset($this->request->ip)) {
            Session::put('ip', $this->request->ip);
        }

        $auditoria = new Auditoria();
        $auditoria->modulo = 'Autenticación';
        $auditoria->observacion = 'Inicio de Sesión.';
        $auditoria->user_id = Auth::id();
        $auditoria->accion_id = 1;
        $auditoria->ip = $this->request->ip ? $this->request->ip : '';
        $auditoria->ip_avicampo = \Request::ip();
        $auditoria->save();
    }
}
