<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Auditoria;
use App\User;
use Carbon\Carbon;
use Session;

class ContrasenaController extends Controller
{
    // Middleware que valida si el usuario está autenticado antes de acceder a cualquier método
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function password() {
        $usuario = Auth::user();
        return view('usuarios.contrasena')->with(compact('usuario'));
    }

    public function save(Request $request) {
        if (Hash::check($request->password_old, Auth::user()->password)) {
            try {
                // Inicia la tansacción
                DB::beginTransaction();
    
                // Guarda la acción en la tabla de auditorias
                $auditoria = new Auditoria();
                $auditoria->modulo = 'Usuarios';
                $auditoria->observacion = 'Cambio de contraseña';
                $auditoria->user_id = Auth::id();
                $auditoria->accion_id = 5;
                $auditoria->ip = Session::has('ip') ? Session::get('ip') : '';
                $auditoria->ip_avicampo = \Request::ip();
                $auditoria->save();
    
                // Borra al usuario
                Auth::user()->password = Hash::make($request->password);
                Auth::user()->save();
    
                // Confirma los cambios realizados en la BD y redirige a la vista del usuario
                DB::commit();
                return redirect()->route('mis-datos');
            } catch (\Exception $exc) {
                // En caso de fallar reversa los cambios realizados en la BD
                DB::rollback();
                report($exc);

                // Se crea el mensaje de error
                $titulo = 'Error al cambiar la contraseña';
                $mensaje = 'Hubo un error al intentar cambiar la contraseña. Por favor intente más tarde.';
                $fecha = Carbon::now();
                Session::put('error_general', compact('titulo', 'mensaje', 'fecha'));
                return back();
            }
        } else {
            // Se crea el mensaje de error
            $titulo = 'Error en la contraseña';
            $mensaje = 'La contraseña actual es incorrecta.';
            $fecha = Carbon::now();
            Session::put('error_general', compact('titulo', 'mensaje', 'fecha'));
            return back();
        }
    }

    public function restart(Request $request) {
        if (Auth::user()->rol_id >= 3)
            abort(403);

        $usuario = User::where('documento', $request->documento)->firstOrFail();
        if (Auth::user()->rol_id <= $usuario->rol_id) {
            try {
                // Inicia la tansacción
                DB::beginTransaction();
    
                // Guarda la acción en la tabla de auditorias
                $auditoria = new Auditoria();
                $auditoria->modulo = 'Usuarios';
                $auditoria->observacion = 'Se reinicia la contraseña del usuario ' . $usuario->nombre . ': Id => ' . $usuario->id . ', Documento => ' . $usuario->documento . '.' ;
                $auditoria->user_id = Auth::id();
                $auditoria->accion_id = 5;
                $auditoria->usuario_id = $usuario->id;
                $auditoria->ip = Session::has('ip') ? Session::get('ip') : '';
                $auditoria->ip_avicampo = \Request::ip();
                $auditoria->save();
    
                // Reinicia la contraseña
                $usuario->password = Hash::make($usuario->documento);
                $usuario->save();
    
                // Confirma los cambios realizados en la BD y redirige a la vista del usuario
                DB::commit();
                return response()->json(compact('usuario'), 200);
            } catch (\Exception $exc) {
                // En caso de fallar reversa los cambios realizados en la BD
                DB::rollback();
                report($exc);
                $success = false;
                return response()->json(compact('version'), 400);
            }
        } else {
            return response()->json(compact('version'), 400);
        }
    }
}
