<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Firma;
use App\Version;
use Session;

class ArchivosController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function __invoke($ruta)
    {
        if (!Storage::disk('private')->exists($ruta)) {
            abort(404);
        }

        if (str_contains($ruta, 'documentos/')) {
            $version = Version::where('url', $ruta)->firstOrFail();
            $validacionRegional = true;
            if (Auth::user()->regional_id) {
                $validacionRegional = DB::table('documentos_regionales')
                    ->where('documento_id', $version->documento_id)
                    ->where('regional_id', Auth::user()->regional_id)
                    ->first();
            }
            $validacionCargo = DB::table('cargos_documentos')
                ->where('cargo_id', Auth::user()->cargo->id)
                ->where('documento_id', $version->documento_id)
                ->first();
            
            if (($validacionCargo && $validacionRegional) || Auth::user()->rol_id < 4) {
                $local_path = config('filesystems.disks.private.root') . DIRECTORY_SEPARATOR . $ruta;
            } else {
                abort(404);
            }
        } else if (str_contains($ruta, 'firmas/')) {
            $firma = Firma::where('imagen', $ruta)->firstOrFail();
            if (Auth::user()->id == $firma->usuario->id || Auth::user()->rol_id < 4) {
                $local_path = config('filesystems.disks.private.root') . DIRECTORY_SEPARATOR . $ruta;
            } else {
                abort(404);
            }
        }

        return response()->file($local_path);
    }
}
