<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Firma extends Model
{
    protected $table = 'firmas';
    public $timestamps = false;

    protected $fillable = [
        'id', 'ip', 'ip_avicampo', 'imagen', 'created_at', 'user_id', 'version_id',
    ];
    
    public function usuario() {
        return $this->belongsTo('App\User', 'user_id', 'id');
    }
    
    public function version() {
        return $this->belongsTo('App\Version', 'version_id', 'id');
    }
}
