<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Documento extends Model
{
    use SoftDeletes;

    protected $table = 'documentos';

    protected $fillable = [
        'id', 'codigo', 'descripcion', 'descargar', 'firmar', 'categoria_id', 'created_at', 'updated_at', 'deleted_at'
    ];
    
    public function categoria() {
        return $this->belongsTo('App\Categoria', 'categoria_id', 'id');
    }
    
    public function version() {
        return $this->hasOne('App\Version', 'documento_id', 'id')->whereNull('deleted_at')->orderBy('version', 'desc');
    }
    
    public function versiones() {
        return $this->hasMany('App\Version', 'documento_id', 'id');
    }

    public function regionales() {
        return $this->belongsToMany('App\Regional', 'documentos_regionales', 'documento_id', 'regional_id');
    }

    public function cargos() {
        return $this->belongsToMany('App\Cargo', 'cargos_documentos', 'documento_id', 'cargo_id');
    }

    public function firmas() {
        return $this->hasManyThrough('App\Firma', 'App\Version', 'documento_id', 'version_id', 'id', 'id');
    }

    
    // Relaciones con condicionales diferentes
    public function getProcesoAttribute() {
        return Proceso::where('procesos.codigo', substr($this->codigo, 6, 2))->first();
    }
}
