<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Departamento extends Model
{
    protected $table = 'departamentos';

    protected $fillable = [
        'id', 'descripcion', 'created_at', 'updated_at'
    ];
    
    public function areas() {
        return $this->hasMany('App\Area', 'departamento_id');
    }

    public function cargos() {
        return $this->hasManyThrough('App\Cargo', 'App\Area', 'departamento_id', 'area_id', 'id', 'id');
    }
}
