<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Cargo extends Model
{
    use SoftDeletes;

    protected $table = 'cargos';

    protected $fillable = [
        'id', 'codigo', 'descripcion', 'area_id', 'created_at', 'updated_at', 'deleted_at'
    ];
    
    public function area() {
        return $this->belongsTo('App\Area', 'area_id', 'id');
    }
    
    public function documentos() {
        return $this->belongsToMany('App\Documento', 'cargos_documentos', 'cargo_id', 'documento_id');
    }
    
    public function usuarios() {
        return $this->hasMany('App\User', 'cargo_id');
    }
}
