<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Auditoria extends Model
{
    public $timestamps = false;
    protected $table = 'auditorias';

    protected $fillable = [
        'id', 'observacion', 'modulo', 'ip', 'ip_avicampo', 'user_id', 'accion_id', 'documento_id', 'usuario_id', 'created_at'
    ];
    
    public function usuario() {
        return $this->belongsTo('App\User', 'user_id', 'id');
    }
    
    public function accion() {
        return $this->belongsTo('App\Accion', 'accion_id', 'id');
    }
    
    public function documento() {
        return $this->belongsTo('App\Documento', 'documento_id', 'id');
    }
    
    public function usuario2() {
        return $this->belongsTo('App\User', 'usuario_id', 'id');
    }
}
