<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Area extends Model
{
    protected $table = 'areas';

    protected $fillable = [
        'id', 'descripcion', 'departamento_id', 'created_at', 'updated_at'
    ];
    
    public function departamento() {
        return $this->belongsTo('App\Departamento', 'departamento_id', 'id');
    }
    
    public function cargos() {
        return $this->hasMany('App\Cargo', 'area_id');
    }
}
